/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.schema.GreqlSchema;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.template.TemplateSchema;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class GReTLRunner {
    static final int MAX_VISUALIZATION_SIZE = Integer.parseInt(System.getProperty("GretlMaxVizSize", "400"));
    private OptionHandler oh = null;

    public GReTLRunner() {
        String string = "java " + GReTLRunner.class.getName();
        String string2 = JGraLab.getInfo(false);
        this.oh = new OptionHandler(string, string2);
        Option option = new Option("t", "transformation", true, "(required) The GReTL transformation that should be executed.");
        option.setArgName("gretl-file");
        option.setRequired(true);
        this.oh.addOption(option);
        Option option2 = new Option("s", "schema", true, "(optional) The name of the target schema. Defaults to foo.bar.BazSchema.");
        option2.setArgName("schema-name");
        option2.setRequired(false);
        this.oh.addOption(option2);
        Option option3 = new Option("g", "graphclass", true, "(optional) The name of the target graph class. Defaults to BazGraph.");
        option3.setArgName("graphclass");
        option3.setRequired(false);
        this.oh.addOption(option3);
        Option option4 = new Option("z", "visualize", false, "(optional) Additionally create a PDF viz of the output graph.");
        option4.setRequired(false);
        this.oh.addOption(option4);
        Option option5 = new Option("r", "reverse-edges", false, "(optional) When -z is given, print edges pointing bottom-up.");
        option5.setRequired(false);
        this.oh.addOption(option5);
        Option option6 = new Option("d", "debug", false, "(optional) Print the target graph after each transformation op.");
        option6.setRequired(false);
        this.oh.addOption(option6);
        Option option7 = new Option("o", "output", true, "(optional) The file to store the target graph to.  If many input models are to be transformed, this has no effect.");
        option7.setRequired(false);
        option6.setArgName("target-graph-file");
        this.oh.addOption(option7);
        Option option8 = new Option("u", "use-source-schema", false, "(optional) Use the source schema as target schema. In that case, no schema modifications may be performed by the transformation.");
        option8.setRequired(false);
        this.oh.addOption(option8);
        Option option9 = new Option("i", "in-place", false, "(optional) Use the source graph as target graph. In that case, no schema modifications may be performed by the transformation.");
        option9.setRequired(false);
        this.oh.addOption(option9);
        this.oh.setArgumentCount(-2);
        this.oh.setArgumentName("input-graph");
        this.oh.setOptionalArgument(false);
    }

    public void exec(String[] stringArray) throws GraphIOException, IOException {
        CommandLine commandLine = this.oh.parse(stringArray);
        if (commandLine.hasOption('d')) {
            Transformation.DEBUG_EXECUTION = true;
            Transformation.DEBUG_REVERSE_EDGES = commandLine.hasOption('r');
        }
        String string = commandLine.hasOption('s') ? commandLine.getOptionValue('s') : "foo.bar.BazSchema";
        String string2 = commandLine.hasOption('g') ? commandLine.getOptionValue('g') : "BazGraph";
        Schema schema = this.getExistingSchema(string);
        Context context = schema != null ? new Context(schema) : new Context(string, string2);
        if (commandLine.getArgs().length == 0) {
            if (commandLine.hasOption('u') || commandLine.hasOption('i')) {
                System.err.println("Options -u and -i cannot be used if no source graph is given.");
                this.oh.printHelpAndExit(1);
            }
            Graph graph = this.executeTransformation(context, new File(commandLine.getOptionValue('t')));
            String string3 = null;
            string3 = commandLine.hasOption('o') ? commandLine.getOptionValue('o') : "target_graph.tg";
            this.saveTargetGraph(graph, string3, commandLine);
        } else {
            for (String string4 : commandLine.getArgs()) {
                Graph graph = GraphIO.loadGraphFromFile(string4, ImplementationType.GENERIC, (ProgressFunction)new ConsoleProgressFunction("Loading"));
                if (commandLine.hasOption('u')) {
                    context = new Context(graph.getSchema());
                } else if (commandLine.hasOption('i')) {
                    context = new Context(graph.getSchema());
                    context.setTargetGraph(graph);
                }
                context.setSourceGraph(graph);
                Graph graph2 = this.executeTransformation(context, new File(commandLine.getOptionValue('t')));
                String string5 = null;
                if (commandLine.hasOption('o') && commandLine.getArgs().length == 1) {
                    string5 = commandLine.getOptionValue('o');
                } else {
                    File file = new File(string4);
                    string5 = file.getParent() + File.separator + "target_" + file.getName();
                }
                this.saveTargetGraph(graph2, string5, commandLine);
            }
        }
        System.out.println("Fini.");
    }

    private Graph executeTransformation(Context context, File file) {
        ExecuteTransformation executeTransformation = new ExecuteTransformation(context, file);
        boolean bl = context.outermost;
        if (bl) {
            System.out.print("Executing transformation " + executeTransformation.getName() + "... ");
        }
        long l = System.currentTimeMillis();
        Graph graph = (Graph)executeTransformation.execute();
        if (bl) {
            System.out.println("Finished (" + (System.currentTimeMillis() - l) + "ms)");
        }
        return graph;
    }

    private Schema getExistingSchema(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("instance", new Class[0]);
            return (Schema)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void saveTargetGraph(Graph graph, String string, CommandLine commandLine) throws GraphIOException, IOException {
        GraphIO.saveGraphToFile(graph, string, (ProgressFunction)new ConsoleProgressFunction("Saving"));
        if (commandLine.hasOption('z')) {
            if (graph.getVCount() + graph.getECount() > MAX_VISUALIZATION_SIZE) {
                System.err.println("Sorry, graph is too big to be dotted.");
            } else {
                String string2 = string.replaceFirst("\\.tg(\\.gz)?$", ".pdf");
                Tg2Dot.convertGraph(graph, string2, commandLine.hasOption('r'), GraphVizOutputFormat.PDF);
            }
        }
    }

    public static void main(String[] stringArray) throws GraphIOException, IOException {
        GReTLRunner gReTLRunner = new GReTLRunner();
        gReTLRunner.exec(stringArray);
    }

    static {
        JGraLab.setLogLevel(Level.OFF);
        GreqlSchema.instance().createGraph(ImplementationType.STANDARD);
        GreqlQuery.createQuery("from x: list(1..10) with x = 5 reportSet x end").evaluate();
        TemplateSchema.instance().createGraph(ImplementationType.STANDARD);
    }
}

