/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.GReTLRunner;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class Transformation<T> {
    public static boolean DEBUG_EXECUTION = Boolean.parseBoolean(System.getProperty("debugGReTLExecution", "false"));
    public static boolean DEBUG_REVERSE_EDGES = false;
    private static int EXECUTION_STEP = 1;
    protected Context context;
    protected static Logger logger = JGraLab.getLogger(Transformation.class);

    private final void invokeHooks(Class<? extends Annotation> clazz) {
        Class<?> clazz2 = this.getClass();
        while (Transformation.class.isAssignableFrom(clazz2)) {
            for (Method method : clazz2.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(clazz)) continue;
                try {
                    method.setAccessible(true);
                    method.invoke((Object)this, new Object[0]);
                }
                catch (Exception exception) {
                    logger.severe("Couldn't run @" + clazz.getSimpleName() + " method " + method.getName() + " of " + clazz2.getSimpleName() + ".");
                    exception.printStackTrace();
                }
            }
            clazz2 = clazz2.getSuperclass();
        }
    }

    protected Transformation(Context context) {
        this.context = context;
    }

    protected Transformation() {
    }

    public final void setContext(Context context) {
        this.context = context;
    }

    public final T execute() {
        long l = System.currentTimeMillis();
        if (this.context == null) {
            throw new GReTLException("No Context set for " + this);
        }
        this.invokeHooks(Before.class);
        T t = null;
        if (this.context.outermost) {
            EXECUTION_STEP = 1;
            this.context.phase = Context.TransformationPhase.SCHEMA;
            this.context.outermost = false;
            if (this.context.getTargetSchema() == null) {
                logger.info("Starting Schema creation phase...");
                this.context.createTargetSchema();
                this.transform();
            } else {
                logger.info("Target Schema exists. Skipping schema creation phase...");
            }
            this.context.ensureAllMappings();
            if (this.context.targetGraph == null) {
                logger.info("Creating a new target graph...");
                this.context.createTargetGraph();
            } else if (this.context.targetGraph.getSchema().getQualifiedName().equals(this.context.targetSchema.getQualifiedName())) {
                logger.info("Using a preset target graph...");
            } else {
                throw new GReTLException(this.context, "Preset target graph has wrong schema '" + this.context.targetGraph.getSchema().getQualifiedName() + "'. Expected was '" + this.context.targetSchema.getQualifiedName() + "'.");
            }
            logger.info("SCHEMA Phase took " + (System.currentTimeMillis() - l) + "ms.");
            l = System.currentTimeMillis();
            this.context.phase = Context.TransformationPhase.GRAPH;
            logger.info("Starting instance creation phase...");
            t = this.transform();
            if (DEBUG_EXECUTION) {
                this.context.validateMappings();
            }
            logger.info("GRAPH Phase took " + (System.currentTimeMillis() - l) + "ms.");
        } else {
            t = this.transform();
            Graph graph = this.context.targetGraph;
            if (DEBUG_EXECUTION && graph.getVCount() + graph.getECount() < GReTLRunner.MAX_VISUALIZATION_SIZE) {
                try {
                    String string = this.getClass().getSimpleName();
                    if (string.isEmpty()) {
                        string = "$anonymous$";
                    }
                    Tg2Dot.convertGraph(this.context.getTargetGraph(), "__debug_" + EXECUTION_STEP++ + "_" + string + ".pdf", DEBUG_REVERSE_EDGES, GraphVizOutputFormat.PDF);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.invokeHooks(After.class);
        return t;
    }

    protected abstract T transform();

    protected final BooleanDomain getBooleanDomain() {
        return this.context.targetSchema.getBooleanDomain();
    }

    protected final IntegerDomain getIntegerDomain() {
        return this.context.targetSchema.getIntegerDomain();
    }

    protected final LongDomain getLongDomain() {
        return this.context.targetSchema.getLongDomain();
    }

    protected final StringDomain getStringDomain() {
        return this.context.targetSchema.getStringDomain();
    }

    protected final DoubleDomain getDoubleDomain() {
        return this.context.targetSchema.getDoubleDomain();
    }

    protected final void setGReQLVariable(String string, Object object) {
        if (this.context.getPhase() != Context.TransformationPhase.GRAPH) {
            return;
        }
        this.context.setGReQLVariable(string, object);
    }

    protected final void setGReQLVariable(String string, String string2) {
        if (this.context.getPhase() != Context.TransformationPhase.GRAPH) {
            return;
        }
        this.context.setGReQLVariable(string, string2);
    }

    protected final void setGReQLHelper(String string, String string2) {
        if (this.context.getPhase() != Context.TransformationPhase.GRAPH) {
            return;
        }
        this.context.setGReQLHelper(string, string2);
    }

    protected final void addGReQLImport(String string) {
        if (this.context.getPhase() != Context.TransformationPhase.GRAPH) {
            return;
        }
        this.context.addGReQLImport(string);
    }

    protected final VertexClass vc(String string) {
        VertexClass vertexClass = this.context.targetSchema.getGraphClass().getVertexClass(string);
        if (vertexClass == null) {
            throw new GReTLException("There's no target VertexClass '" + string + "'.");
        }
        return vertexClass;
    }

    protected final EdgeClass ec(String string) {
        EdgeClass edgeClass = this.context.targetSchema.getGraphClass().getEdgeClass(string);
        if (edgeClass == null) {
            throw new GReTLException(this.context, "There's no target EdgeClass '" + string + "'.");
        }
        return edgeClass;
    }

    protected final AttributedElementClass<?, ?> aec(String string) {
        Object t = this.context.targetSchema.getAttributedElementClass(string);
        if (t == null) {
            throw new GReTLException(this.context, "There's no target AttributedElementClass '" + string + "'.");
        }
        return t;
    }

    protected final GraphElementClass<?, ?> gec(String string) {
        GraphElementClass<?, ?> graphElementClass = this.context.targetSchema.getGraphClass().getGraphElementClass(string);
        if (graphElementClass == null) {
            throw new GReTLException(this.context, "There's no target GraphElementClass '" + string + "'.");
        }
        return graphElementClass;
    }

    protected final Attribute attr(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        Object t = this.context.getTargetSchema().getAttributedElementClass(string2);
        if (t == null) {
            throw new GReTLException(this.context, "There's no target AttributedElementClass '" + string2 + "'.");
        }
        String string3 = string.substring(n + 1);
        Attribute attribute = t.getAttribute(string3);
        if (attribute == null) {
            throw new GReTLException(this.context, "There's no target Attribute '" + string3 + "' in AttributedElementClass '" + string2 + "'.");
        }
        return attribute;
    }

    protected Domain domain(String string) {
        Domain domain = this.context.getTargetSchema().getDomain(string);
        if (domain == null) {
            throw new GReTLException(this.context, "There's no target Domain '" + string + "'.");
        }
        return domain;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface Before {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface After {
    }
}

