/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public abstract class GraphFactoryImpl
implements GraphFactory {
    protected Constructor<? extends Graph> graphConstructor;
    protected HashMap<EdgeClass, Constructor<? extends Edge>> edgeMap;
    protected HashMap<VertexClass, Constructor<? extends Vertex>> vertexMap;
    protected Schema schema;
    protected ImplementationType implementationType;
    protected boolean graphCreated;

    protected GraphFactoryImpl(Schema schema, ImplementationType implementationType) {
        this.schema = schema;
        this.implementationType = implementationType;
    }

    protected void createMaps() {
        this.edgeMap = new HashMap();
        this.vertexMap = new HashMap();
    }

    @Override
    public ImplementationType getImplementationType() {
        return this.implementationType;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setGraphImplementationClass(GraphClass graphClass, Class<? extends Graph> clazz) {
        if (this.graphCreated) {
            throw new IllegalStateException("Can't change implementation class after a graph was created.");
        }
        Class clazz2 = graphClass.getSchemaClass();
        if (this.isSuperclassOrEqual(clazz2, clazz)) {
            try {
                Class[] classArray = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
                this.graphConstructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SchemaClassAccessException("Unable to locate constructor for graphclass " + clazz.getName(), noSuchMethodException);
            }
        } else {
            throw new SchemaException(clazz.getCanonicalName() + " does not implement " + clazz2.getCanonicalName());
        }
    }

    @Override
    public <G extends Graph> G createGraph(GraphClass graphClass, String string, int n, int n2) {
        try {
            Graph graph = this.graphConstructor.newInstance(string, n, n2);
            graph.setGraphFactory(this);
            this.graphCreated = true;
            return (G)graph;
        }
        catch (Exception exception) {
            throw new SchemaClassAccessException("Cannot create graph of class " + this.graphConstructor.getDeclaringClass().getCanonicalName(), exception);
        }
    }

    @Override
    public <E extends Edge> E createEdge(EdgeClass edgeClass, int n, Graph graph, Vertex vertex, Vertex vertex2) {
        try {
            if (!((InternalGraph)graph).isLoading() && graph.hasECARuleManager()) {
                graph.getECARuleManager().fireBeforeCreateEdgeEvents(edgeClass);
            }
            Edge edge = edgeClass.equals(graph.getGraphClass().getTemporaryEdgeClass()) ? graph.createTemporaryEdge(vertex, vertex2) : (vertex.isTemporary() || vertex2.isTemporary() ? graph.createTemporaryEdge(edgeClass, vertex, vertex2) : this.edgeMap.get(edgeClass).newInstance(n, graph, vertex, vertex2));
            if (!((InternalGraph)graph).isLoading() && graph.hasECARuleManager()) {
                graph.getECARuleManager().fireAfterCreateEdgeEvents(edge);
            }
            return (E)edge;
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof GraphException) {
                throw new GraphException(exception.getCause().getLocalizedMessage(), exception);
            }
            throw new SchemaClassAccessException("Cannot create edge of class " + edgeClass.getQualifiedName(), exception);
        }
    }

    @Override
    public <V extends Vertex> V createVertex(VertexClass vertexClass, int n, Graph graph) {
        try {
            if (!((InternalGraph)graph).isLoading() && graph.hasECARuleManager()) {
                graph.getECARuleManager().fireBeforeCreateVertexEvents(vertexClass);
            }
            Vertex vertex = vertexClass.equals(graph.getGraphClass().getTemporaryVertexClass()) ? graph.createTemporaryVertex() : this.vertexMap.get(vertexClass).newInstance(n, graph);
            if (!((InternalGraph)graph).isLoading() && graph.hasECARuleManager()) {
                graph.getECARuleManager().fireAfterCreateVertexEvents(vertex);
            }
            return (V)vertex;
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof GraphException) {
                throw new GraphException(exception.getCause().getLocalizedMessage(), exception);
            }
            throw new SchemaClassAccessException("Cannot create vertex of class " + vertexClass.getQualifiedName(), exception);
        }
    }

    @Override
    public void setVertexImplementationClass(VertexClass vertexClass, Class<? extends Vertex> clazz) {
        if (this.graphCreated) {
            throw new IllegalStateException("Can't change implementation class after a graph was created.");
        }
        Class clazz2 = vertexClass.getSchemaClass();
        if (this.isSuperclassOrEqual(clazz2, clazz)) {
            try {
                Class[] classArray = new Class[]{Integer.TYPE, Graph.class};
                this.vertexMap.put(vertexClass, clazz.getConstructor(classArray));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SchemaClassAccessException("Unable to locate default constructor for vertexclass" + clazz, noSuchMethodException);
            }
        } else {
            throw new SchemaException(clazz.getCanonicalName() + " does not implement " + clazz2.getCanonicalName());
        }
    }

    @Override
    public void setEdgeImplementationClass(EdgeClass edgeClass, Class<? extends Edge> clazz) {
        if (this.graphCreated) {
            throw new IllegalStateException("Can't change implementation class after a graph was created.");
        }
        Class clazz2 = edgeClass.getSchemaClass();
        if (this.isSuperclassOrEqual(clazz2, clazz)) {
            try {
                Class[] classArray = new Class[]{Integer.TYPE, Graph.class, Vertex.class, Vertex.class};
                this.edgeMap.put(edgeClass, clazz.getConstructor(classArray));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SchemaClassAccessException("Unable to locate default constructor for edgeclass" + clazz, noSuchMethodException);
            }
        } else {
            throw new SchemaException(clazz.getCanonicalName() + " does not implement " + clazz2.getCanonicalName());
        }
    }

    protected boolean isSuperclassOrEqual(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (this.implementsInterface(clazz2, clazz)) {
            return true;
        }
        while (clazz2.getSuperclass() != null) {
            if (clazz2.getSuperclass() == clazz) {
                return true;
            }
            if (this.implementsInterface(clazz2, clazz)) {
                return true;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return false;
    }

    protected boolean implementsInterface(Class<?> clazz, Class<?> clazz2) {
        Class<?>[] classArray;
        for (Class<?> clazz3 : classArray = clazz.getInterfaces()) {
            if (clazz3 != clazz2) continue;
            return true;
        }
        return false;
    }
}

