/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.std;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.TemporaryEdge;
import de.uni_koblenz.jgralab.TemporaryVertex;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.exception.TemporaryGraphElementException;
import de.uni_koblenz.jgralab.impl.GraphBaseImpl;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TemporaryVertexImpl
extends VertexImpl
implements TemporaryVertex {
    private HashMap<String, Object> attributes = new HashMap();
    private VertexClass preliminaryType;

    protected TemporaryVertexImpl(int n, Graph graph) {
        super(n, graph);
    }

    protected TemporaryVertexImpl(int n, Graph graph, VertexClass vertexClass) {
        super(n, graph);
        this.preliminaryType = vertexClass;
    }

    @Override
    public VertexClass getAttributedElementClass() {
        return this.graph.getGraphClass().getTemporaryVertexClass();
    }

    @Override
    public Class<? extends Vertex> getSchemaClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readAttributeValueFromString(String string, String string2) throws GraphIOException, NoSuchAttributeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String writeAttributeValueToString(String string) throws IOException, GraphIOException, NoSuchAttributeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeAttributeValues(GraphIO graphIO) throws IOException, GraphIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readAttributeValues(GraphIO graphIO) throws GraphIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getAttribute(String string) throws NoSuchAttributeException {
        return (T)this.attributes.get(string);
    }

    @Override
    public <T> void setAttribute(String string, T t) throws NoSuchAttributeException {
        this.attributes.put(string, t);
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
    }

    @Override
    public boolean isInstanceOf(VertexClass vertexClass) {
        return vertexClass.equals(this.graph.getGraphClass().getTemporaryVertexClass());
    }

    @Override
    public Vertex bless() {
        if (this.preliminaryType == null) {
            throw new TemporaryGraphElementException("Transformation of temporary vertex " + this + " failed. " + "There is no preliminary VertexClass set.");
        }
        return this.bless(this.preliminaryType);
    }

    @Override
    public Vertex bless(VertexClass vertexClass) {
        this.validateConversion(vertexClass);
        int n = this.id;
        GraphBaseImpl graphBaseImpl = this.graph;
        InternalVertex internalVertex = this.getPrevVertexInVSeq();
        InternalVertex internalVertex2 = this.getNextVertexInVSeq();
        InternalVertex internalVertex3 = (InternalVertex)graphBaseImpl.createVertex(vertexClass);
        for (String string : this.attributes.keySet()) {
            if (!internalVertex3.getAttributedElementClass().containsAttribute(string)) continue;
            internalVertex3.setAttribute(string, this.attributes.get(string));
        }
        Object object = this.getFirstIncidence();
        while (object != null) {
            object.setThis(internalVertex3);
            object = this.getFirstIncidence();
        }
        this.delete();
        if (internalVertex2 != null) {
            internalVertex3.putBefore(internalVertex2);
        }
        if (internalVertex != null) {
            internalVertex3.putAfter(internalVertex);
        }
        int n2 = internalVertex3.getId();
        internalVertex3.setId(n);
        graphBaseImpl.allocateVertexIndex(n);
        graphBaseImpl.freeVertexIndex(n2);
        InternalVertex[] internalVertexArray = graphBaseImpl.getVertex();
        internalVertexArray[n] = internalVertex3;
        internalVertexArray[n2] = null;
        HashSet<TemporaryEdge> hashSet = new HashSet<TemporaryEdge>();
        for (Edge edge : internalVertex3.incidences(this.getGraphClass().getTemporaryEdgeClass())) {
            if (((TemporaryEdge)edge).getPreliminaryType() == null || !edge.isValid()) continue;
            hashSet.add((TemporaryEdge)edge.getNormalEdge());
        }
        for (TemporaryEdge temporaryEdge : hashSet) {
            temporaryEdge.bless();
        }
        return internalVertex3;
    }

    private void validateConversion(VertexClass vertexClass) {
        if (!this.isValid()) {
            throw new TemporaryGraphElementException("This temporary vertex isn't valid anymore! " + this);
        }
        for (Edge object : this.incidences(EdgeDirection.OUT)) {
            if (object.isNormal()) {
                if (vertexClass.isValidFromFor(object.getAttributedElementClass())) continue;
                throw new TemporaryGraphElementException("Transformation of temporary vertex " + this + " failed. " + vertexClass + " is not a valid source for edge " + object + ".");
            }
            if (vertexClass.isValidToFor(object.getAttributedElementClass())) continue;
            throw new TemporaryGraphElementException("Transformation of temporary vertex " + this + " failed. " + vertexClass + " is not a valid target for edge " + object + ".");
        }
        for (String string : this.attributes.keySet()) {
            if (!vertexClass.containsAttribute(string)) continue;
            boolean bl = true;
            try {
                bl = vertexClass.getAttribute(string).getDomain().isConformValue(this.attributes.get(string));
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                bl = false;
            }
            if (bl) continue;
            throw new TemporaryGraphElementException("Transformation of temporary vertex " + this + " failed. " + vertexClass + " has an attribute " + string + " but " + this.attributes.get(string) + " is not a valid value.");
        }
    }

    @Override
    public void deleteAttribute(String string) {
        this.attributes.remove(string);
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public VertexClass getPreliminaryType() {
        return this.preliminaryType;
    }

    @Override
    public void setPreliminaryType(VertexClass vertexClass) {
        this.preliminaryType = vertexClass;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tv: ");
        if (this.preliminaryType != null) {
            stringBuilder.append(this.preliminaryType.getQualifiedName());
        } else {
            stringBuilder.append("-MissingPreliminaryType-");
        }
        stringBuilder.append(" {");
        boolean bl = true;
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" -> ");
            stringBuilder.append(entry.getValue());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

