/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public abstract class CodeBlock {
    private Map<String, String> variables = new HashMap<String, String>();
    private Stack<String> replacementStack = new Stack();
    private CodeList parent;
    protected int additionalIndent = 0;

    protected CodeBlock() {
        this(null);
    }

    protected CodeBlock(CodeList codeList) {
        if (codeList != null) {
            codeList.add(this);
        }
    }

    public abstract String getCode(int var1);

    public abstract void clear();

    public abstract int size();

    public void addVariables(Map<String, String> map) {
        this.variables.putAll(map);
    }

    public void setVariable(String string, String string2) {
        assert (string != null && string.trim().length() > 0 && string.equals(string.trim()));
        assert (string2 != null);
        this.variables.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVariable(String string) {
        if (this.replacementStack.contains(string)) {
            return string;
        }
        this.replacementStack.push(string);
        try {
            CodeBlock codeBlock = this;
            while (codeBlock != null) {
                if (codeBlock.variables.containsKey(string)) {
                    String string2 = this.replaceVariables(codeBlock.variables.get(string));
                    return string2;
                }
                codeBlock = codeBlock.parent;
            }
            String string3 = "*UNDEFINED:" + string + "*";
            return string3;
        }
        finally {
            this.replacementStack.pop();
        }
    }

    protected String replaceVariables(String string) {
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n = stringBuilder.indexOf("#");
            while (n >= 0) {
                int n2 = stringBuilder.indexOf("#", n + 1);
                if (n2 < 0) {
                    throw new RuntimeException("missing end marker in string \"" + string + "\"");
                }
                String string2 = stringBuilder.substring(n + 1, n2);
                String string3 = this.getVariable(string2);
                stringBuilder.replace(n, n2 + 1, string3);
                n = stringBuilder.indexOf("#");
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public String getCode() {
        return this.getCode(0);
    }

    public CodeList getParent() {
        return this.parent;
    }

    protected void setParent(CodeList codeList) {
        this.parent = codeList;
    }
}

