/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;

public class GraphFactoryGenerator
extends CodeGenerator {
    private final Schema schema;

    public GraphFactoryGenerator(Schema schema, String string, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        super(string, "", codeGeneratorConfiguration);
        this.schema = schema;
        this.rootBlock.setVariable("schemaName", schema.getQualifiedName());
        this.rootBlock.setVariable("simpleClassName", schema.getGraphClass().getSimpleName() + "Factory");
        this.rootBlock.setVariable("simpleImplClassName", schema.getGraphClass().getSimpleName() + "FactoryImpl");
        this.rootBlock.setVariable("isClassOnly", "false");
    }

    @Override
    protected CodeBlock createHeader() {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        if (this.currentCycle.isAbstract()) {
            this.addImports("#jgPackage#.GraphFactory");
            codeSnippet.add("public interface #simpleClassName# extends GraphFactory {");
        } else {
            this.addImports("#schemaPackage#.#simpleClassName#");
            this.addImports("#jgImplPackage#.GraphFactoryImpl");
            this.addImports("#jgPackage#.ImplementationType");
            codeSnippet.add("public class #simpleImplClassName# extends GraphFactoryImpl implements #simpleClassName# {");
        }
        return codeSnippet;
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = new CodeList();
        if (this.currentCycle.isStdImpl()) {
            codeList.add(this.createConstructor());
        }
        return codeList;
    }

    protected CodeBlock createConstructor() {
        CodeList codeList = new CodeList();
        if (this.currentCycle.isStdImpl()) {
            codeList.setVariable("implTypeInfix", "STANDARD");
        }
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.add("public #simpleImplClassName#() {", "\tsuper(#schemaName#.instance(), ImplementationType.#implTypeInfix#);", "\tcreateMaps();");
        codeList.addNoIndent(codeSnippet);
        codeList.add(this.createFillTableMethod());
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    protected CodeBlock createFillTableMethod() {
        if (this.currentCycle.isAbstract()) {
            return null;
        }
        CodeList codeList = new CodeList();
        GraphClass graphClass = this.schema.getGraphClass();
        codeList.addNoIndent(this.createFillTableForGraph(graphClass));
        for (VertexClass graphElementClass : graphClass.getVertexClasses()) {
            codeList.addNoIndent(this.createFillTableForVertex(graphElementClass));
        }
        for (EdgeClass edgeClass : graphClass.getEdgeClasses()) {
            codeList.addNoIndent(this.createFillTableForEdge(edgeClass));
        }
        return codeList;
    }

    protected CodeBlock createFillTableForGraph(GraphClass graphClass) {
        if (graphClass.isAbstract()) {
            return null;
        }
        CodeSnippet codeSnippet = new CodeSnippet(false, new String[0]);
        codeSnippet.setVariable("graphName", graphClass.getQualifiedName() + ".GC");
        codeSnippet.setVariable("graphImplName", "#schemaImplStdPackage#." + graphClass.getQualifiedName() + "Impl");
        codeSnippet.setVariable("graphTransactionImplName", "#schemaImplTransPackage#." + graphClass.getQualifiedName() + "Impl");
        codeSnippet.setVariable("graphDatabaseImplName", "#schemaImplDbPackage#." + graphClass.getQualifiedName() + "Impl");
        if (!graphClass.isAbstract() && this.currentCycle.isStdImpl()) {
            codeSnippet.add("setGraphImplementationClass(#schemaPackage#.#graphName#, #graphImplName#.class);");
        }
        return codeSnippet;
    }

    protected CodeBlock createFillTableForVertex(VertexClass vertexClass) {
        if (vertexClass.isAbstract()) {
            return null;
        }
        CodeSnippet codeSnippet = new CodeSnippet(false, new String[0]);
        codeSnippet.setVariable("vertexName", vertexClass.getQualifiedName() + ".VC");
        codeSnippet.setVariable("vertexImplName", "#schemaImplStdPackage#." + vertexClass.getQualifiedName() + "Impl");
        codeSnippet.setVariable("vertexTransactionImplName", "#schemaImplTransPackage#." + vertexClass.getQualifiedName() + "Impl");
        codeSnippet.setVariable("vertexDatabaseImplName", "#schemaImplDbPackage#." + vertexClass.getQualifiedName() + "Impl");
        if (!vertexClass.isAbstract() && this.currentCycle.isStdImpl()) {
            codeSnippet.add("setVertexImplementationClass(#schemaPackage#.#vertexName#, #vertexImplName#.class);");
        }
        return codeSnippet;
    }

    protected CodeBlock createFillTableForEdge(EdgeClass edgeClass) {
        CodeSnippet codeSnippet = new CodeSnippet(false, new String[0]);
        codeSnippet.setVariable("edgeName", edgeClass.getQualifiedName() + ".EC");
        codeSnippet.setVariable("edgeImplName", "#schemaImplStdPackage#." + edgeClass.getQualifiedName() + "Impl");
        codeSnippet.setVariable("edgeTransactionImplName", "#schemaImplTransPackage#." + edgeClass.getQualifiedName() + "Impl");
        codeSnippet.setVariable("edgeDatabaseImplName", "#schemaImplDbPackage#." + edgeClass.getQualifiedName() + "Impl");
        if (!edgeClass.isAbstract() && this.currentCycle.isStdImpl()) {
            codeSnippet.add("setEdgeImplementationClass(#schemaPackage#.#edgeName#, #edgeImplName#.class);");
        }
        return codeSnippet;
    }
}

