/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlgui;

import de.uni_koblenz.ist.utilities.gui.SwingApplication;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.greqlgui.GreqlGui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.UndoManager;

public class QueryEditorPanel
extends JPanel {
    private static final long serialVersionUID = -5113284469152114552L;
    private GreqlGui gui;
    private JTextArea queryArea;
    private UndoManager undoManager;
    private File queryFile;
    private boolean modified;
    CompletionEntryType lookupType;
    private CompletionTableModel completions;
    private Set<CompletionEntry> greqlEntries;
    private JTextPane descriptionTextPane;
    private boolean fontSet;
    private JTable selectTable;
    private JDialog selectWindow;
    private JTextField prefixField;

    public QueryEditorPanel(GreqlGui greqlGui) throws IOException {
        this(greqlGui, null);
    }

    public QueryEditorPanel(GreqlGui greqlGui, File file) throws IOException {
        this.gui = greqlGui;
        this.queryFile = null;
        this.queryArea = new JTextArea(15, 50);
        this.queryArea.setEditable(true);
        this.queryArea.setFont(this.gui.getQueryFont());
        this.queryArea.setToolTipText(MessageFormat.format(this.gui.getMessage("GreqlGui.QueryArea.ToolTip"), this.gui.getEvaluateQueryShortcut()));
        this.queryArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 32 && !QueryEditorPanel.this.gui.isGraphLoading() && !QueryEditorPanel.this.gui.isEvaluating()) {
                    QueryEditorPanel.this.lookupWord();
                }
            }
        });
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(10000);
        Document document = this.queryArea.getDocument();
        if (file == null) {
            this.newFile();
        } else {
            this.loadFromFile(file);
        }
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                QueryEditorPanel.this.undoManager.addEdit(undoableEditEvent.getEdit());
                QueryEditorPanel.this.setModified(true);
                QueryEditorPanel.this.gui.updateActions();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.queryArea);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    private CompletionTableModel getCompletionTableModel(String string, CompletionEntryType completionEntryType) {
        TreeSet<CompletionEntry> treeSet = new TreeSet<CompletionEntry>();
        switch (completionEntryType) {
            case GREQL_FUNCTION: {
                this.addMatchingGreqlFunctions(string, treeSet);
                break;
            }
            case VERTEXCLASS: 
            case EDGECLASS: 
            case ATTRIBUTE: 
            case GRAPHELEMENTCLASS: {
                this.addMatchingSchemaInformation(string, treeSet, completionEntryType);
                break;
            }
            default: {
                throw new RuntimeException("FIXME!");
            }
        }
        return new CompletionTableModel(treeSet, completionEntryType);
    }

    private void addMatchingSchemaInformation(String string, TreeSet<CompletionEntry> treeSet, CompletionEntryType completionEntryType) {
        Graph graph = this.gui.getGraph();
        if (graph != null) {
            Schema schema = graph.getSchema();
            Stack<Package> stack = new Stack<Package>();
            stack.push(schema.getDefaultPackage());
            string = string.toLowerCase();
            while (!stack.isEmpty()) {
                Package package_ = (Package)stack.pop();
                if (completionEntryType == CompletionEntryType.ATTRIBUTE) {
                    for (VertexClass vertexClass : package_.getVertexClasses()) {
                        for (Attribute attribute : vertexClass.getOwnAttributeList()) {
                            if (!attribute.getName().toLowerCase().startsWith(string)) continue;
                            treeSet.add(new CompletionEntry(CompletionEntryType.ATTRIBUTE, attribute.getName() + " in " + vertexClass.getSimpleName(), attribute.getName(), this.getDescription(vertexClass, attribute)));
                        }
                    }
                    for (EdgeClass edgeClass : package_.getEdgeClasses()) {
                        for (Attribute attribute : edgeClass.getOwnAttributeList()) {
                            if (!attribute.getName().toLowerCase().startsWith(string)) continue;
                            treeSet.add(new CompletionEntry(CompletionEntryType.ATTRIBUTE, attribute.getName() + " in " + edgeClass.getSimpleName(), attribute.getName(), this.getDescription(edgeClass, attribute)));
                        }
                    }
                }
                if (completionEntryType == CompletionEntryType.VERTEXCLASS || completionEntryType == CompletionEntryType.GRAPHELEMENTCLASS) {
                    for (VertexClass vertexClass : package_.getVertexClasses()) {
                        if (!vertexClass.getSimpleName().toLowerCase().startsWith(string) && !vertexClass.getQualifiedName().toLowerCase().startsWith(string)) continue;
                        treeSet.add(new CompletionEntry(CompletionEntryType.VERTEXCLASS, vertexClass.getSimpleName(), vertexClass.getQualifiedName(), this.getDescription(vertexClass)));
                    }
                }
                if (completionEntryType == CompletionEntryType.EDGECLASS || completionEntryType == CompletionEntryType.GRAPHELEMENTCLASS) {
                    for (EdgeClass edgeClass : package_.getEdgeClasses()) {
                        if (!edgeClass.getSimpleName().toLowerCase().startsWith(string) && !edgeClass.getQualifiedName().toLowerCase().startsWith(string)) continue;
                        treeSet.add(new CompletionEntry(CompletionEntryType.EDGECLASS, edgeClass.getSimpleName(), edgeClass.getQualifiedName(), this.getDescription(edgeClass)));
                    }
                }
                for (Package package_2 : package_.getSubPackages()) {
                    stack.push(package_2);
                }
            }
        }
    }

    private String getDescription(GraphElementClass<?, ?> graphElementClass) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append("<p>").append(graphElementClass.isAbstract() ? "abstract " : "").append(graphElementClass instanceof VertexClass ? "Vertex" : "Edge").append("Class <strong>").append(graphElementClass.getQualifiedName()).append("</strong></p><dl>");
        if (graphElementClass instanceof EdgeClass) {
            object = (EdgeClass)graphElementClass;
            stringBuilder.append("<dt>from</dt><dd>").append(object.getFrom().getVertexClass().getQualifiedName()).append(" (").append(object.getFrom().getMin()).append(", ").append(object.getFrom().getMax() == Integer.MAX_VALUE ? "*" : "" + object.getFrom().getMax()).append(")");
            String object2 = object.getFrom().getRolename();
            if (object2 != null && !object2.isEmpty()) {
                stringBuilder.append(" role ").append(object2);
            }
            stringBuilder.append(" aggregation ").append((Object)object.getFrom().getAggregationKind());
            stringBuilder.append("</dd><dt>to</dt><dd>").append(object.getTo().getVertexClass().getQualifiedName()).append(" (").append(object.getTo().getMin()).append(", ").append(object.getTo().getMax() == Integer.MAX_VALUE ? "*" : "" + object.getTo().getMax()).append(")");
            String string = object.getTo().getRolename();
            if (string != null && !string.isEmpty()) {
                stringBuilder.append(" role ").append(string);
            }
            stringBuilder.append(" aggregation ").append((Object)object.getTo().getAggregationKind());
            stringBuilder.append("</dd>");
        }
        if (!graphElementClass.getAllSuperClasses().isEmpty()) {
            object = "<dt>Superclasses:</dt><dd>";
            for (GraphElementClass graphElementClass2 : graphElementClass.getAllSuperClasses()) {
                stringBuilder.append((String)object).append(graphElementClass2.getQualifiedName());
                object = ", ";
            }
            stringBuilder.append("</dd>");
        }
        if (!graphElementClass.getAllSubClasses().isEmpty()) {
            object = "<dt>Subclasses:</dt><dd>";
            for (GraphElementClass graphElementClass2 : graphElementClass.getAllSubClasses()) {
                stringBuilder.append((String)object).append(graphElementClass2.getQualifiedName());
                object = ", ";
            }
            stringBuilder.append("</dd>");
        }
        if (graphElementClass.getAttributeCount() > 0) {
            stringBuilder.append("<dt>Attributes:</dt>");
            for (Attribute attribute : graphElementClass.getAttributeList()) {
                stringBuilder.append("<dd><strong>").append(attribute.getName()).append("</strong>: <font color=\"purple\">").append(attribute.getDomain().getQualifiedName()).append("</font></dd>");
            }
            stringBuilder.append("</p>");
        }
        stringBuilder.append("</dl></body></html>");
        return stringBuilder.toString();
    }

    private String getDescription(GraphElementClass<?, ?> graphElementClass, Attribute attribute) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append("<p>Attribute <strong>").append(attribute.getName()).append("</strong>: <font color=\"purple\">").append(attribute.getDomain().getQualifiedName()).append("</font></p><p>&nbsp;&nbsp;in ").append(graphElementClass instanceof VertexClass ? "Vertex" : "Edge").append("Class ").append(graphElementClass.getQualifiedName()).append("</p>");
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    private Set<CompletionEntry> getGreqlEntries() {
        if (this.greqlEntries != null) {
            return this.greqlEntries;
        }
        this.greqlEntries = new TreeSet<CompletionEntry>();
        Set<String> set = FunLib.getFunctionNames();
        for (String string : set) {
            this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_FUNCTION, string, string + "()", FunLib.getFunctionInfo(string).getHtmlDescription(), -1));
        }
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "V", "V{}", this.getDescriptionFromResources("vertexset.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "E", "E{}", this.getDescriptionFromResources("edgeset.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "false", "false", "Boolean constant"));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "true", "true", "Boolean constant"));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "undefined", "undefined", "Undefined constant"));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "tv", "thisVertex", this.getDescriptionFromResources("thisliteral.html")));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "te", "thisEdge", this.getDescriptionFromResources("thisliteral.html")));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "fwr", "from\n\t\nwith\n\t\nreport\n\t\nend", this.getDescriptionFromResources("listcomp.html"), -20));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "fwr set", "from\n\t\nwith\n\t\nreportSet\n\t\nend", this.getDescriptionFromResources("setcomp.html"), -23));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "fwr map", "from\n\t\nwith\n\t\nreportMap\n\t\nend", this.getDescriptionFromResources("mapcomp.html"), -23));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "exists", "exists @ ", this.getDescriptionFromResources("exists.html"), -2));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "exists!", "exists!  @ ", this.getDescriptionFromResources("exists1.html"), -3));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "forall", "forall  @ ", this.getDescriptionFromResources("forall.html"), -3));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "let", "let  in ", this.getDescriptionFromResources("let.html"), -4));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "where", "\nwhere ", this.getDescriptionFromResources("where.html"), -7));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "list", "list()", this.getDescriptionFromResources("list.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "set", "set()", this.getDescriptionFromResources("set.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "map", "map()", this.getDescriptionFromResources("map.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "tup", "tup()", this.getDescriptionFromResources("tup.html"), -1));
        return this.greqlEntries;
    }

    private String getDescriptionFromResources(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream("resources/completion/" + string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private void addMatchingGreqlFunctions(String string, TreeSet<CompletionEntry> treeSet) {
        string = string.toLowerCase();
        for (CompletionEntry completionEntry : this.getGreqlEntries()) {
            if (!completionEntry.name.toLowerCase().startsWith(string) && !completionEntry.replacement.toLowerCase().startsWith(string)) continue;
            treeSet.add(completionEntry);
        }
    }

    private void setDescription(String string) {
        this.descriptionTextPane.setContentType("text/html");
        this.descriptionTextPane.setText(string);
        Font font = UIManager.getFont("Label.font");
        String string2 = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.descriptionTextPane.getDocument()).getStyleSheet().addRule(string2);
        this.descriptionTextPane.setCaretPosition(0);
    }

    protected void lookupWord() {
        int n;
        int n2;
        int n3;
        int n4 = this.queryArea.getCaretPosition();
        char[] cArray = this.queryArea.getText().toCharArray();
        for (n3 = n4 - 1; n3 >= 0 && (Character.isLetterOrDigit(cArray[n3]) || cArray[n3] == '_'); --n3) {
        }
        for (n2 = n3; n2 >= 0 && Character.isWhitespace(cArray[n2]); --n2) {
        }
        final int n5 = n = n3 + 1;
        final int n6 = n4 - n;
        while (n3 >= 0 && cArray[n3] != '{' && (Character.isWhitespace(cArray[n3]) || Character.isLetterOrDigit(cArray[n3]) || cArray[n3] == '_' || cArray[n3] == '$' || cArray[n3] == '^' || cArray[n3] == ',' || cArray[n3] == '.' || cArray[n3] == '!')) {
            --n3;
        }
        this.lookupType = null;
        if (n3 >= 0 && cArray[n3] == '{') {
            --n3;
            while (n3 >= 0 && Character.isWhitespace(cArray[n3])) {
                --n3;
            }
            if (n3 >= 0) {
                if (cArray[n3] == 'V' || cArray[n3] == '&') {
                    this.lookupType = CompletionEntryType.VERTEXCLASS;
                } else if (cArray[n3] == 'E' || cArray[n3] == '-' || cArray[n3] == '>') {
                    this.lookupType = CompletionEntryType.EDGECLASS;
                }
            }
            if (this.lookupType == null) {
                this.lookupType = CompletionEntryType.GRAPHELEMENTCLASS;
            }
        }
        if (this.lookupType == null && n2 >= 0 && cArray[n2] == '.') {
            this.lookupType = CompletionEntryType.ATTRIBUTE;
        }
        if (this.lookupType == null) {
            this.lookupType = CompletionEntryType.GREQL_FUNCTION;
        }
        String string = "";
        try {
            string = this.queryArea.getText(n5, n6).toLowerCase();
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.descriptionTextPane = new JTextPane();
        this.descriptionTextPane.setContentType("text/html");
        this.descriptionTextPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.descriptionTextPane.setEditable(false);
        this.descriptionTextPane.addPropertyChangeListener("page", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!QueryEditorPanel.this.fontSet) {
                    MutableAttributeSet mutableAttributeSet = QueryEditorPanel.this.descriptionTextPane.getInputAttributes();
                    StyleConstants.setFontFamily(mutableAttributeSet, "SansSerif");
                    StyledDocument styledDocument = QueryEditorPanel.this.descriptionTextPane.getStyledDocument();
                    styledDocument.setCharacterAttributes(0, styledDocument.getLength() + 1, mutableAttributeSet, false);
                    QueryEditorPanel.this.fontSet = true;
                }
            }
        });
        this.selectTable = new CompletionTable(null);
        this.selectWindow = new JDialog((Frame)this.gui, this.lookupType.toString());
        this.prefixField = new JTextField(string);
        if (SwingApplication.RUNS_ON_MAC_OS_X) {
            this.prefixField.setCaret(new DefaultCaret());
            this.prefixField.putClientProperty("JTextField.variant", "search");
        }
        this.prefixField.getCaret().setDot(this.prefixField.getDocument().getLength());
        this.prefixField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                QueryEditorPanel.this.updateCompletion();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                QueryEditorPanel.this.updateCompletion();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                QueryEditorPanel.this.updateCompletion();
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    QueryEditorPanel.this.selectWindow.setVisible(false);
                    QueryEditorPanel.this.queryArea.requestFocus();
                } else if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    if (QueryEditorPanel.this.selectTable.getSelectedRow() >= 0) {
                        try {
                            QueryEditorPanel.this.queryArea.getDocument().remove(n5, n6);
                            CompletionEntry completionEntry = QueryEditorPanel.this.completions.getEntry(QueryEditorPanel.this.selectTable.getSelectedRow());
                            String string = completionEntry.replacement;
                            QueryEditorPanel.this.queryArea.getDocument().insertString(n5, string, null);
                            QueryEditorPanel.this.queryArea.setCaretPosition(QueryEditorPanel.this.queryArea.getCaretPosition() + ((QueryEditorPanel)QueryEditorPanel.this).completions.getEntry((int)((QueryEditorPanel)QueryEditorPanel.this).selectTable.getSelectedRow()).offset);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                    QueryEditorPanel.this.selectWindow.setVisible(false);
                    QueryEditorPanel.this.queryArea.requestFocus();
                } else if (keyEvent.getKeyCode() == 38) {
                    keyEvent.consume();
                    int n = QueryEditorPanel.this.selectTable.getSelectedRow() - 1;
                    if (n >= 0) {
                        QueryEditorPanel.this.selectTable.changeSelection(n, 0, false, false);
                    }
                } else if (keyEvent.getKeyCode() == 40) {
                    keyEvent.consume();
                    int n = QueryEditorPanel.this.selectTable.getSelectedRow() + 1;
                    if (n < QueryEditorPanel.this.completions.getRowCount()) {
                        QueryEditorPanel.this.selectTable.changeSelection(n, 0, false, false);
                    }
                }
            }
        };
        this.prefixField.addKeyListener(keyAdapter);
        this.selectTable.addKeyListener(keyAdapter);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.prefixField, "North");
        JScrollPane jScrollPane = new JScrollPane(this.selectTable);
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        jPanel.add((Component)jScrollPane, "Center");
        JScrollPane jScrollPane2 = new JScrollPane(this.descriptionTextPane);
        jScrollPane2.setPreferredSize(new Dimension(500, 300));
        this.descriptionTextPane.setBackground(new Color(254, 254, 189));
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jScrollPane2);
        jSplitPane.setContinuousLayout(true);
        this.selectWindow.getContentPane().add(jSplitPane);
        this.updateCompletion();
        this.selectWindow.pack();
        try {
            Rectangle rectangle = this.queryArea.modelToView(n4);
            Point point = SwingUtilities.convertPoint(this.queryArea, new Point(rectangle.x, rectangle.y - 32), this.gui);
            SwingUtilities.convertPointToScreen(point, this.gui);
            this.selectWindow.setLocation(point);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.selectWindow.setVisible(true);
        this.selectWindow.toFront();
    }

    private void updateCompletion() {
        this.completions = this.getCompletionTableModel(this.prefixField.getText(), this.lookupType);
        this.selectTable.setModel(this.completions);
        if (this.completions.getRowCount() > 0) {
            this.selectTable.changeSelection(0, 0, false, false);
        } else {
            this.setDescription("No matches :-(");
        }
    }

    public void setSelection(int n, int n2) {
        if (n < 0) {
            return;
        }
        int n3 = Math.max(0, Math.min(n, this.queryArea.getDocument().getLength()));
        int n4 = Math.max(n3, Math.min(n3 + n2, this.queryArea.getDocument().getLength()));
        this.queryArea.setSelectionStart(n3);
        this.queryArea.setSelectionEnd(n4);
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        this.undoManager.undo();
        this.setModified(true);
    }

    public void redo() {
        this.undoManager.redo();
        this.setModified(true);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void cut() {
        this.queryArea.cut();
    }

    public void copy() {
        this.queryArea.copy();
    }

    public void paste() {
        this.queryArea.paste();
    }

    public String getText() {
        return this.queryArea.getText();
    }

    public void removeJavaQuotes() {
        String string = this.queryArea.getText().trim();
        string = string.replaceAll("\"\\s*\\+\\s*\"", "");
        string = string.replace("\\\"", "\uffff");
        string = string.replace("\"", "");
        string = string.replace("\\n", "\n");
        string = string.replace("\\t", "\t");
        string = string.replace("\\\"", "\"");
        string = string.replace("\\\\", "\\");
        string = string.replace("\uffff", "\"");
        this.queryArea.setText(string);
    }

    public void insertJavaQuotes() {
        String string = this.queryArea.getText();
        String[] stringArray = string.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            string2 = string2.replace("\\", "\\\\");
            string2 = string2.replace("\"", "\\\"");
            string2 = string2.replace("\t", "\\t");
            stringBuilder.append("\"").append(string2);
            if (i < stringArray.length - 1) {
                stringBuilder.append("\\n\" +\n");
                continue;
            }
            stringBuilder.append("\"");
        }
        string = stringBuilder.toString();
        this.queryArea.setText(string);
        this.setSelection(0, this.queryArea.getDocument().getLength());
        this.queryArea.copy();
    }

    @Override
    public void requestFocus() {
        this.queryArea.requestFocus();
    }

    public void setQuery(File file, String string) {
        this.queryFile = file;
        this.queryArea.setText(string);
        this.undoManager.discardAllEdits();
        this.setModified(false);
    }

    public File getQueryFile() {
        return this.queryFile;
    }

    public void setQueryFile(File file) {
        this.queryFile = file;
    }

    public void loadFromFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder.append(string).append("\n");
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        this.setQuery(file, stringBuilder.toString());
    }

    public void saveToFile(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.print(this.queryArea.getText());
        printWriter.close();
        this.queryFile = file;
        this.setModified(false);
    }

    private void newFile() {
        this.setQuery(null, this.gui.getMessage("GreqlGui.NewQuery.Text"));
        this.setSelection(0, this.queryArea.getDocument().getLength());
    }

    public String getFileName() {
        return this.queryFile == null ? this.gui.getMessage("GreqlGui.NewQuery.Title") : this.queryFile.getName();
    }

    public void setQueryFont(Font font) {
        this.queryArea.setFont(font);
    }

    private class CompletionTable
    extends JTable {
        private static final long serialVersionUID = 8741021448180241310L;

        public CompletionTable(TableModel tableModel) {
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            this.setModel(tableModel);
        }

        private void installSelectionListener() {
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = CompletionTable.this.getSelectedRow();
                    if (QueryEditorPanel.this.completions != null && n >= 0) {
                        QueryEditorPanel.this.setDescription(((QueryEditorPanel)QueryEditorPanel.this).completions.getEntry((int)n).description);
                    } else {
                        QueryEditorPanel.this.setDescription("");
                    }
                }
            });
        }

        @Override
        public void setModel(TableModel tableModel) {
            if (tableModel == null) {
                tableModel = new DefaultTableModel();
            }
            super.setModel(tableModel);
            if (tableModel.getRowCount() > 0) {
                this.changeSelection(0, 0, false, false);
            }
            this.installSelectionListener();
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(mouseEvent.getX() + 15, mouseEvent.getY());
        }
    }

    private class CompletionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4313285792993087566L;
        ArrayList<CompletionEntry> entries;
        CompletionEntryType lookupType;

        public CompletionTableModel(Collection<CompletionEntry> collection, CompletionEntryType completionEntryType) {
            this.entries = new ArrayList<CompletionEntry>(collection);
            this.lookupType = completionEntryType;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return this.lookupType == CompletionEntryType.ATTRIBUTE ? "Attribute" : "Name";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CompletionEntry completionEntry = this.entries.get(n);
            switch (n2) {
                case 0: {
                    return completionEntry.name;
                }
            }
            return null;
        }

        CompletionEntry getEntry(int n) {
            return this.entries.get(n);
        }
    }

    private static class CompletionEntry
    implements Comparable<CompletionEntry> {
        CompletionEntryType type;
        String name;
        String replacement;
        String description;
        int offset;

        public CompletionEntry(CompletionEntryType completionEntryType, String string, String string2, String string3) {
            this.type = completionEntryType;
            this.name = string;
            this.replacement = string2;
            this.description = string3;
        }

        public CompletionEntry(CompletionEntryType completionEntryType, String string, String string2, String string3, int n) {
            this(completionEntryType, string, string2, string3);
            this.offset = n;
        }

        @Override
        public int compareTo(CompletionEntry completionEntry) {
            return this.name.compareTo(completionEntry.name);
        }
    }

    private static enum CompletionEntryType {
        GREQL_FUNCTION,
        GREQL_IDIOM,
        VERTEXCLASS,
        EDGECLASS,
        ATTRIBUTE,
        GRAPHELEMENTCLASS;

    }
}

