/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlgui;

import de.uni_koblenz.ist.utilities.gui.FontSelectionDialog;
import de.uni_koblenz.jgralab.utilities.greqlgui.GreqlGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SettingsDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -5656234050436317561L;
    private GreqlGui gui;
    private JButton cancelButton;
    private JButton okButton;
    private Font queryFont;
    private JTextField queryFontLabel;
    private JButton queryFontButton;
    private Font resultFont;
    private JTextField resultFontLabel;
    private JButton resultFontButton;
    private JList greqlFunctionList;
    private DefaultListModel greqlFunctionModel;
    private Action removeAction;
    private Action addAction;
    private JTextField functionNameField;

    public SettingsDialog(GreqlGui greqlGui, Font font, Font font2, List<String> list) {
        super(greqlGui, greqlGui.getApplicationName() + greqlGui.getMessage("SettingsDialog.Title"), true);
        this.gui = greqlGui;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(8, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.getContentPane().add(jPanel);
        this.queryFont = font;
        this.resultFont = font2;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.gui.getMessage("SettingsDialog.FontTitle")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel(this.gui.getMessage("SettingsDialog.QueryFontLabel"), 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.queryFontLabel = new JTextField(FontSelectionDialog.getFontName(this.gui, this.queryFont), 30);
        this.queryFontLabel.setEditable(false);
        jPanel2.add((Component)this.queryFontLabel, gridBagConstraints);
        this.queryFontButton = new JButton(this.gui.getMessage("SettingsDialog.QueryFontButtonText"));
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.queryFontButton, gridBagConstraints);
        this.queryFontButton.addActionListener(this);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jLabel = new JLabel(this.gui.getMessage("SettingsDialog.ResultFontLabel"), 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.resultFontLabel = new JTextField(FontSelectionDialog.getFontName(this.gui, this.resultFont), 30);
        this.resultFontLabel.setEditable(false);
        jPanel2.add((Component)this.resultFontLabel, gridBagConstraints);
        this.resultFontButton = new JButton(this.gui.getMessage("SettingsDialog.ResultFontButtonText"));
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.resultFontButton, gridBagConstraints);
        this.resultFontButton.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.gui.getMessage("SettingsDialog.FunctionsTitle")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.greqlFunctionModel = new DefaultListModel();
        for (String object2 : list) {
            this.greqlFunctionModel.addElement(object2);
        }
        this.greqlFunctionList = new JList(this.greqlFunctionModel);
        this.greqlFunctionList.setSelectionMode(0);
        this.greqlFunctionList.setToolTipText(this.gui.getMessage("SettingsDialog.FunctionListToolTip"));
        JScrollPane jScrollPane = new JScrollPane(this.greqlFunctionList);
        jPanel3.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.removeAction = new AbstractAction(this.gui.getMessage("SettingsDialog.RemoveFunctionAction")){
            private static final long serialVersionUID = 5701993491246301105L;
            {
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SettingsDialog.this.greqlFunctionList.getSelectedIndex();
                SettingsDialog.this.functionNameField.setText((String)SettingsDialog.this.greqlFunctionModel.getElementAt(n));
                SettingsDialog.this.functionNameField.requestFocusInWindow();
                SettingsDialog.this.greqlFunctionModel.remove(n);
                int n2 = SettingsDialog.this.greqlFunctionModel.getSize();
                if (n2 == 0) {
                    SettingsDialog.this.removeAction.setEnabled(false);
                } else {
                    if (n == SettingsDialog.this.greqlFunctionModel.getSize()) {
                        --n;
                    }
                    SettingsDialog.this.greqlFunctionList.setSelectedIndex(n);
                    SettingsDialog.this.greqlFunctionList.ensureIndexIsVisible(n);
                }
            }
        };
        jPanel3.add((Component)new JButton(this.removeAction), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.functionNameField = new JTextField();
        this.functionNameField.setToolTipText(this.gui.getMessage("SettingsDialog.FunctionNameToolTip"));
        jPanel3.add((Component)this.functionNameField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        this.addAction = new AbstractAction(this.gui.getMessage("SettingsDialog.AddFunctionAction")){
            private static final long serialVersionUID = 727631592422400160L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string = SettingsDialog.this.functionNameField.getText().trim();
                if (string.equals("") || SettingsDialog.this.greqlFunctionModel.contains(string)) {
                    Toolkit.getDefaultToolkit().beep();
                    SettingsDialog.this.functionNameField.requestFocusInWindow();
                    SettingsDialog.this.functionNameField.selectAll();
                    return;
                }
                for (n = 0; n < SettingsDialog.this.greqlFunctionModel.size() && string.compareTo((String)SettingsDialog.this.greqlFunctionModel.getElementAt(n)) >= 0; ++n) {
                }
                SettingsDialog.this.greqlFunctionModel.insertElementAt(string, n);
                SettingsDialog.this.functionNameField.requestFocusInWindow();
                SettingsDialog.this.functionNameField.setText("");
                SettingsDialog.this.greqlFunctionList.setSelectedIndex(n);
                SettingsDialog.this.greqlFunctionList.ensureIndexIsVisible(n);
            }
        };
        jPanel3.add((Component)new JButton(this.addAction), gridBagConstraints);
        this.greqlFunctionList.addListSelectionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jLabel = new JLabel(this.gui.getMessage("SettingsDialog.FunctionInfoText"), 0);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        this.cancelButton = new JButton(this.gui.getMessage("SettingsDialog.CancelButtonText"));
        this.cancelButton.addActionListener(this);
        jPanel4.add(this.cancelButton);
        this.okButton = new JButton(this.gui.getMessage("SettingsDialog.OkButtonText"));
        this.okButton.addActionListener(this);
        this.okButton.setDefaultCapable(true);
        jPanel4.add(this.okButton);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.pack();
        this.okButton.requestFocus();
        this.setLocationRelativeTo(this.gui);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.greqlFunctionList.getSelectedIndex() == -1) {
                this.removeAction.setEnabled(false);
            } else {
                this.removeAction.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Font font;
        if (actionEvent.getSource() == this.cancelButton) {
            this.dispose();
        }
        if (actionEvent.getSource() == this.okButton && this.isOk()) {
            this.gui.saveSettings(this);
            this.dispose();
        }
        if (actionEvent.getSource() == this.resultFontButton && (font = FontSelectionDialog.selectFont(this.gui, this.gui.getMessage("SettingsDialog.ResultFontTitle"), this.resultFont, false)) != null) {
            this.resultFont = font;
            this.resultFontLabel.setText(FontSelectionDialog.getFontName(this.gui, this.resultFont));
        }
        if (actionEvent.getSource() == this.queryFontButton && (font = FontSelectionDialog.selectFont(this.gui, this.gui.getMessage("SettingsDialog.QueryFontTitle"), this.queryFont, false)) != null) {
            this.queryFont = font;
            this.queryFontLabel.setText(FontSelectionDialog.getFontName(this.gui, this.queryFont));
        }
    }

    public Font getQueryFont() {
        return this.queryFont;
    }

    public Font getResultFont() {
        return this.resultFont;
    }

    public List<String> getGreqlFunctionList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.greqlFunctionModel.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        return arrayList;
    }

    private boolean isOk() {
        return true;
    }
}

