/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlserver;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.WorkInProgress;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.serialising.HTMLOutputWriter;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

@WorkInProgress(responsibleDevelopers="dbildh")
public class GReQLConsole {
    private Graph graph = null;
    private boolean verbose = false;

    public GReQLConsole(String string, boolean bl, boolean bl2) {
        this.verbose = bl2;
        try {
            if (bl) {
                if (bl2) {
                    System.out.println("Loading schema from file");
                }
                Schema schema = GraphIO.loadSchemaFromFile(string);
                schema.compile(CodeGeneratorConfiguration.MINIMAL);
            }
            this.graph = GraphIO.loadGraphFromFile(string, bl2 ? new ConsoleProgressFunction("Loading") : null);
        }
        catch (GraphIOException graphIOException) {
            graphIOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadQueries(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            bufferedReader = new BufferedReader(new FileReader(file));
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("//--")) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    continue;
                }
                stringBuilder.append(string + " \n");
            }
        }
        if (stringBuilder.length() != 0) {
            string = stringBuilder.toString();
            arrayList.add(string);
        }
        return arrayList;
    }

    private Object performQuery(File file) {
        Object object = null;
        try {
            for (String string : this.loadQueries(file)) {
                if (this.verbose) {
                    System.out.println("Evaluating query: ");
                    System.out.println(string);
                }
                object = GreqlQuery.createQuery(string).evaluate(this.graph, new GreqlEnvironmentAdapter(), this.verbose ? new ConsoleProgressFunction() : null);
                if (!this.verbose || !(object instanceof Collection)) continue;
                System.out.println("Result size is: " + ((Collection)object).size());
            }
        }
        catch (GreqlException greqlException) {
            greqlException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    private void resultToHTML(Object object, String string) throws IOException {
        HTMLOutputWriter hTMLOutputWriter = new HTMLOutputWriter(this.graph);
        hTMLOutputWriter.writeValue(object, new File(string));
    }

    public static void main(String[] stringArray) {
        CommandLine commandLine = GReQLConsole.processCommandLineOptions(stringArray);
        assert (commandLine != null);
        String string = commandLine.getOptionValue("q");
        String string2 = commandLine.getOptionValue("g");
        boolean bl = commandLine.hasOption("s");
        JGraLab.setLogLevel(Level.SEVERE);
        GReQLConsole gReQLConsole = new GReQLConsole(string2, bl, commandLine.hasOption('v'));
        Object object = gReQLConsole.performQuery(new File(string));
        if (commandLine.hasOption("o")) {
            try {
                gReQLConsole.resultToHTML(object, commandLine.getOptionValue("o"));
            }
            catch (IOException iOException) {
                System.err.println("Exception while creating HTML output:");
                iOException.printStackTrace();
            }
        } else {
            System.out.println("Result: " + object);
        }
    }

    private static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + GReQLConsole.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("q", "queryfile", true, "(required): queryfile which should be executed. May contain many queries separated by //-- on a line");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("g", "graph", true, "(optional): the tg-file of the graph");
        option2.setRequired(false);
        option2.setArgName("file");
        optionHandler.addOption(option2);
        Option option3 = new Option("o", "output", true, "(optional): HTML-file to be generated");
        option3.setArgName("file");
        optionHandler.addOption(option3);
        Option option4 = new Option("s", "loadschema", false, "(optional): Loads also the schema from the file");
        optionHandler.addOption(option4);
        Option option5 = new Option("v", "verbose", false, "(optional): Produce verbose output");
        optionHandler.addOption(option5);
        return optionHandler.parse(stringArray);
    }
}

