/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlserver;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.GreqlQueryCache;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Types;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GreqlServer
extends Thread {
    private static Thread clientHandlerLoop;
    private static HashSet<GreqlServer> clients;
    private final Socket socket;
    private final BufferedReader in;
    private final PrintWriter out;
    private Graph graph;
    private String graphFile;
    private static Map<String, Graph> dataGraphs;
    private final GreqlQueryCache cache = new GreqlQueryCache();

    public GreqlServer(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        this.println("Hi! I'm your GreqlServer (" + this.socket.getInetAddress() + ")", PrintTarget.BOTH, true);
    }

    private void println(String string, PrintTarget printTarget, boolean bl) {
        switch (printTarget) {
            case CLIENT: {
                this.out.println(string);
                break;
            }
            case SERVER: {
                System.out.println(string);
                break;
            }
            case BOTH: {
                this.out.println(string);
                System.out.println(string);
                break;
            }
        }
        if (bl) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object = null;
            while ((object = this.in.readLine()) != null && !this.isInterrupted()) {
                Object object2;
                if (((String)object).startsWith("g:")) {
                    this.graphFile = ((String)object).substring(2);
                    object2 = dataGraphs.get(this.graphFile);
                    if (object2 == null) {
                        this.println("Loading " + this.graphFile + ".", PrintTarget.BOTH, true);
                        object2 = GraphIO.loadGraphFromFile(this.graphFile, new ConsoleProgressFunction("Loading"));
                        dataGraphs.put(this.graphFile, (Graph)object2);
                    }
                    this.graph = object2;
                } else if (((String)object).startsWith("q:")) {
                    this.evalQuery(((String)object).substring(2));
                } else if (((String)object).startsWith("d:")) {
                    object2 = ((String)object).substring(2);
                    this.saveAsDot(this.evalQuery((String)object2), (String)object2 + ".dot");
                } else {
                    this.println("Don't understand line '" + (String)object + "'.", PrintTarget.BOTH, true);
                }
                this.out.println("\f");
                this.out.flush();
            }
            this.println("GreqlServer says goodbye!", PrintTarget.BOTH, true);
            this.in.close();
            this.socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.printStackTrace(this.out);
        }
        finally {
            this.out.close();
            Class<GreqlServer> clazz = GreqlServer.class;
            synchronized (GreqlServer.class) {
                clients.remove(this);
                // ** MonitorExit[var1_3] (shouldn't be in output)
            }
        }
    }

    private void saveAsDot(Object object, String string) throws IOException {
        Graph graph = this.graph;
        BooleanGraphMarker booleanGraphMarker = new BooleanGraphMarker(graph);
        this.markResultElements(object, booleanGraphMarker);
        for (Edge edge : graph.edges()) {
            if (!booleanGraphMarker.isMarked(edge.getAlpha()) || !booleanGraphMarker.isMarked(edge.getOmega())) continue;
            booleanGraphMarker.mark(edge);
        }
        Tg2Dot.convertGraph(booleanGraphMarker, string);
    }

    private void markResultElements(Object object, BooleanGraphMarker booleanGraphMarker) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object e : collection) {
                this.markResultElements(e, booleanGraphMarker);
            }
        } else if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                this.markResultElements(entry.getKey(), booleanGraphMarker);
                this.markResultElements(entry.getValue(), booleanGraphMarker);
            }
        } else if (object instanceof SubGraphMarker) {
            SubGraphMarker subGraphMarker = (SubGraphMarker)object;
            for (GraphElement<?, ?> graphElement : subGraphMarker.getMarkedElements()) {
                booleanGraphMarker.mark(graphElement);
            }
        } else if (object instanceof PathSystem) {
            PathSystem pathSystem = (PathSystem)object;
            for (Vertex graphElement : pathSystem.getVertices()) {
                booleanGraphMarker.mark(graphElement);
            }
            for (Edge edge : pathSystem.getEdges()) {
                booleanGraphMarker.mark(edge);
            }
        } else if (object instanceof Path) {
            Path path = (Path)object;
            for (Vertex vertex : path.getVertexTrace()) {
                booleanGraphMarker.mark(vertex);
            }
            for (Edge edge : path.getEdgeTrace()) {
                booleanGraphMarker.mark(edge);
            }
        } else if (object instanceof GraphElement) {
            booleanGraphMarker.mark((GraphElement)object);
        } else {
            this.println("'" + object + "' is no AttributedElement, " + "so it won't be considered for DOT output.", PrintTarget.BOTH, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalQuery(String string) throws IOException {
        this.println("Evaling query file " + string + ".", PrintTarget.BOTH, true);
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append('\n');
            }
        }
        GreqlQuery greqlQuery = this.cache.getQuery(stringBuilder.toString());
        Object object = null;
        try {
            long l = System.currentTimeMillis();
            object = greqlQuery.evaluate(this.graph);
            long l2 = System.currentTimeMillis() - l;
            this.println("<result not printed>", PrintTarget.SERVER, false);
            this.out.println();
            this.out.println("Evaluation took " + l2 + "ms.");
            this.out.println();
            this.out.println("Evaluation Result:");
            this.out.println("==================");
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                this.println("Result collection (" + collection.getClass().getSimpleName() + ") contains " + collection.size() + " elements.\n", PrintTarget.CLIENT, true);
                for (Object e : collection) {
                    this.println(e.toString(), PrintTarget.CLIENT, false);
                }
            } else if (object instanceof Map) {
                Map map = (Map)object;
                this.println("Result map contains " + map.size() + " map entries.\n", PrintTarget.CLIENT, true);
                for (Map.Entry entry : map.entrySet()) {
                    this.println(entry.getKey() + " --> " + entry.getValue(), PrintTarget.CLIENT, false);
                }
            } else {
                this.println("Result is a single element of type " + Types.getGreqlTypeName(object) + ".\n", PrintTarget.CLIENT, true);
                this.println(object.toString(), PrintTarget.CLIENT, false);
            }
            this.out.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.printStackTrace(this.out);
        }
        return object;
    }

    public static void main(String[] stringArray) throws IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                GreqlServer.terminateServer();
            }
        });
        clientHandlerLoop = new Thread(){
            ServerSocket socket = new ServerSocket(10101);

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    Socket socket = null;
                    try {
                        socket = this.socket.accept();
                        GreqlServer greqlServer = new GreqlServer(socket);
                        clients.add(greqlServer);
                        greqlServer.start();
                    }
                    catch (IOException iOException) {
                        System.err.println("Exception while accepting client...");
                        iOException.printStackTrace();
                    }
                }
            }
        };
        clientHandlerLoop.start();
        System.out.println("GreqlServer listening on port 10101");
    }

    private static void terminateServer() {
        clientHandlerLoop.interrupt();
        for (GreqlServer greqlServer : clients) {
            greqlServer.interrupt();
        }
    }

    static {
        clients = new HashSet();
        dataGraphs = Collections.synchronizedMap(new HashMap());
    }

    private static enum PrintTarget {
        CLIENT,
        SERVER,
        BOTH;

    }
}

