/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.xdot;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.utilities.gui.xdot.TextShape;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XDotParser {
    private Color lineColor = Color.black;
    private Color fillColor = Color.black;
    private HashMap<String, Color> colorMap;
    private Font font = null;
    private Graph graph;
    private AttributedElement<?, ?> currentElement;
    private List<XDotShape> shapes;
    private GraphMarker<List<XDotShape>> elementShapes;
    private Rectangle2D bounds;

    public XDotParser(Graph graph, GraphMarker<List<XDotShape>> graphMarker) {
        this.graph = graph;
        this.elementShapes = graphMarker;
        this.colorMap = new HashMap();
        this.colorMap.put("black", Color.BLACK);
        this.colorMap.put("white", Color.WHITE);
        this.colorMap.put("red", Color.RED);
        this.colorMap.put("green", Color.GREEN);
        this.colorMap.put("blue", Color.BLUE);
        this.colorMap.put("yellow", Color.YELLOW);
        this.colorMap.put("cyan", Color.CYAN);
        this.colorMap.put("magenta", Color.MAGENTA);
        this.colorMap.put("gray", Color.GRAY);
    }

    private void parseDrawActions(String string) {
        Lexer lexer = new Lexer(string);
        char c = lexer.nextChar();
        while (c != '\u0000') {
            switch (c) {
                case 'C': 
                case 'c': {
                    int n;
                    int n2;
                    String string2 = lexer.nextString();
                    Object object = this.colorMap.get(string2);
                    if (object == null) {
                        if (string2.charAt(0) == '#') {
                            int n3 = Integer.parseInt(string2.substring(1, 3), 16);
                            n2 = Integer.parseInt(string2.substring(3, 5), 16);
                            n = Integer.parseInt(string2.substring(5, 7), 16);
                            if (string2.length() == 9) {
                                int n4 = Integer.parseInt(string2.substring(7, 9), 16);
                                object = new Color(n3, n2, n, n4);
                            } else {
                                object = new Color(n3, n2, n);
                            }
                        } else {
                            object = Color.black;
                        }
                        this.colorMap.put(string2, (Color)object);
                    }
                    if (c == 'c') {
                        this.lineColor = object;
                        break;
                    }
                    this.fillColor = object;
                    break;
                }
                case 'B': 
                case 'L': 
                case 'P': 
                case 'b': 
                case 'p': {
                    XDotShape xDotShape;
                    int n;
                    Path2D.Double double_;
                    int n2;
                    int n5 = lexer.nextInt();
                    Object object = new double[n5];
                    double[] dArray = new double[n5];
                    for (n2 = 0; n2 < n5; ++n2) {
                        object[n2] = lexer.nextDouble();
                        dArray[n2] = lexer.nextDouble();
                    }
                    if (c == 'p' || c == 'P' || c == 'L') {
                        double_ = new Path2D.Double();
                        for (n = 0; n < n5 - 1; ++n) {
                            double_.append(new Line2D.Double(object[n], dArray[n], object[n + 1], dArray[n + 1]), n != 0);
                        }
                        if (c != 'L') {
                            double_.closePath();
                        }
                        xDotShape = new XDotShape(double_, this.lineColor, c == 'P' ? this.fillColor : null, null, null);
                    } else {
                        double_ = new Path2D.Double();
                        for (n = 0; n < n5 - 1; n += 3) {
                            double_.append(new CubicCurve2D.Double(object[n], dArray[n], object[n + 1], dArray[n + 1], object[n + 2], dArray[n + 2], object[n + 3], dArray[n + 3]), n != 0);
                        }
                        xDotShape = new XDotShape(double_, this.lineColor, c == 'b' ? this.fillColor : null, null, null);
                    }
                    this.shapes.add(xDotShape);
                    this.addShapeToCurrentElement(xDotShape);
                    break;
                }
                case 'E': 
                case 'e': {
                    double d = lexer.nextDouble();
                    double d2 = lexer.nextDouble();
                    double d3 = lexer.nextDouble();
                    double d4 = lexer.nextDouble();
                    RectangularShape rectangularShape = new Ellipse2D.Double(d - d3, d2 - d4, d3 * 2.0, d4 * 2.0);
                    XDotShape xDotShape = new XDotShape(rectangularShape, this.lineColor, c == 'E' ? this.fillColor : null, null, null);
                    this.shapes.add(xDotShape);
                    this.addShapeToCurrentElement(xDotShape);
                    break;
                }
                case 'F': {
                    double d = lexer.nextDouble();
                    String string3 = lexer.nextString();
                    this.font = new Font(string3, 0, (int)d);
                    break;
                }
                case 'T': {
                    double d = lexer.nextDouble();
                    double d5 = lexer.nextDouble();
                    int n = lexer.nextInt();
                    double d6 = lexer.nextDouble();
                    String string4 = lexer.nextString();
                    RectangularShape rectangularShape = new TextShape(d, d5, n, d6, string4, this.font);
                    XDotShape xDotShape = new XDotShape(rectangularShape, null, null, this.lineColor, null);
                    this.shapes.add(xDotShape);
                    this.addShapeToCurrentElement(xDotShape);
                    break;
                }
                case 'S': {
                    String string2 = lexer.nextString();
                    break;
                }
                default: {
                    throw new RuntimeException("FIXME: Unknown action '" + c + "'");
                }
            }
            c = lexer.nextChar();
        }
    }

    public void addShapeToCurrentElement(XDotShape xDotShape) {
        if (this.currentElement == null) {
            return;
        }
        xDotShape.setElement(this.currentElement);
        ArrayList<XDotShape> arrayList = (ArrayList<XDotShape>)this.elementShapes.get(this.currentElement);
        if (arrayList == null) {
            arrayList = new ArrayList<XDotShape>();
            this.elementShapes.mark(this.currentElement, arrayList);
        }
        arrayList.add(xDotShape);
    }

    public List<XDotShape> parseXDotFile(InputStream inputStream) throws IOException {
        this.shapes = new ArrayList<XDotShape>();
        this.elementShapes.clear();
        this.bounds = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        Pattern pattern = Pattern.compile("(_(l|h|t|hl|tl)?draw_)\\s*=\\s*\"([^\"]*)\"");
        Pattern pattern2 = Pattern.compile("(id\\s*=\\s*|cluster_)(\\w+)");
        Pattern pattern3 = Pattern.compile("bb\\s*=\\s*\"(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*)\"");
        this.setCurrentElement(this.graph);
        String string = bufferedReader.readLine();
        while (string != null) {
            Matcher matcher;
            StringBuilder stringBuilder = new StringBuilder();
            while (string != null && string.endsWith("\\")) {
                stringBuilder.append(string.substring(0, string.length() - 1));
                string = bufferedReader.readLine();
            }
            if (string != null) {
                stringBuilder.append(string);
            }
            string = stringBuilder.toString().replace("\\\"", "\u0001");
            if (this.bounds == null && (matcher = pattern3.matcher(string)).find()) {
                double d = Double.parseDouble(matcher.group(1));
                double d2 = Double.parseDouble(matcher.group(2));
                double d3 = Double.parseDouble(matcher.group(3));
                double d4 = Double.parseDouble(matcher.group(4));
                this.bounds = new Rectangle2D.Double(d, d2, d3, d4);
            }
            if ((matcher = pattern2.matcher(string)).find()) {
                String string2 = matcher.group(2);
                if (string2.charAt(0) == 'v') {
                    this.setCurrentElement(this.graph.getVertex(Integer.parseInt(string2.substring(1))));
                } else if (string2.charAt(0) == 'e') {
                    this.setCurrentElement(this.graph.getEdge(Integer.parseInt(string2.substring(1))));
                } else {
                    throw new RuntimeException("FIXME: unexpected id format '" + string2 + "'");
                }
            }
            Matcher matcher2 = pattern.matcher(string);
            while (matcher2.find()) {
                String string3 = matcher2.group(3).replace("\u0001", "\"");
                this.parseDrawActions(string3);
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return this.shapes;
    }

    private void setCurrentElement(AttributedElement<?, ?> attributedElement) {
        if (this.currentElement != attributedElement) {
            this.currentElement = attributedElement;
        }
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    final class Lexer {
        final String s;
        final char[] c;
        int p;

        Lexer(String string) {
            this.s = string;
            this.c = string.toCharArray();
            this.p = 0;
            this.consumeWhitespace();
        }

        final void consumeWhitespace() {
            while (this.p < this.c.length && Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
        }

        final char nextChar() {
            if (this.p >= this.c.length) {
                return '\u0000';
            }
            char c = this.c[this.p++];
            this.consumeWhitespace();
            return c;
        }

        final int nextInt() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int n = this.p;
            while (this.p < this.c.length && !Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
            int n2 = Integer.parseInt(this.s.substring(n, this.p));
            this.consumeWhitespace();
            return n2;
        }

        final double nextDouble() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int n = this.p;
            while (this.p < this.c.length && !Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
            double d = Double.parseDouble(this.s.substring(n, this.p));
            this.consumeWhitespace();
            return d;
        }

        final String nextString() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int n = this.nextInt();
            this.consumeWhitespace();
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            if (this.c[this.p] != '-') {
                throw new IllegalArgumentException();
            }
            ++this.p;
            String string = this.s.substring(this.p, this.p + n);
            this.p += n;
            this.consumeWhitespace();
            return string;
        }
    }
}

