/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2schemagraph;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.utilities.tg2schemagraph.Schema2SchemaGraph;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class Tg2SchemaGraph {
    public SchemaGraph process(String string) throws GraphIOException {
        Schema2SchemaGraph schema2SchemaGraph = new Schema2SchemaGraph();
        Schema schema = GraphIO.loadSchemaFromFile(string);
        return schema2SchemaGraph.convert2SchemaGraph(schema);
    }

    public static void main(String[] stringArray) {
        CommandLine commandLine = Tg2SchemaGraph.processCommandLineOptions(stringArray);
        assert (commandLine != null);
        Tg2SchemaGraph tg2SchemaGraph = new Tg2SchemaGraph();
        try {
            SchemaGraph schemaGraph = tg2SchemaGraph.process(commandLine.getOptionValue("s"));
            schemaGraph.save(commandLine.getOptionValue("o"));
        }
        catch (GraphIOException graphIOException) {
            graphIOException.printStackTrace();
            System.out.println("\nAn error occured while trying to save the graph.");
        }
    }

    private static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + Tg2SchemaGraph.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("o", "output", true, "(required): the output file name");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("s", "schema", true, "(required): the schema of which a schemaGraph should be generated");
        option2.setRequired(true);
        option2.setArgName("file");
        optionHandler.addOption(option2);
        return optionHandler.parse(stringArray);
    }
}

