/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TGraphBrowserServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestThread
extends Thread {
    static final String SVG_WITH_ZOOM_AND_MOVE_SUPPORT = "resources/svgNavigation.svg";
    private static File workspace;
    private final StateRepository rep;
    public static Long MAXIMUM_FILE_SIZE;
    public static long MAXIMUM_WORKSPACE_SIZE;
    private final Socket _socket;
    private static final HashSet<String> svgToDelete;
    private String viewBoxDimension = "";

    public RequestThread(Socket socket, String string) {
        this._socket = socket;
        workspace = string == null ? null : new File(string);
        this.rep = new StateRepository(workspace, this);
    }

    private static void sendHeader(BufferedOutputStream bufferedOutputStream, int n, String string, long l, long l2) throws IOException {
        bufferedOutputStream.write(("HTTP/1.0 " + n + " OK\r\n" + "Date: " + new Date().toString() + "\r\n" + "Server: JibbleWebServer/1.0\r\n" + "Content-Type: " + string + "\r\n" + "Expires: Thu, 01 Dec 1994 16:00:00 GMT\r\n" + (l != -1L ? "Content-Length: " + l + "\r\n" : "") + "Last-modified: " + new Date(l2).toString() + "\r\n" + "\r\n").getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendError(BufferedOutputStream bufferedOutputStream, int n, String string) throws IOException {
        try {
            string = string + "<hr>" + "SimpleWebServer  http://www.jibble.org/";
            RequestThread.sendHeader(bufferedOutputStream, n, "text/html", string.length(), System.currentTimeMillis());
            bufferedOutputStream.write(string.getBytes());
            bufferedOutputStream.flush();
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    @Override
    public void run() {
        try {
            this._socket.setSoTimeout(30000);
            InputStream inputStream = this._socket.getInputStream();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this._socket.getOutputStream());
            String string = this.readLine(dataInputStream);
            String string2 = URLDecoder.decode(string != null ? string : "", "UTF-8");
            if (string2 == null || !string2.startsWith("GET ") && !string2.startsWith("POST ") || !string2.endsWith(" HTTP/1.0") && !string2.endsWith("HTTP/1.1")) {
                RequestThread.sendError(bufferedOutputStream, 500, "Invalid Method.");
                return;
            }
            if (string2.startsWith("POST ")) {
                this.handlePostRequest(dataInputStream, bufferedOutputStream, string2);
            } else {
                this.handleGetRequest(bufferedOutputStream, string2);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void handleGetRequest(BufferedOutputStream bufferedOutputStream, String string) throws IOException, FileNotFoundException {
        TGraphBrowserServer.logger.info(string);
        String string2 = string.substring(5, string.length() - 9);
        if (string2.isEmpty()) {
            this.sendFile(bufferedOutputStream, "TGraphBrowser_GraphChoice.html");
        } else if (string2.contains("jgralab-logo.png")) {
            this.sendFile(bufferedOutputStream, "jgralab-logo.png");
        } else if (string2.contains("plus.png")) {
            this.sendFile(bufferedOutputStream, "plus.png");
        } else if (string2.contains("minus.png")) {
            this.sendFile(bufferedOutputStream, "minus.png");
        } else if (string2.endsWith("svg")) {
            this.handleRequestForSVG(bufferedOutputStream, string2);
        } else {
            this.handleGetMethodCall(bufferedOutputStream, string2);
        }
    }

    private void handleGetMethodCall(BufferedOutputStream bufferedOutputStream, String string) throws IOException {
        Object object;
        String[] stringArray = string.split(Pattern.quote("?"));
        String string2 = stringArray.length > 0 ? stringArray[0] : null;
        String[] stringArray2 = null;
        if (stringArray.length > 1) {
            object = stringArray[1].split("&");
            stringArray2 = new String[((String[])object).length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = ((String)object[i]).split("=")[1];
            }
        }
        object = this.callMethod(bufferedOutputStream, string2, stringArray2);
        if (string2.equals("loadGraphFromURI") || string2.equals("loadGraphFromServer")) {
            if (((StringBuilder)object).toString().equals("-1")) {
                this.sendFile(bufferedOutputStream, "TGraphBrowser_GraphChoice_AfterError.html", "The tg.-file is too big!");
            } else {
                try {
                    this.sendFile(bufferedOutputStream, "TGraphBrowser_GraphLoaded.html", "= " + object + ";\n\t\t timestamp = " + StateRepository.getSession((int)Integer.parseInt((String)((StringBuilder)object).toString())).lastAccess);
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = ((StringBuilder)object).toString();
                    String[] stringArray3 = string3.split(Pattern.quote("ERROR: "));
                    if (stringArray3.length > 0) {
                        stringArray3 = stringArray3[1].split(Pattern.quote("\""));
                        string3 = stringArray3[0];
                    }
                    this.sendFile(bufferedOutputStream, "TGraphBrowser_GraphChoice_AfterError.html", string3);
                }
            }
        } else {
            this.sendMessage(bufferedOutputStream, (StringBuilder)object);
        }
    }

    private void handleRequestForSVG(BufferedOutputStream bufferedOutputStream, String string) throws IOException {
        if (string.charAt(0) == '_') {
            if (svgToDelete.contains(string)) {
                svgToDelete.remove(string);
            } else {
                svgToDelete.add(string);
            }
        }
        String string2 = System.getProperty("java.io.tmpdir") + File.separator + "tgraphbrowser" + File.separator + (string.charAt(0) == '_' ? string.substring(1) : string);
        File file = new File(string2);
        long l = System.currentTimeMillis() + 10000L;
        while (!file.exists() && System.currentTimeMillis() <= l) {
            try {
                RequestThread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (file.exists()) {
            this.sendSVG(bufferedOutputStream, string2);
            if (!svgToDelete.contains(string) && !file.delete()) {
                TGraphBrowserServer.logger.warning(file.toString() + " could not be deleted.");
            }
        } else {
            this.sendMessage(bufferedOutputStream, new StringBuilder(file.toString() + " was not created."));
        }
    }

    private void handlePostRequest(DataInputStream dataInputStream, BufferedOutputStream bufferedOutputStream, String string) throws IOException, FileNotFoundException {
        Long l = null;
        String string2 = null;
        do {
            String string3;
            if ((string3 = this.readLine(dataInputStream)).startsWith("Content-Type")) {
                string2 = string3;
                continue;
            }
            if (!string3.startsWith("Content-Length:")) continue;
            l = Long.parseLong(string3.substring(16));
        } while (l == null || string2 == null);
        if (string2.contains("multipart/form-data")) {
            this.handleFileUpload(dataInputStream, bufferedOutputStream, string, l, string2);
        } else {
            this.handleNoFileUpload(dataInputStream, bufferedOutputStream, l);
        }
    }

    private void handleNoFileUpload(DataInputStream dataInputStream, BufferedOutputStream bufferedOutputStream, Long l) throws IOException {
        long l2;
        String string;
        while ((string = this.readLine(dataInputStream)) != null && !string.isEmpty()) {
        }
        byte[] byArray = new byte[l.intValue()];
        if (dataInputStream.read(byArray) <= 0) {
            TGraphBrowserServer.logger.info("content could not be read");
        }
        String string2 = new String(byArray);
        String[] stringArray = Pattern.compile(Matcher.quoteReplacement("\n")).split(string2);
        String string3 = stringArray[0];
        long l3 = l2 = string3.equals("undefined") ? Long.MIN_VALUE : Long.parseLong(string3);
        if (l2 + TGraphBrowserServer.DeleteUnusedStates.timeout < System.currentTimeMillis()) {
            this.sendErrorMessage(bufferedOutputStream, "This session was deleted because there wasn't any communication with the server in the last " + TGraphBrowserServer.DeleteUnusedStates.timeout / 1000L + "sec.");
        } else if (l2 < TGraphBrowserServer.starttime) {
            this.sendErrorMessage(bufferedOutputStream, "This server was restarted. This session is too old.");
        } else {
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string4);
            for (int i = 3; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            StringBuilder stringBuilder = this.callMethod(bufferedOutputStream, string5, arrayList.toArray(new String[0]));
            if (stringBuilder != null) {
                this.sendMessage(bufferedOutputStream, stringBuilder);
            }
        }
    }

    private void handleFileUpload(DataInputStream dataInputStream, BufferedOutputStream bufferedOutputStream, String string, Long l, String string2) throws IOException, FileNotFoundException {
        String string3;
        TGraphBrowserServer.logger.info(string);
        boolean bl = string.contains("overwrite=true");
        String string4 = string2.split("boundary=")[1];
        String[] stringArray = string4.split("-");
        string4 = stringArray[stringArray.length - 1];
        while (!(string3 = this.readLine(dataInputStream)).contains(string4)) {
        }
        int n = string3.length() + 2;
        string3 = this.readLine(dataInputStream);
        n += string3.length() + 2;
        String string5 = string3.split("filename=")[1];
        if (!(string5 = string5.substring(1, string5.length() - 1)).toLowerCase().endsWith(".tg") && !string5.toLowerCase().endsWith(".gz")) {
            this.sendFile(bufferedOutputStream, "TGraphBrowser_GraphChoice_AfterError.html", "You can only upload .tg or .gz files!");
        } else if (!RequestThread.isSizeOk(l)) {
            this.sendFile(bufferedOutputStream, "TGraphBrowser_GraphChoice_AfterError.html", "The .tg file is too big!");
        } else {
            File file = this.receiveFile(dataInputStream, l, string3, bl, n, string5);
            int n2 = StateRepository.createNewSession(file.getAbsolutePath());
            this.sendFile(bufferedOutputStream, "TGraphBrowser_GraphLoaded.html", "= " + n2 + ";\n\t\ttimestamp = " + StateRepository.getSession((int)n2).lastAccess);
        }
    }

    private File receiveFile(DataInputStream dataInputStream, Long l, String string, boolean bl, int n, String string2) throws IOException, FileNotFoundException {
        while (string != null && !string.isEmpty()) {
            string = this.readLine(dataInputStream);
            n += string.length() + 2;
        }
        boolean bl2 = string2.endsWith(".gz");
        string2 = workspace.toString() + "/" + string2.substring(0, string2.length() - 3);
        File file = new File(string2 + (bl2 ? ".gz" : ".tg"));
        if (!bl) {
            int n2 = 0;
            while (file.exists()) {
                file = new File(string2 + n2 + (bl2 ? ".gz" : ".tg"));
                ++n2;
            }
        }
        if (!file.createNewFile()) {
            TGraphBrowserServer.logger.info(file.toString() + " overwrites an existing file or could not be created.");
        }
        l = l - (long)n;
        BufferedOutputStream bufferedOutputStream = this.createFile(dataInputStream, l, file);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return file;
    }

    private BufferedOutputStream createFile(DataInputStream dataInputStream, Long l, File file) throws FileNotFoundException, IOException {
        long l2;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray = new byte[l < 4096L ? (int)(l % 4096L) : 4096];
        int n = 1;
        for (l2 = 0L; l2 < l - (long)byArray.length; l2 += (long)n) {
            n = dataInputStream.read(byArray);
            if (n <= 0) break;
            bufferedOutputStream.write(byArray, 0, n);
        }
        if (n > 0) {
            byArray = new byte[(int)(l - l2) % (byArray.length + 1)];
            n = dataInputStream.read(byArray);
            l2 += (long)n;
        }
        int n2 = this.findEndOfFileInMultipart(byArray, n);
        bufferedOutputStream.write(byArray, 0, n2 + 1);
        return bufferedOutputStream;
    }

    private String readLine(DataInputStream dataInputStream) throws IOException {
        byte[] byArray;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = dataInputStream.read(byArray = new byte[1])) > 0) {
            String string = new String(byArray, "UTF-8");
            if (!string.equals("\n") && !string.equals("\r")) {
                stringBuilder.append(string);
            }
            if (!string.equals("\n")) continue;
        }
        return stringBuilder.toString().trim();
    }

    private int findEndOfFileInMultipart(byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = n - 1; n2 > 0 && n3 < 2; --n2) {
            if (byArray[n2] != 13) continue;
            ++n3;
        }
        return n2;
    }

    private StringBuilder callMethod(BufferedOutputStream bufferedOutputStream, String string, String[] stringArray) throws IOException {
        Method method = StateRepository.definedMethods.get(string);
        if (method == null) {
            this.sendErrorMessage(bufferedOutputStream, "There does not exist a method with name " + string + ".");
            return new StringBuilder();
        }
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = classArray[i] == Integer.class ? Integer.valueOf(Integer.parseInt(stringArray[i])) : (classArray[i] == Boolean.class ? Boolean.valueOf(Boolean.parseBoolean(stringArray[i])) : stringArray[i]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            stringBuilder.append((i == 0 ? "" : ", ") + (objectArray[i] instanceof String ? "\"" : "") + objectArray[i] + (objectArray[i] instanceof String ? "\"" : ""));
        }
        TGraphBrowserServer.logger.info("StateRepository." + string + "(" + stringBuilder.toString() + ")");
        try {
            return (StringBuilder)method.invoke((Object)this.rep, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.sendErrorMessage(bufferedOutputStream, illegalArgumentException.toString());
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.sendErrorMessage(bufferedOutputStream, illegalAccessException.toString());
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.sendErrorMessage(bufferedOutputStream, invocationTargetException.getCause().toString());
            invocationTargetException.printStackTrace();
        }
        return null;
    }

    public static synchronized boolean isSizeOk(long l) {
        if (MAXIMUM_FILE_SIZE == null) {
            return true;
        }
        if (l > MAXIMUM_FILE_SIZE) {
            return false;
        }
        return workspace.getTotalSpace() + l <= MAXIMUM_WORKSPACE_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(BufferedOutputStream bufferedOutputStream, String string) throws IOException, FileNotFoundException {
        try (InputStream inputStream = null;){
            if (this._socket.isConnected()) {
                int n;
                RequestThread.sendHeader(bufferedOutputStream, 200, string.endsWith(".svg") ? "image/svg+xml" : (string.endsWith(".png") ? "image/png" : "text/html"), -1L, System.currentTimeMillis());
                inputStream = new File(string).isAbsolute() ? new FileInputStream(string) : this.getClass().getResourceAsStream("resources/" + string);
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(BufferedOutputStream bufferedOutputStream, String string, String string2) throws IOException {
        if (this._socket.isConnected()) {
            RequestThread.sendHeader(bufferedOutputStream, 200, "text/html", -1L, System.currentTimeMillis());
            try (BufferedReader bufferedReader = null;){
                bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("resources/" + string)));
                boolean bl = false;
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    if (!bl && string3.contains("/*?*/")) {
                        string3 = string3.replace("/*?*/", string2);
                        bl = true;
                    }
                    if (bl) {
                        bufferedOutputStream.write((string3 + "\n").getBytes());
                        break;
                    }
                    bufferedOutputStream.write((string3 + "\n").getBytes());
                    string3 = bufferedReader.readLine();
                }
                if (string3 != null) {
                    int n;
                    char[] cArray = new char[4096];
                    while ((n = bufferedReader.read(cArray)) != -1) {
                        bufferedOutputStream.write(new String(cArray).getBytes(), 0, n);
                    }
                }
            }
        }
    }

    private void sendSVG(BufferedOutputStream bufferedOutputStream, String string) throws IOException {
        RequestThread.sendHeader(bufferedOutputStream, 200, "image/svg+xml", -1L, System.currentTimeMillis());
        if (this._socket.isConnected()) {
            StringBuilder stringBuilder = this.getContentOfCreatedSVG(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(SVG_WITH_ZOOM_AND_MOVE_SUPPORT)));
            boolean bl = false;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.contains("?viewBox?")) {
                    string2 = string2.replace("?viewBox?", this.viewBoxDimension);
                }
                if (!bl && string2.contains("<!--  -->")) {
                    bufferedOutputStream.write(stringBuilder.toString().getBytes());
                    bl = true;
                    break;
                }
                bufferedOutputStream.write((string2 + "\n").getBytes());
                string2 = bufferedReader.readLine();
            }
            if (string2 != null) {
                int n;
                char[] cArray = new char[4096];
                while ((n = bufferedReader.read(cArray)) != -1) {
                    bufferedOutputStream.write(new String(cArray).getBytes(), 0, n);
                }
            }
            bufferedReader.close();
        }
    }

    private StringBuilder getContentOfCreatedSVG(String string) throws IOException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("<g ")) {
            if (!string2.contains("viewBox=\"")) continue;
            String string3 = string2.split(Pattern.quote("viewBox=\""))[1];
            this.viewBoxDimension = string3.substring(0, string3.indexOf("\""));
        }
        if (string2 != null) {
            stringBuilder.append(string2 + "\n");
        }
        while (string2 != null && !string2.startsWith("</svg>")) {
            string2 = bufferedReader.readLine();
            if (string2 == null || string2.startsWith("</svg>")) continue;
            stringBuilder.append(string2 + "\n");
        }
        bufferedReader.close();
        return stringBuilder;
    }

    private void sendMessage(BufferedOutputStream bufferedOutputStream, StringBuilder stringBuilder) throws IOException {
        if (this._socket.isConnected()) {
            RequestThread.sendHeader(bufferedOutputStream, 200, "text/html", -1L, System.currentTimeMillis());
            String string = "{ \"method\": " + stringBuilder.toString() + " }";
            bufferedOutputStream.write(string.getBytes());
        }
    }

    private void sendErrorMessage(BufferedOutputStream bufferedOutputStream, String string) throws IOException {
        if (this._socket.isConnected()) {
            RequestThread.sendHeader(bufferedOutputStream, 200, "text/html", -1L, System.currentTimeMillis());
            String string2 = "{ \"method\": function() {\ndocument.getElementById('loadError').innerHTML = \"ERROR: " + string + "\";\n" + "document.getElementById('divError').style.display = \"block\";\n" + "document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: " + string + "\";\n" + "document.getElementById('divNonError').style.display = \"none\";\n" + " } }";
            bufferedOutputStream.write(string2.getBytes());
        }
    }

    static {
        svgToDelete = new HashSet();
    }
}

