/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.utilities.tgtree.EdgeTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementCellRenderer;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.TGraphTreeModel;
import de.uni_koblenz.jgralab.utilities.tgtree.VertexTreeNode;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;

public class TGTree
extends JFrame {
    private static final long serialVersionUID = 7575497288342049993L;
    private Graph graph;
    private JTree tree;
    JScrollPane scrollPane;

    public TGTree(Graph graph) {
        super("TGTree <" + graph.getId() + ">");
        this.graph = graph;
        JMenuBar jMenuBar = new JMenuBar();
        JLabel jLabel = new JLabel("Select by id: ");
        jMenuBar.add(jLabel);
        final JTextField jTextField = new JTextField();
        jMenuBar.add(jTextField);
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                char c = string.charAt(0);
                int n = Integer.parseInt(string.substring(1));
                if (c == 'v') {
                    TGTree.this.setTreeViewRoot(TGTree.this.graph.getVertex(n));
                } else if (c == 'e') {
                    TGTree.this.setTreeViewRoot(TGTree.this.graph.getEdge(n));
                }
            }
        });
        this.setJMenuBar(jMenuBar);
        Container container = this.getContentPane();
        this.tree = new JTree(new TGraphTreeModel(new VertexTreeNode(this.graph.getFirstVertex(), null)));
        this.tree.setCellRenderer(new GraphElementCellRenderer());
        this.tree.addMouseListener(new TreeViewMouseAdapter());
        this.tree.addKeyListener(new TreeViewKeyAdapter());
        int n = 1;
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(n);
            n += 2;
        }
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.tree);
        container.add(this.scrollPane);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setDefaultCloseOperation(2);
        this.setSize(800, 800);
        this.pack();
    }

    public void setTreeViewRoot(GraphElement<?, ?> graphElement) {
        GraphElementTreeNode graphElementTreeNode = null;
        if (graphElement instanceof Edge) {
            graphElementTreeNode = new EdgeTreeNode((Edge)graphElement, null);
        } else if (graphElement instanceof Vertex) {
            graphElementTreeNode = new VertexTreeNode((Vertex)graphElement, null);
        } else {
            throw new RuntimeException(graphElement + " is neither Vertex nor Edge.");
        }
        this.tree.setModel(new TGraphTreeModel(graphElementTreeNode));
        int n = 1;
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(n);
            n += 2;
        }
    }

    public void copySelectionToClipboard(GraphElementTreeNode graphElementTreeNode) {
        String string = graphElementTreeNode.getClipboardText();
        System.out.println(string + " ==> Clipboard");
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public static void main(String[] stringArray) throws GraphIOException {
        if (stringArray.length != 1) {
            System.err.println("Usage: TGTree <graphfile>");
            System.exit(1);
        }
        Graph graph = GraphIO.loadGraphFromFile(stringArray[0], new ConsoleProgressFunction("Loading"));
        TGTree tGTree = new TGTree(graph);
        tGTree.setDefaultCloseOperation(3);
        tGTree.setVisible(true);
    }

    private class TreeViewMouseAdapter
    extends MouseAdapter {
        private TreeViewMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopupTrigger(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopupTrigger(mouseEvent);
            }
        }

        private void handlePopupTrigger(MouseEvent mouseEvent) {
            final GraphElementTreeNode graphElementTreeNode = (GraphElementTreeNode)TGTree.this.tree.getLastSelectedPathComponent();
            if (graphElementTreeNode == null) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu("Context Menu");
            jPopupMenu.add(new AbstractAction("Set Root"){
                private static final long serialVersionUID = 6789881997870852275L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TGTree.this.setTreeViewRoot(graphElementTreeNode.get());
                }
            });
            jPopupMenu.add(new AbstractAction("Copy to Clipboard"){
                private static final long serialVersionUID = 2860962360240219247L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TGTree.this.copySelectionToClipboard(graphElementTreeNode);
                }
            });
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class TreeViewKeyAdapter
    extends KeyAdapter {
        private TreeViewKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            GraphElementTreeNode graphElementTreeNode = (GraphElementTreeNode)TGTree.this.tree.getLastSelectedPathComponent();
            if (graphElementTreeNode == null) {
                return;
            }
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyChar() == '\n') {
                TGTree.this.setTreeViewRoot(graphElementTreeNode.get());
            } else if (keyEvent.getKeyChar() == 'c') {
                TGTree.this.copySelectionToClipboard(graphElementTreeNode);
            }
        }
    }
}

