/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.pcollections.PVector;

public final class ArrayPVector<E>
implements PVector<E>,
Serializable {
    private static final long serialVersionUID = -3381080251584514162L;
    private static final int INITIAL_SIZE = 10;
    private static final double GROW_FACTOR = 1.5;
    private E[] value;
    private int count;
    private int offset;
    private boolean sublist;
    private transient int hashCode;
    private static ArrayPVector<?> empty = new ArrayPVector();

    private ArrayPVector() {
        this.hashCode = 0;
    }

    private ArrayPVector(E[] EArray, int n, int n2) {
        this.value = EArray;
        this.offset = n;
        this.count = n2;
        this.sublist = false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof List)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ArrayPVector) {
            ArrayPVector arrayPVector = (ArrayPVector)object;
            if (this.count != arrayPVector.count) {
                return false;
            }
            for (int i = 0; i < this.count; ++i) {
                if (this.value[this.offset + i].equals(arrayPVector.value[arrayPVector.offset + i])) continue;
                return false;
            }
            return true;
        }
        List list = (List)object;
        if (list.size() != this.count) {
            return false;
        }
        int n = 0;
        for (Object e : list) {
            if (this.value[this.offset + n++].equals(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            for (int i = 0; i < this.count; ++i) {
                this.hashCode = 31 * this.hashCode + this.value[this.offset + i].hashCode();
            }
        }
        return this.hashCode;
    }

    public static <T> ArrayPVector<T> empty() {
        return empty;
    }

    @Override
    @Deprecated
    public void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public E remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public E set(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (!this.value[this.offset + i].equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new PIterator();
    }

    @Override
    public Object[] toArray() {
        if (this.count == 0) {
            return new Object[0];
        }
        return Arrays.copyOfRange(this.value, this.offset, this.offset + this.count);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length >= this.count) {
            if (this.count > 0) {
                System.arraycopy(this.value, this.offset, TArray, 0, this.count);
            }
            if (TArray.length > this.count) {
                TArray[this.count] = null;
            }
            return TArray;
        }
        return Arrays.copyOfRange(this.value, this.offset, this.offset + this.count, TArray.getClass());
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.value[this.offset + n];
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = 0; i < this.count; ++i) {
            if (!this.value[this.offset + i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = this.count - 1; i >= 0; --i) {
            if (!this.value[this.offset + i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new PListIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new PListIterator(n);
    }

    @Override
    public PVector<E> minus(Object object) {
        if (object == null) {
            return this;
        }
        int n = this.indexOf(object);
        return n < 0 ? this : this.minus(n);
    }

    @Override
    public PVector<E> minus(int n) {
        ArrayPVector<Object> arrayPVector;
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0) {
            arrayPVector = new ArrayPVector<E>(this.value, this.offset + 1, this.count - 1);
            arrayPVector.sublist = true;
        } else if (n == this.count - 1) {
            arrayPVector = new ArrayPVector<E>(this.value, this.offset, this.count - 1);
            arrayPVector.sublist = true;
        } else {
            Object[] objectArray = new Object[this.count - 1];
            System.arraycopy(this.value, this.offset, objectArray, 0, n);
            System.arraycopy(this.value, this.offset + n + 1, objectArray, n, this.count - n - 1);
            arrayPVector = new ArrayPVector<Object>(objectArray, 0, this.count - 1);
        }
        return arrayPVector;
    }

    @Override
    public PVector<E> minusAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        PVector<E> pVector = this;
        for (Object obj : collection) {
            pVector = pVector.minus(obj);
        }
        return pVector;
    }

    @Override
    public PVector<E> plus(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Can't add null to an ArrayPVector");
        }
        if (this.sublist || this.count == 0 || this.offset + this.count + 1 > this.value.length) {
            if (this.count == 0) {
                Object[] objectArray = new Object[10];
                objectArray[0] = e;
                return new ArrayPVector<Object>(objectArray, 0, 1);
            }
            Object[] objectArray = new Object[Math.max(this.count + 1, (int)((double)this.count * 1.5))];
            System.arraycopy(this.value, this.offset, objectArray, 0, this.count);
            objectArray[this.count] = e;
            return new ArrayPVector<Object>(objectArray, 0, this.count + 1);
        }
        this.sublist = true;
        this.value[this.offset + this.count] = e;
        return new ArrayPVector<E>(this.value, this.offset, this.count + 1);
    }

    @Override
    public ArrayPVector<E> plus(int n, E e) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public PVector<E> plusAll(Collection<? extends E> collection) {
        int n = collection.size();
        if (n == 0) {
            return this;
        }
        if (this.count == 0 && collection instanceof ArrayPVector) {
            return (ArrayPVector)collection;
        }
        if (!this.sublist && this.value != null && this.offset + this.count + n <= this.value.length) {
            int n2 = this.count;
            for (E e : collection) {
                if (e == null) {
                    throw new IllegalArgumentException("Can't add null to an ArrayPVector");
                }
                this.value[n2++] = e;
            }
            this.sublist = true;
            return new ArrayPVector<E>(this.value, this.offset, n2);
        }
        Object[] objectArray = new Object[this.count + n];
        if (this.value != null) {
            System.arraycopy(this.value, this.offset, objectArray, 0, this.count);
        }
        int n3 = this.count;
        for (E e : collection) {
            if (e == null) {
                throw new IllegalArgumentException("Can't add null to an ArrayPVector");
            }
            objectArray[n3++] = e;
        }
        return new ArrayPVector<Object>(objectArray, 0, n3);
    }

    @Override
    public ArrayPVector<E> plusAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (collection.isEmpty()) {
            return this;
        }
        int n2 = this.count + collection.size();
        Object[] objectArray = new Object[n2];
        if (n > 0) {
            System.arraycopy(this.value, 0, objectArray, 0, n);
        }
        int n3 = n;
        for (E e : collection) {
            objectArray[n3++] = e;
        }
        if (n < this.count) {
            System.arraycopy(this.value, n, objectArray, n2 - this.count + n, this.count - n);
        }
        return new ArrayPVector<Object>(objectArray, 0, n2);
    }

    @Override
    public ArrayPVector<E> subList(int n, int n2) {
        if (n == 0 && n2 == this.count) {
            return this;
        }
        if (n < 0 || n2 > this.count || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return ArrayPVector.empty();
        }
        ArrayPVector<E> arrayPVector = new ArrayPVector<E>(this.value, this.offset + n, n2 - n);
        arrayPVector.sublist = true;
        return arrayPVector;
    }

    @Override
    public ArrayPVector<E> with(int n, E e) {
        if (e == null) {
            throw new IllegalArgumentException("Can't set an element to null in an ArrayPVector");
        }
        if (this.get(n).equals(e)) {
            return this;
        }
        E[] EArray = Arrays.copyOfRange(this.value, this.offset, this.offset + this.count);
        EArray[n] = e;
        return new ArrayPVector<E>(EArray, 0, this.count);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.count; ++i) {
            stringBuilder.append(this.value[this.offset + i].toString());
            if (i >= this.count - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append("]").toString();
    }

    public class PListIterator
    extends PIterator
    implements ListIterator<E> {
        public PListIterator() {
        }

        public PListIterator(int n) {
            if (n < 0 || n > ArrayPVector.this.count) {
                throw new IndexOutOfBoundsException();
            }
            this.cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E previous() {
            if (this.cursor == 0) {
                throw new NoSuchElementException();
            }
            return ArrayPVector.this.value[--this.cursor + ArrayPVector.this.offset];
        }

        @Override
        public int nextIndex() {
            return this.cursor + 1;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    public class PIterator
    implements Iterator<E> {
        protected int cursor;

        @Override
        public boolean hasNext() {
            return this.cursor < ArrayPVector.this.count;
        }

        @Override
        public E next() {
            if (this.cursor == ArrayPVector.this.count) {
                throw new NoSuchElementException();
            }
            return ArrayPVector.this.value[ArrayPVector.this.offset + this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

