/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.pcollections.PStack;

public final class ConsPStack<E>
extends AbstractSequentialList<E>
implements PStack<E> {
    private static final ConsPStack<Object> EMPTY = new ConsPStack();
    private final E first;
    private final ConsPStack<E> rest;
    private final int size;

    public static <E> ConsPStack<E> empty() {
        return EMPTY;
    }

    public static <E> ConsPStack<E> singleton(E e) {
        return ConsPStack.empty().plus((Object)e);
    }

    public static <E> ConsPStack<E> from(Collection<? extends E> collection) {
        if (collection instanceof ConsPStack) {
            return (ConsPStack)collection;
        }
        return ConsPStack.from(collection.iterator());
    }

    private static <E> ConsPStack<E> from(Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return ConsPStack.empty();
        }
        E e = iterator.next();
        return ConsPStack.from(iterator).plus((Object)e);
    }

    private ConsPStack() {
        if (EMPTY != null) {
            throw new RuntimeException("empty constructor should only be used once");
        }
        this.size = 0;
        this.first = null;
        this.rest = null;
    }

    private ConsPStack(E e, ConsPStack<E> consPStack) {
        this.first = e;
        this.rest = consPStack;
        this.size = 1 + consPStack.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ListIterator<E> listIterator(final int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new ListIterator<E>(){
            int i;
            ConsPStack<E> next;
            {
                this.i = n;
                this.next = ConsPStack.this.subList(n);
            }

            @Override
            public boolean hasNext() {
                return this.next.size > 0;
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public int nextIndex() {
                return n;
            }

            @Override
            public int previousIndex() {
                return n - 1;
            }

            @Override
            public E next() {
                Object object = this.next.first;
                this.next = this.next.rest;
                return object;
            }

            @Override
            public E previous() {
                System.err.println("ConsPStack.listIterator().previous() is inefficient, don't use it!");
                this.next = ConsPStack.this.subList(n - 1);
                return this.next.first;
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ConsPStack<E> subList(int n, int n2) {
        if (n < 0 || n2 > this.size || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == this.size) {
            return this.subList(n);
        }
        if (n == n2) {
            return ConsPStack.empty();
        }
        if (n == 0) {
            return new ConsPStack<E>(this.first, this.rest.subList(0, n2 - 1));
        }
        return this.rest.subList(n - 1, n2 - 1);
    }

    @Override
    public ConsPStack<E> plus(E e) {
        return new ConsPStack<E>(e, this);
    }

    @Override
    public ConsPStack<E> plusAll(Collection<? extends E> collection) {
        PStack<E> pStack = this;
        for (E e : collection) {
            pStack = pStack.plus((Object)e);
        }
        return pStack;
    }

    @Override
    public ConsPStack<E> plus(int n, E e) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0) {
            return this.plus((Object)e);
        }
        return new ConsPStack<E>(this.first, this.rest.plus(n - 1, (Object)e));
    }

    @Override
    public ConsPStack<E> plusAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0) {
            return this.plusAll((Collection)collection);
        }
        return new ConsPStack<E>(this.first, this.rest.plusAll(n - 1, (Collection)collection));
    }

    @Override
    public ConsPStack<E> minus(Object object) {
        if (this.size == 0) {
            return this;
        }
        if (this.first.equals(object)) {
            return this.rest;
        }
        PStack pStack = this.rest.minus(object);
        if (pStack == this.rest) {
            return this;
        }
        return new ConsPStack<E>(this.first, pStack);
    }

    @Override
    public ConsPStack<E> minus(int n) {
        return this.minus(this.get(n));
    }

    @Override
    public ConsPStack<E> minusAll(Collection<?> collection) {
        if (this.size == 0) {
            return this;
        }
        if (collection.contains(this.first)) {
            return this.rest.minusAll((Collection)collection);
        }
        PStack pStack = this.rest.minusAll((Collection)collection);
        if (pStack == this.rest) {
            return this;
        }
        return new ConsPStack<E>(this.first, pStack);
    }

    @Override
    public ConsPStack<E> with(int n, E e) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0) {
            if (this.first.equals(e)) {
                return this;
            }
            return new ConsPStack<E>(e, this.rest);
        }
        PStack pStack = this.rest.with(n - 1, (Object)e);
        if (pStack == this.rest) {
            return this;
        }
        return new ConsPStack<E>(this.first, pStack);
    }

    @Override
    public ConsPStack<E> subList(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0) {
            return this;
        }
        return this.rest.subList(n - 1);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException();
    }
}

