/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pcollections.ConsPStack;
import org.pcollections.PMap;
import org.pcollections.PSequence;
import org.pcollections.SimpleImmutableEntry;

public final class HashPMap<K, V>
extends AbstractMap<K, V>
implements PMap<K, V> {
    private final PMap<Integer, PSequence<Map.Entry<K, V>>> intMap;
    private final int size;
    private Set<Map.Entry<K, V>> entrySet = null;

    public static <K, V> HashPMap<K, V> empty(PMap<Integer, PSequence<Map.Entry<K, V>>> pMap) {
        return new HashPMap<K, V>(pMap.minusAll(pMap.keySet()), 0);
    }

    private HashPMap(PMap<Integer, PSequence<Map.Entry<K, V>>> pMap, int n) {
        this.intMap = pMap;
        this.size = n;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return HashPMap.this.size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new SequenceIterator(HashPMap.this.intMap.values().iterator());
                }

                @Override
                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Object v = HashPMap.this.get(((Map.Entry)object).getKey());
                    return v != null && v.equals(((Map.Entry)object).getValue());
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return HashPMap.keyIndexIn(this.getEntries(object.hashCode()), object) != -1;
    }

    @Override
    public V get(Object object) {
        PSequence<Map.Entry<K, V>> pSequence = this.getEntries(object.hashCode());
        for (Map.Entry entry : pSequence) {
            if (!entry.getKey().equals(object)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public HashPMap<K, V> plusAll(Map<? extends K, ? extends V> map) {
        PMap<K, V> pMap = this;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            pMap = pMap.plus((Object)entry.getKey(), (Object)entry.getValue());
        }
        return pMap;
    }

    @Override
    public HashPMap<K, V> minusAll(Collection<?> collection) {
        PMap<K, V> pMap = this;
        for (Object obj : collection) {
            pMap = pMap.minus(obj);
        }
        return pMap;
    }

    @Override
    public HashPMap<K, V> plus(K k, V v) {
        PSequence<Map.Entry<K, V>> pSequence = this.getEntries(k.hashCode());
        int n = pSequence.size();
        int n2 = HashPMap.keyIndexIn(pSequence, k);
        if (n2 != -1) {
            pSequence = pSequence.minus(n2);
        }
        pSequence = pSequence.plus(new SimpleImmutableEntry<K, V>(k, v));
        return new HashPMap<K, V>(this.intMap.plus(k.hashCode(), pSequence), this.size - n + pSequence.size());
    }

    @Override
    public HashPMap<K, V> minus(Object object) {
        PSequence<Map.Entry<K, V>> pSequence = this.getEntries(object.hashCode());
        int n = HashPMap.keyIndexIn(pSequence, object);
        if (n == -1) {
            return this;
        }
        if ((pSequence = pSequence.minus(n)).size() == 0) {
            return new HashPMap<K, V>(this.intMap.minus(object.hashCode()), this.size - 1);
        }
        return new HashPMap<K, V>(this.intMap.plus(object.hashCode(), pSequence), this.size - 1);
    }

    private PSequence<Map.Entry<K, V>> getEntries(int n) {
        PSequence pSequence = (PSequence)this.intMap.get(n);
        if (pSequence == null) {
            return ConsPStack.empty();
        }
        return pSequence;
    }

    private static <K, V> int keyIndexIn(PSequence<Map.Entry<K, V>> pSequence, Object object) {
        int n = 0;
        for (Map.Entry entry : pSequence) {
            if (entry.getKey().equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    static class SequenceIterator<E>
    implements Iterator<E> {
        private final Iterator<PSequence<E>> i;
        private PSequence<E> seq = ConsPStack.empty();

        SequenceIterator(Iterator<PSequence<E>> iterator) {
            this.i = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.seq.size() > 0 || this.i.hasNext();
        }

        @Override
        public E next() {
            if (this.seq.size() == 0) {
                this.seq = this.i.next();
            }
            Object e = this.seq.get(0);
            this.seq = this.seq.subList(1, this.seq.size());
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

