/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DrawingPanel
extends JComponent {
    private static final long serialVersionUID = 1L;
    private RenderingHints antialiasOn;
    private BoundedRangeModel zoomLevelModel;
    private Rectangle2D boundingBox;
    private Dimension preferredSize;
    private double scale;
    private double pixelPerUnit;
    public static final int ZOOM_MAX = 160;
    public static final int ZOOM_INIT = 80;
    public static final int ZOOM_MIN = 0;
    public static final int CONTINUOUS_DRAG_DELAY = 20;
    private boolean positiveYAxis;
    private boolean centerDrawing;

    public BoundedRangeModel getZoomLevelModel() {
        return this.zoomLevelModel;
    }

    public DrawingPanel(boolean centerDrawing, boolean positiveYAxis) {
        this.centerDrawing = centerDrawing;
        this.positiveYAxis = positiveYAxis;
        this.pixelPerUnit = 1.0;
        this.antialiasOn = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.antialiasOn.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.zoomLevelModel = new DefaultBoundedRangeModel(80, 0, 0, 160);
        this.scale = 1.0;
        this.zoomLevelModel.setValue(80);
        this.zoomLevelModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DrawingPanel.this.setScale(DrawingPanel.this.zoomToScale(DrawingPanel.this.zoomLevelModel.getValue()));
            }
        });
        this.setBackground(UIManager.getColor("Panel.background"));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Dimension size = this.getSize();
        Insets i = this.getInsets();
        g2.setColor(this.getBackground());
        size.width -= i.left + i.right;
        size.height -= i.top + i.bottom;
        g2.translate(i.left, i.top);
        Rectangle b = new Rectangle(0, 0, size.width, size.height);
        Rectangle r = g2.getClipBounds();
        g2.setClip(r != null ? b.intersection(r) : b);
        g2.fillRect(0, 0, size.width, size.height);
        if (this.centerDrawing) {
            g2.translate((double)size.width / 2.0, (double)size.height / 2.0);
        } else {
            g2.translate(0, this.positiveYAxis ? 0 : size.height);
        }
        g2.scale(this.scale * this.pixelPerUnit, (this.positiveYAxis ? this.scale : -this.scale) * this.pixelPerUnit);
        if (this.centerDrawing) {
            g2.translate(-this.boundingBox.getWidth() / 2.0, -this.boundingBox.getHeight() / 2.0);
        }
        g2.setRenderingHints(this.antialiasOn);
        this.paintContent(g2);
    }

    public Point screenToModel(Point p) {
        double x = p.x;
        double y = p.y;
        Insets i = this.getInsets();
        Dimension size = this.getSize();
        size.width -= i.left + i.right;
        size.height -= i.top + i.bottom;
        x -= (double)i.top;
        y -= (double)i.top;
        if (this.centerDrawing) {
            x -= (double)size.width / 2.0;
            y -= (double)size.height / 2.0;
        } else {
            y -= this.positiveYAxis ? 0.0 : (double)size.height;
        }
        x /= this.scale * this.pixelPerUnit;
        y /= (this.positiveYAxis ? this.scale : -this.scale) * this.pixelPerUnit;
        if (this.centerDrawing) {
            x -= -this.boundingBox.getWidth() / 2.0;
            y -= -this.boundingBox.getHeight() / 2.0;
        }
        return new Point((int)x, (int)y);
    }

    protected void paintContent(Graphics2D g2) {
    }

    public double getPixelPerUnit() {
        return this.pixelPerUnit;
    }

    public void setPixelPerUnit(double pixelPerUnit) {
        this.pixelPerUnit = pixelPerUnit;
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(Rectangle2D bbx) {
        this.boundingBox = bbx;
        this.calculatePreferredSize();
    }

    private void calculatePreferredSize() {
        if (this.boundingBox == null) {
            throw new IllegalStateException("Bounding box has not been set");
        }
        this.preferredSize = new Dimension((int)Math.round(this.boundingBox.getWidth() * this.scale), (int)Math.round(this.boundingBox.getHeight() * this.scale));
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.boundingBox == null) {
            throw new IllegalStateException("Bounding box has not been set");
        }
        assert (this.preferredSize != null);
        return this.preferredSize;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        throw new UnsupportedOperationException("Preferred size is computed from boundingbox and scale");
    }

    public void zoomToFit(Dimension size) {
        if (this.boundingBox == null) {
            return;
        }
        Insets i = this.getInsets();
        int w = size.width - i.left - i.right;
        int h = size.height - i.top - i.bottom;
        double sc = Math.min((double)w / this.boundingBox.getWidth(), (double)h / this.boundingBox.getHeight());
        this.zoomLevelModel.setValue(this.scaleToZoom(sc));
    }

    private double zoomToScale(int z) {
        return Math.pow(10.0, (double)z / 40.0) / 100.0;
    }

    private void setScale(double scale) {
        this.scale = scale;
        this.calculatePreferredSize();
    }

    private int scaleToZoom(double sc) {
        return Math.max(0, Math.min(160, (int)Math.floor(Math.log10(sc * 100.0) * 40.0)));
    }

    public void zoomIn() {
        this.zoomLevelModel.setValue(this.zoomLevelModel.getValue() + 10);
    }

    public void zoomOut() {
        this.zoomLevelModel.setValue(this.zoomLevelModel.getValue() - 10);
    }
}

