/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import de.uni_koblenz.ist.utilities.gui.SwingApplication;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 8838643052145525312L;
    private final JList familyList;
    private final JLabel previewLabel;
    private final JList styleList;
    private String family;
    private int style;
    private Font selectedFont;
    private final JList sizeList;
    private final BoundedRangeModel fontSize;
    private final JLabel fontNameLabel;
    private final JTextField sizeField;
    private SwingApplication app;

    public static Font selectFont(SwingApplication parent, String title, Font oldFont, boolean monospacedOnly) {
        FontSelectionDialog d = new FontSelectionDialog(parent, title, oldFont, monospacedOnly);
        d.setVisible(true);
        return d.getSelectedFont();
    }

    /*
     * WARNING - void declaration
     */
    private FontSelectionDialog(SwingApplication parent, String title, Font oldFont, boolean monospacedOnly) {
        super((Frame)parent, title != null ? title : parent.getMessage("FontSelectionDialog.Title"));
        this.app = parent;
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                FontSelectionDialog.this.selectedFont = null;
            }
        });
        Object[] availableFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(availableFamilies);
        if (monospacedOnly) {
            void var10_14;
            ArrayList<Object> l = new ArrayList<Object>();
            FontRenderContext frc = new FontRenderContext(AffineTransform.getTranslateInstance(0.0, 0.0), false, false);
            Object[] arr$ = availableFamilies;
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_14 < len$) {
                Object fam = arr$[var10_14];
                Font f = new Font((String)fam, 0, 10);
                Rectangle2D sbi = f.getStringBounds("i", frc);
                Rectangle2D sbm = f.getStringBounds("m", frc);
                if (sbi.getWidth() == sbm.getWidth()) {
                    l.add(fam);
                }
                ++var10_14;
            }
            availableFamilies = new String[l.size()];
            int i = 0;
            for (String string : l) {
                availableFamilies[i++] = string;
            }
        }
        Font f = new Font("SansSerif", 0, 11);
        this.familyList = new JList<Object>(availableFamilies);
        this.familyList.setFont(f);
        this.familyList.setSelectionMode(0);
        this.familyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = FontSelectionDialog.this.familyList.getSelectedIndex();
                if (i >= 0) {
                    FontSelectionDialog.this.setFamily((String)FontSelectionDialog.this.familyList.getModel().getElementAt(i));
                }
            }
        });
        JPanel familyPanel = new JPanel();
        familyPanel.setLayout(new BorderLayout(0, 4));
        JLabel lbl = new JLabel(this.app.getMessage("FontSelectionDialog.FamilyLabel"), 2);
        lbl.setFont(f);
        familyPanel.add((Component)lbl, "North");
        JScrollPane scp = new JScrollPane(this.familyList);
        familyPanel.add((Component)scp, "Center");
        String[] stringArray = new String[]{this.app.getMessage("FontSelectionDialog.PlainStyle"), this.app.getMessage("FontSelectionDialog.BoldStyle"), this.app.getMessage("FontSelectionDialog.ItalicStyle"), this.app.getMessage("FontSelectionDialog.BoldItalicStyle")};
        this.styleList = new JList<String>(stringArray);
        this.styleList.setSelectionMode(0);
        this.styleList.setFont(f);
        this.styleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = FontSelectionDialog.this.styleList.getSelectedIndex();
                if (i >= 0) {
                    switch (i) {
                        case 0: {
                            FontSelectionDialog.this.setStyle(0);
                            break;
                        }
                        case 1: {
                            FontSelectionDialog.this.setStyle(1);
                            break;
                        }
                        case 2: {
                            FontSelectionDialog.this.setStyle(2);
                            break;
                        }
                        case 3: {
                            FontSelectionDialog.this.setStyle(3);
                        }
                    }
                }
            }
        });
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new BorderLayout(0, 4));
        lbl = new JLabel(this.app.getMessage("FontSelectionDialog.StyleLabel"), 2);
        lbl.setFont(f);
        stylePanel.add((Component)lbl, "North");
        scp = new JScrollPane(this.styleList);
        stylePanel.add((Component)scp, "Center");
        this.fontSize = new DefaultBoundedRangeModel(12, 0, 9, 288);
        this.fontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FontSelectionDialog.this.setSelectedFont();
                if (e.getSource() != FontSelectionDialog.this.sizeField) {
                    FontSelectionDialog.this.sizeField.setText(Integer.toString(FontSelectionDialog.this.fontSize.getValue()));
                }
                if (e.getSource() != FontSelectionDialog.this.sizeList) {
                    for (int i = 0; i < FontSelectionDialog.this.sizeList.getModel().getSize(); ++i) {
                        if (((Integer)FontSelectionDialog.this.sizeList.getModel().getElementAt(i)).intValue() != FontSelectionDialog.this.fontSize.getValue()) continue;
                        FontSelectionDialog.this.sizeList.setSelectedIndex(i);
                        FontSelectionDialog.this.sizeList.ensureIndexIsVisible(i);
                        return;
                    }
                    FontSelectionDialog.this.sizeList.clearSelection();
                }
            }
        });
        JSlider sld = new JSlider(this.fontSize);
        sld.setOrientation(1);
        Integer[] sizes = new Integer[]{9, 10, 11, 12, 13, 14, 18, 24, 36, 48, 64, 72, 96, 144, 288};
        this.sizeList = new JList<Integer>(sizes);
        this.sizeList.setFont(f);
        this.sizeList.setSelectionMode(0);
        this.sizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = FontSelectionDialog.this.sizeList.getSelectedIndex();
                if (i >= 0) {
                    int newSize = (Integer)FontSelectionDialog.this.sizeList.getModel().getElementAt(i);
                    FontSelectionDialog.this.fontSize.setValue(newSize);
                }
            }
        });
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BorderLayout(0, 0));
        lbl = new JLabel(this.app.getMessage("FontSelectionDialog.SizeLabel"), 2);
        lbl.setFont(f);
        sizePanel.add((Component)lbl, "North");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.sizeField = new JTextField("13");
        this.sizeField.setHorizontalAlignment(0);
        this.sizeField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                try {
                    Integer.parseInt(FontSelectionDialog.this.sizeField.getText().trim());
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        });
        p.add((Component)this.sizeField, "North");
        this.sizeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FontSelectionDialog.this.sizeField.getInputVerifier().verify(FontSelectionDialog.this.sizeField)) {
                    FontSelectionDialog.this.fontSize.setValue(Integer.parseInt(FontSelectionDialog.this.sizeField.getText().trim()));
                }
            }
        });
        scp = new JScrollPane(this.sizeList);
        p.add((Component)scp, "West");
        p.add((Component)sld, "East");
        sizePanel.add((Component)p, "Center");
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BorderLayout(4, 4));
        previewPanel.setBackground(Color.WHITE);
        this.previewLabel = new JLabel(this.app.getMessage("FontSelectionDialog.SampleText"), 0);
        this.previewLabel.setPreferredSize(new Dimension(320, 60));
        this.fontNameLabel = new JLabel(this.app.getMessage("FontSelectionDialog.FontNameLabel"), 0);
        this.fontNameLabel.setForeground(Color.GRAY);
        this.fontNameLabel.setFont(f);
        previewPanel.setBorder(BorderFactory.createEtchedBorder());
        previewPanel.add((Component)this.fontNameLabel, "South");
        previewPanel.add((Component)this.previewLabel, "Center");
        p = new JPanel();
        p.setLayout(new BorderLayout(4, 0));
        p.add((Component)familyPanel, "Center");
        JPanel p5 = new JPanel();
        p5.setLayout(new BorderLayout(4, 0));
        p5.add((Component)stylePanel, "Center");
        p5.add((Component)sizePanel, "East");
        p.add((Component)p5, "East");
        JPanel p6 = new JPanel();
        JButton okButton = new JButton(this.app.getMessage("FontSelectionDialog.OkButtonText"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSelectionDialog.this.setVisible(false);
                FontSelectionDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton(this.app.getMessage("FontSelectionDialog.CancelButtonText"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSelectionDialog.this.selectedFont = null;
                FontSelectionDialog.this.setVisible(false);
                FontSelectionDialog.this.dispose();
            }
        });
        p6.add(okButton);
        p6.add(cancelButton);
        p.add((Component)p6, "South");
        p.setPreferredSize(new Dimension(this.previewLabel.getPreferredSize().width, 180));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(4, 4));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        contentPanel.add((Component)previewPanel, "Center");
        contentPanel.add((Component)p, "South");
        this.getContentPane().add(contentPanel);
        if (oldFont == null) {
            oldFont = new Font(monospacedOnly ? "Monospaced" : "SansSerif", 0, 13);
        }
        this.family = oldFont.getFamily();
        for (int i = 0; i < availableFamilies.length; ++i) {
            if (!this.family.equals(availableFamilies[i])) continue;
            this.familyList.setSelectedIndex(i);
            this.familyList.ensureIndexIsVisible(i);
            break;
        }
        this.style = oldFont.getStyle();
        switch (this.style) {
            case 0: {
                this.styleList.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.styleList.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.styleList.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.styleList.setSelectedIndex(3);
            }
        }
        this.fontSize.setValue(oldFont.getSize());
        this.pack();
    }

    private void setFamily(String newFamily) {
        if (!this.family.equals(newFamily)) {
            this.family = newFamily;
            this.setSelectedFont();
        }
    }

    private void setStyle(int newStyle) {
        if (this.style != newStyle) {
            this.style = newStyle;
            this.setSelectedFont();
        }
    }

    private String getStyleAsString() {
        switch (this.style) {
            case 0: {
                return this.app.getMessage("FontSelectionDialog.PlainSampleText");
            }
            case 1: {
                return this.app.getMessage("FontSelectionDialog.BoldSampleText");
            }
            case 2: {
                return this.app.getMessage("FontSelectionDialog.ItalicSampleText");
            }
            case 3: {
                return this.app.getMessage("FontSelectionDialog.BoldItalicSampleText");
            }
        }
        return this.app.getMessage("FontSelectionDialog.UnknownExampleText");
    }

    public static String getFontName(SwingApplication app, Font font) {
        String style = font.getStyle() == 0 ? app.getMessage("FontSelectionDialog.PlainStyle") : (font.getStyle() == 1 ? app.getMessage("FontSelectionDialog.BoldStyle") : (font.getStyle() == 2 ? app.getMessage("FontSelectionDialog.ItalicStyle") : app.getMessage("FontSelectionDialog.BoldItalicStyle")));
        return font.getFamily() + "-" + style + "-" + font.getSize();
    }

    public static String getInternalFontName(Font font) {
        String style = font.getStyle() == 0 ? "plain" : (font.getStyle() == 1 ? "bold" : (font.getStyle() == 2 ? "italic" : "bolditalic"));
        return font.getFamily() + "-" + style + "-" + font.getSize();
    }

    private int getFontSize() {
        return this.fontSize.getValue();
    }

    private void setSelectedFont() {
        this.selectedFont = new Font(this.family, this.style, this.fontSize.getValue());
        this.previewLabel.setFont(this.selectedFont);
        this.fontNameLabel.setText(MessageFormat.format(this.app.getMessage("FontSelectionDialog.FontNameDisplay"), this.selectedFont.getName(), this.getStyleAsString(), this.getFontSize()));
    }

    private Font getSelectedFont() {
        return this.selectedFont;
    }
}

