/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class StringListPreferences {
    protected ArrayList<String> entries;
    private Preferences prefs;
    private String key;

    public StringListPreferences(Preferences prefs, String key) {
        this.prefs = prefs;
        this.key = key;
    }

    public void setEntries(List<String> l) {
        this.entries.clear();
        this.entries.addAll(l);
        this.save();
    }

    public List<String> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public int size() {
        return this.entries.size();
    }

    public String get(int index) {
        return this.entries.get(index);
    }

    public boolean contains(String s) {
        return this.entries.contains(s);
    }

    public int indexOf(String s) {
        return this.entries.indexOf(s);
    }

    public void sort() {
        Collections.sort(this.entries);
        this.save();
    }

    public void add(int index, String s) {
        this.entries.add(index, s);
        this.save();
    }

    public void add(String s) {
        this.entries.add(s);
        this.save();
    }

    public void remove(String s) {
        while (this.entries.remove(s)) {
        }
        this.save();
    }

    public String remove(int index) {
        String s = this.entries.remove(index);
        this.save();
        return s;
    }

    public void clear() {
        this.entries.clear();
        this.save();
    }

    public void save() {
        int n;
        for (n = 0; n < this.entries.size(); ++n) {
            this.prefs.put(this.key + n, this.entries.get(n));
        }
        while (this.prefs.get(this.key + n, null) != null) {
            this.prefs.remove(this.key + n);
            ++n;
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void load(int maxEntries) {
        String s;
        this.entries = new ArrayList();
        for (int n = 0; n < maxEntries && (s = this.prefs.get(this.key + n, null)) != null; ++n) {
            this.entries.add(s);
        }
    }

    public void load() {
        this.load(Integer.MAX_VALUE);
    }
}

