/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class XmlProcessor {
    private XMLStreamReader parser;
    private Stack<String> elementNameStack;
    private Stack<StringBuilder> elementContentStack;
    private final Set<String> ignoredElements = new TreeSet<String>();
    private int ignoreCounter;
    private String fileName;

    public void process(String fileName) throws FileNotFoundException, XMLStreamException {
        this.fileName = fileName;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this.parser = factory.createXMLStreamReader(in, "UTF-8");
        int event = this.parser.getEventType();
        while (event != 8) {
            switch (event) {
                case 7: {
                    this.startDocumentEvent();
                    break;
                }
                case 1: {
                    this.startElementEvent();
                    break;
                }
                case 2: {
                    this.endElementEvent();
                    break;
                }
                case 4: {
                    if (this.ignoreCounter != 0) break;
                    String t = this.parser.getText();
                    this.characters(t);
                    this.elementContentStack.peek().append(t);
                }
            }
            event = this.parser.next();
        }
        this.endDocumentEvent();
    }

    private void startDocumentEvent() throws XMLStreamException {
        this.elementNameStack = new Stack();
        this.elementContentStack = new Stack();
        this.ignoreCounter = 0;
        this.startDocument();
    }

    private void endDocumentEvent() throws XMLStreamException {
        if (!this.elementNameStack.isEmpty()) {
            StringBuilder openElements = new StringBuilder("Missing end tags for");
            String delim = ": ";
            for (String s : this.elementNameStack) {
                openElements.append(delim).append(s);
                delim = ", ";
            }
            throw new XMLStreamException(openElements.toString());
        }
        assert (this.ignoreCounter == 0);
        this.endDocument();
    }

    private void startElementEvent() throws XMLStreamException {
        QName qname = this.parser.getName();
        String name = qname.getPrefix() == null || qname.getPrefix().isEmpty() ? qname.getLocalPart() : qname.getPrefix() + ":" + qname.getLocalPart();
        this.elementNameStack.push(name);
        this.elementContentStack.push(new StringBuilder());
        if (this.ignoredElements.contains(name)) {
            ++this.ignoreCounter;
        }
        if (this.ignoreCounter == 0) {
            this.startElement(name);
        }
    }

    private void endElementEvent() throws XMLStreamException {
        QName qname = this.parser.getName();
        String name = qname.getPrefix() == null || qname.getPrefix().isEmpty() ? qname.getLocalPart() : qname.getPrefix() + ":" + qname.getLocalPart();
        if (this.elementNameStack.isEmpty()) {
            throw new XMLStreamException("Unexpected end element </" + name + "> in line " + this.parser.getLocation().getLineNumber());
        }
        String s = this.elementNameStack.peek();
        if (!s.equals(name)) {
            throw new XMLStreamException("Element <" + s + "> is terminated by </" + name + "> in line " + this.parser.getLocation().getLineNumber());
        }
        if (this.ignoreCounter == 0) {
            this.endElement(name, this.elementContentStack.peek());
        }
        if (this.ignoredElements.contains(name)) {
            assert (this.ignoreCounter > 0);
            --this.ignoreCounter;
        }
        this.elementNameStack.pop();
        this.elementContentStack.pop();
    }

    protected void characters(String text) {
    }

    protected abstract void startElement(String var1) throws XMLStreamException;

    protected abstract void endElement(String var1, StringBuilder var2) throws XMLStreamException;

    protected abstract void startDocument() throws XMLStreamException;

    protected abstract void endDocument() throws XMLStreamException;

    protected String getAttribute(String nsPrefix, String name) throws XMLStreamException {
        return this.parser.getAttributeValue(this.parser.getNamespaceURI(nsPrefix), name);
    }

    protected Set<String> getAttributeNames() {
        LinkedHashSet<String> attrNames = new LinkedHashSet<String>();
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String ns = this.parser.getAttributePrefix(i);
            String localName = this.parser.getAttributeLocalName(i);
            attrNames.add(ns == null || ns.isEmpty() ? localName : ns + ":" + localName);
        }
        return attrNames;
    }

    protected String getAttribute(String name) throws XMLStreamException {
        int p = name.indexOf(":");
        if (p >= 0) {
            if (p > 0) {
                return this.getAttribute(name.substring(0, p - 1), name.substring(p + 1));
            }
            name = name.substring(p + 1);
        }
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            if (this.parser.getAttributeNamespace(i) != null && !"".equals(this.parser.getAttributeNamespace(i)) || !name.equals(this.parser.getAttributeLocalName(i))) continue;
            return this.parser.getAttributeValue(i);
        }
        return null;
    }

    protected void addIgnoredElements(String ... names) {
        for (String name : names) {
            if (name == null || (name = name.trim()).length() <= 0) continue;
            this.ignoredElements.add(name);
        }
    }

    public int getNestingDepth() {
        return this.elementNameStack.size();
    }

    public String getFileName() {
        return this.fileName;
    }

    public Stack<String> getElementNameStack() {
        return this.elementNameStack;
    }

    public XMLStreamReader getParser() {
        return this.parser;
    }
}

