/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.impl.GraphBaseImpl;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.filechooser.FileFilter;

public class GraphIO {
    public static final int TGFILE_VERSION = 2;
    public static final String NULL_LITERAL = "n";
    public static final String TRUE_LITERAL = "t";
    public static final String FALSE_LITERAL = "f";
    public static final String TGRAPH_FILE_EXTENSION = ".tg";
    public static final String TGRAPH_COMPRESSED_FILE_EXTENSION = ".tg.gz";
    private static final int BUFFER_SIZE = 65536;
    private InputStream TGIn;
    private DataOutputStream TGOut;
    private Schema schema;
    private final Map<String, Domain> domains = new TreeMap<String, Domain>();
    private final Map<GraphElementClass<?, ?>, GraphClass> GECsearch = new HashMap();
    private int line;
    private int la;
    private String lookAhead;
    private boolean isUtfString;
    private boolean writeSpace;
    private String gcName;
    private final byte[] buffer = new byte[65536];
    private int bufferPos = 0;
    private int bufferSize;
    private Vertex[] edgeIn;
    private Vertex[] edgeOut;
    private int[] firstIncidence;
    private int[] nextIncidence;
    private int edgeOffset;
    private final Set<EnumDomainData> enumDomainBuffer = new HashSet<EnumDomainData>();
    private List<RecordDomainData> recordDomainBuffer = new ArrayList<RecordDomainData>();
    private GraphClassData graphClass = null;
    private final Map<String, List<GraphElementClassData>> vertexClassBuffer = new TreeMap<String, List<GraphElementClassData>>();
    private final Map<String, List<GraphElementClassData>> edgeClassBuffer = new TreeMap<String, List<GraphElementClassData>>();
    private final Map<String, List<String>> commentData = new HashMap<String, List<String>>();
    private int putBackChar = -1;
    private String currentPackageName;
    private ByteArrayOutputStream BAOut;
    private final HashMap<String, String> stringPool = new HashMap();
    private GraphFactory graphFactory;

    private GraphIO() {
    }

    public static Schema loadSchemaFromFile(String filename) throws GraphIOException {
        Schema schema;
        FilterInputStream in = null;
        try {
            in = filename.toLowerCase().endsWith(".gz") ? new GZIPInputStream((InputStream)new FileInputStream(filename), 65536) : new BufferedInputStream(new FileInputStream(filename), 65536);
            schema = GraphIO.loadSchemaFromStream(in);
        }
        catch (IOException ex) {
            try {
                throw new GraphIOException("Exception while loading schema from " + filename, ex);
            }
            catch (Throwable throwable) {
                GraphIO.close(in);
                throw throwable;
            }
        }
        GraphIO.close(in);
        return schema;
    }

    public static Schema loadSchemaFromStream(InputStream in) throws GraphIOException {
        try {
            GraphIO io = new GraphIO();
            io.TGIn = in;
            io.tgfile();
            io.schema.finish();
            return io.schema;
        }
        catch (Exception e) {
            throw new GraphIOException("Exception while loading schema.", e);
        }
    }

    public static void saveSchemaToFile(Schema schema, String filename) throws GraphIOException {
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(filename))));
            GraphIO.saveSchemaToStream(schema, out);
        }
        catch (IOException ex) {
            try {
                throw new GraphIOException("Exception while saving schema to " + filename, ex);
            }
            catch (Throwable throwable) {
                GraphIO.close(out);
                throw throwable;
            }
        }
        GraphIO.close(out);
    }

    public static void saveSchemaToStream(Schema schema, DataOutputStream out) throws GraphIOException {
        GraphIO io = new GraphIO();
        io.TGOut = out;
        try {
            io.saveHeader();
            io.saveSchema(schema);
            out.flush();
        }
        catch (IOException e) {
            throw new GraphException("Exception while saving schema", e);
        }
    }

    private void saveSchema(Schema s) throws IOException {
        this.schema = s;
        this.write("Schema");
        this.space();
        this.writeIdentifier(this.schema.getQualifiedName());
        this.write(";\n");
        GraphClass gc = this.schema.getGraphClass();
        this.write("GraphClass");
        this.space();
        this.writeIdentifier(gc.getSimpleName());
        this.writeAttributes(null, gc);
        this.writeConstraints(gc);
        this.write(";\n");
        this.writeComments(gc, gc.getSimpleName());
        LinkedList<Package> worklist = new LinkedList<Package>();
        worklist.offer(s.getDefaultPackage());
        while (!worklist.isEmpty()) {
            Package pkg = (Package)worklist.poll();
            worklist.addAll(pkg.getSubPackages());
            if (!pkg.isDefaultPackage()) {
                this.write("Package");
                this.space();
                this.writeIdentifier(pkg.getQualifiedName());
                this.write(";\n");
            }
            for (Domain dom : pkg.getDomains()) {
                if (dom instanceof EnumDomain) {
                    EnumDomain ed = (EnumDomain)dom;
                    this.write("EnumDomain");
                    this.space();
                    this.writeIdentifier(ed.getSimpleName());
                    this.write(" (");
                    Iterator eit = ed.getConsts().iterator();
                    while (eit.hasNext()) {
                        this.noSpace();
                        this.writeIdentifier((String)eit.next());
                        if (!eit.hasNext()) continue;
                        this.write(", ");
                    }
                    this.write(");\n");
                    this.writeComments(ed, ed.getSimpleName());
                    continue;
                }
                if (!(dom instanceof RecordDomain)) continue;
                RecordDomain rd = (RecordDomain)dom;
                this.write("RecordDomain");
                this.space();
                this.writeIdentifier(rd.getSimpleName());
                this.write(" (");
                String delim = "";
                for (RecordDomain.RecordComponent rdc : rd.getComponents()) {
                    this.write(delim);
                    this.noSpace();
                    this.writeIdentifier(rdc.getName());
                    this.write(": ");
                    this.write(rdc.getDomain().getTGTypeName(pkg));
                    delim = ", ";
                }
                this.write(");\n");
                this.writeComments(rd, rd.getSimpleName());
            }
            for (VertexClass vc : pkg.getVertexClasses()) {
                if (vc.isAbstract()) {
                    this.write("abstract ");
                }
                this.write("VertexClass");
                this.space();
                this.writeIdentifier(vc.getSimpleName());
                this.writeHierarchy(pkg, vc);
                this.writeAttributes(pkg, vc);
                this.writeConstraints(vc);
                this.write(";\n");
                this.writeComments(vc, vc.getSimpleName());
            }
            for (EdgeClass ec : pkg.getEdgeClasses()) {
                if (ec.isDefaultGraphElementClass()) continue;
                if (ec.isAbstract()) {
                    this.write("abstract ");
                }
                this.write("EdgeClass");
                this.space();
                this.writeIdentifier(ec.getSimpleName());
                this.writeHierarchy(pkg, ec);
                this.write(" from");
                this.space();
                this.writeIdentifier(ec.getFrom().getVertexClass().getQualifiedName(pkg));
                this.write(" (");
                this.write(ec.getFrom().getMin() + ",");
                if (ec.getFrom().getMax() == Integer.MAX_VALUE) {
                    this.write("*)");
                } else {
                    this.write(ec.getFrom().getMax() + ")");
                }
                if (!ec.getFrom().getRolename().equals("")) {
                    this.write(" role");
                    this.space();
                    this.writeIdentifier(ec.getFrom().getRolename());
                }
                switch (ec.getFrom().getAggregationKind()) {
                    case NONE: {
                        break;
                    }
                    case SHARED: {
                        this.write(" aggregation shared");
                        break;
                    }
                    case COMPOSITE: {
                        this.write(" aggregation composite");
                    }
                }
                this.write(" to");
                this.space();
                this.writeIdentifier(ec.getTo().getVertexClass().getQualifiedName(pkg));
                this.write(" (");
                this.write(ec.getTo().getMin() + ",");
                if (ec.getTo().getMax() == Integer.MAX_VALUE) {
                    this.write("*)");
                } else {
                    this.write(ec.getTo().getMax() + ")");
                }
                if (!ec.getTo().getRolename().equals("")) {
                    this.write(" role");
                    this.space();
                    this.writeIdentifier(ec.getTo().getRolename());
                }
                switch (ec.getTo().getAggregationKind()) {
                    case NONE: {
                        break;
                    }
                    case SHARED: {
                        this.write(" aggregation shared");
                        break;
                    }
                    case COMPOSITE: {
                        this.write(" aggregation composite");
                    }
                }
                this.writeAttributes(pkg, ec);
                this.writeConstraints(ec);
                this.write(";\n");
                this.writeComments(ec, ec.getSimpleName());
            }
            this.writeComments(pkg, "." + pkg.getQualifiedName());
        }
    }

    private void writeComments(NamedElement elem, String name) throws IOException {
        if (!elem.getComments().isEmpty()) {
            this.write("Comment");
            this.space();
            this.writeIdentifier(name);
            this.space();
            for (String c : elem.getComments()) {
                this.writeUtfString(c);
            }
            this.write(";\n");
        }
    }

    private void writeConstraints(AttributedElementClass<?, ?> aec) throws IOException {
        for (Constraint c : aec.getConstraints()) {
            this.writeSpace();
            this.write("[");
            this.noSpace();
            this.writeUtfString(c.getMessage());
            this.writeUtfString(c.getPredicate());
            if (c.getOffendingElementsQuery() != null) {
                this.writeUtfString(c.getOffendingElementsQuery());
            }
            this.noSpace();
            this.write("]");
            this.space();
        }
    }

    public static void saveGraphToFile(Graph graph, String filename, ProgressFunction pf) throws GraphIOException {
        DataOutputStream out = null;
        try {
            out = filename.toLowerCase().endsWith(".gz") ? new DataOutputStream(new GZIPOutputStream((OutputStream)new FileOutputStream(filename), 65536)) : new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 65536));
            GraphIO.saveGraphToStream(graph, out, pf);
        }
        catch (IOException ex) {
            try {
                throw new GraphIOException("Exception while saving graph to " + filename, ex);
            }
            catch (Throwable throwable) {
                GraphIO.close(out);
                throw throwable;
            }
        }
        GraphIO.close(out);
    }

    public static void saveGraphToFile(AbstractBooleanGraphMarker subGraph, String filename, ProgressFunction pf) throws GraphIOException {
        DataOutputStream out = null;
        try {
            out = filename.toLowerCase().endsWith(".gz") ? new DataOutputStream(new GZIPOutputStream((OutputStream)new FileOutputStream(filename), 65536)) : new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 65536));
            GraphIO.saveGraphToStream(subGraph, out, pf);
        }
        catch (IOException e) {
            try {
                throw new GraphIOException("Exception while saving graph to " + filename, e);
            }
            catch (Throwable throwable) {
                GraphIO.close(out);
                throw throwable;
            }
        }
        GraphIO.close(out);
    }

    public static void saveGraphToStream(Graph graph, DataOutputStream out, ProgressFunction pf) throws GraphIOException {
        try {
            if (GraphIO.hasTemporaryElements(graph)) {
                throw new GraphIOException("Saving graph " + graph + " is not possible. " + "It contains temporary graph elements.");
            }
            GraphIO io = new GraphIO();
            io.TGOut = out;
            io.saveGraph((InternalGraph)graph, pf, null);
            out.flush();
        }
        catch (IOException e) {
            throw new GraphIOException("Exception while saving graph", e);
        }
    }

    public static void saveGraphToStream(AbstractBooleanGraphMarker subGraph, DataOutputStream out, ProgressFunction pf) throws GraphIOException {
        try {
            if (GraphIO.hasTemporaryElements(subGraph, subGraph.getGraph())) {
                throw new GraphIOException("Saving subgraph " + subGraph + " of " + subGraph.getGraph() + " is not possible. " + "It contains temporary graph elements.");
            }
            GraphIO io = new GraphIO();
            io.TGOut = out;
            io.saveGraph((InternalGraph)subGraph.getGraph(), pf, subGraph);
            out.flush();
        }
        catch (IOException e) {
            throw new GraphIOException("Exception while saving graph", e);
        }
    }

    private static boolean hasTemporaryElements(Graph g) {
        if (g.vertices(g.getGraphClass().getTemporaryVertexClass()).iterator().hasNext()) {
            return true;
        }
        return g.edges(g.getGraphClass().getTemporaryEdgeClass()).iterator().hasNext();
    }

    private static boolean hasTemporaryElements(AbstractBooleanGraphMarker marker, Graph g) {
        for (Vertex v : g.vertices(g.getGraphClass().getTemporaryVertexClass())) {
            if (!marker.isMarked(v)) continue;
            return true;
        }
        for (Edge e : g.edges(g.getGraphClass().getTemporaryEdgeClass())) {
            if (!marker.isMarked(e)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGraph(InternalGraph graph, ProgressFunction pf, AbstractBooleanGraphMarker subGraph) throws IOException, GraphIOException {
        TraversalContext tc = graph.setTraversalContext(null);
        try {
            this.saveHeader();
            this.schema = graph.getSchema();
            this.saveSchema(this.schema);
            long graphElements = 0L;
            long currentCount = 0L;
            long interval = 1L;
            if (pf != null) {
                if (subGraph != null) {
                    pf.init(subGraph.size());
                } else {
                    pf.init(graph.getVCount() + graph.getECount());
                }
                interval = pf.getUpdateInterval();
            }
            this.space();
            this.write("Graph " + GraphIO.toUtfString(graph.getId()) + " " + graph.getGraphVersion());
            this.writeIdentifier(graph.getAttributedElementClass().getQualifiedName());
            int vCount = graph.getVCount();
            int eCount = graph.getECount();
            if (subGraph != null) {
                vCount = 0;
                eCount = 0;
                for (AttributedElement ae : subGraph.getMarkedElements()) {
                    if (ae instanceof Vertex) {
                        ++vCount;
                        continue;
                    }
                    if (!(ae instanceof Edge)) continue;
                    ++eCount;
                }
            }
            this.write(" (" + graph.getMaxVCount() + " " + graph.getMaxECount() + " " + vCount + " " + eCount + ")");
            this.space();
            graph.writeAttributeValues(this);
            this.write(";\n");
            Package oldPackage = null;
            Vertex nextV = graph.getFirstVertex();
            while (nextV != null) {
                if (subGraph != null && !subGraph.isMarked(nextV)) {
                    nextV = nextV.getNextVertex();
                    continue;
                }
                long vId = nextV.getId();
                VertexClass aec = nextV.getAttributedElementClass();
                Package currentPackage = aec.getPackage();
                if (currentPackage != oldPackage) {
                    this.write("Package");
                    this.space();
                    this.writeIdentifier(currentPackage.getQualifiedName());
                    this.write(";\n");
                    oldPackage = currentPackage;
                }
                this.write(Long.toString(vId));
                this.space();
                this.writeIdentifier(aec.getSimpleName());
                Edge nextI = nextV.getFirstIncidence();
                this.write(" <");
                this.noSpace();
                while (nextI != null) {
                    if (subGraph != null && !subGraph.isMarked(nextI)) {
                        nextI = nextI.getNextIncidence();
                        continue;
                    }
                    this.writeLong(nextI.getId());
                    nextI = nextI.getNextIncidence();
                }
                this.write(">");
                this.space();
                nextV.writeAttributeValues(this);
                this.write(";\n");
                nextV = nextV.getNextVertex();
                if (pf == null) continue;
                ++graphElements;
                if (++currentCount != interval) continue;
                pf.progress(graphElements);
                currentCount = 0L;
            }
            Edge nextE = graph.getFirstEdge();
            while (nextE != null) {
                if (subGraph != null && !subGraph.isMarked(nextE)) {
                    nextE = nextE.getNextEdge();
                    continue;
                }
                long eId = nextE.getId();
                EdgeClass aec = nextE.getAttributedElementClass();
                Package currentPackage = aec.getPackage();
                if (currentPackage != oldPackage) {
                    this.write("Package");
                    this.space();
                    this.writeIdentifier(currentPackage.getQualifiedName());
                    this.write(";\n");
                    oldPackage = currentPackage;
                }
                this.write(Long.toString(eId));
                this.space();
                this.writeIdentifier(aec.getSimpleName());
                this.space();
                nextE.writeAttributeValues(this);
                this.write(";\n");
                nextE = nextE.getNextEdge();
                if (pf == null) continue;
                ++graphElements;
                if (++currentCount != interval) continue;
                pf.progress(graphElements);
                currentCount = 0L;
            }
            this.TGOut.flush();
            if (pf != null) {
                pf.finished();
            }
        }
        finally {
            graph.setTraversalContext(tc);
        }
    }

    private void saveHeader() throws IOException {
        this.write(JGraLab.getVersionInfo(true));
        this.write("TGraph 2;\n");
    }

    private void writeHierarchy(Package pkg, GraphElementClass<?, ?> aec) throws IOException {
        String delim = ":";
        for (GraphElementClass superClass : aec.getDirectSuperClasses()) {
            this.write(delim);
            this.space();
            this.writeIdentifier(superClass.getQualifiedName(pkg));
            delim = ",";
        }
    }

    private void writeAttributes(Package pkg, AttributedElementClass<?, ?> aec) throws IOException {
        List<Attribute> attributes = aec.getOwnAttributeList();
        if (attributes.isEmpty()) {
            return;
        }
        String delim = " {";
        for (Attribute a : attributes) {
            this.write(delim);
            delim = ",";
            this.space();
            this.writeIdentifier(a.getName());
            this.write(": ");
            String domain = a.getDomain().getTGTypeName(pkg);
            this.write(domain);
            if (a.getDefaultValueAsString() == null || a.getDefaultValueAsString().equals(NULL_LITERAL)) continue;
            this.write(" = ");
            this.writeUtfString(a.getDefaultValueAsString());
        }
        this.write(" }");
    }

    public final void write(String s) throws IOException {
        this.TGOut.writeBytes(s);
    }

    public final void noSpace() {
        this.writeSpace = false;
    }

    public final void space() {
        this.writeSpace = true;
    }

    public final void writeSpace() throws IOException {
        if (this.writeSpace) {
            this.TGOut.writeBytes(" ");
        }
        this.writeSpace = true;
    }

    public final void writeBoolean(boolean b) throws IOException {
        this.writeSpace();
        this.TGOut.writeBytes(b ? TRUE_LITERAL : FALSE_LITERAL);
    }

    public final void writeInteger(int i) throws IOException {
        this.writeSpace();
        this.TGOut.writeBytes(Integer.toString(i));
    }

    public final void writeLong(long l) throws IOException {
        this.writeSpace();
        this.TGOut.writeBytes(Long.toString(l));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeSpace();
        this.TGOut.writeBytes(Double.toString(d));
    }

    public final void writeUtfString(String s) throws IOException {
        this.writeSpace();
        this.TGOut.writeBytes(s == null ? NULL_LITERAL : GraphIO.toUtfString(s));
    }

    public final void writeIdentifier(String s) throws IOException {
        this.writeSpace();
        this.TGOut.writeBytes(s);
    }

    public static GraphIO createStringReader(String input, Schema schema) throws GraphIOException {
        GraphIO io = new GraphIO();
        io.TGIn = new ByteArrayInputStream(input.getBytes(Charset.forName("US-ASCII")));
        io.line = 1;
        io.schema = schema;
        io.la = io.read();
        io.match();
        return io;
    }

    public static GraphIO createStringWriter(Schema schema) {
        GraphIO io = new GraphIO();
        io.BAOut = new ByteArrayOutputStream();
        io.TGOut = new DataOutputStream(io.BAOut);
        io.schema = schema;
        return io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringWriterResult() throws GraphIOException, IOException {
        if (this.BAOut == null) {
            throw new GraphIOException("GraphIO did not write to a String.");
        }
        try {
            String string;
            try {
                String result;
                this.TGOut.flush();
                this.BAOut.flush();
                string = result = this.BAOut.toString("US-ASCII");
            }
            catch (Throwable throwable) {
                GraphIO.close(this.TGOut);
                throw throwable;
            }
            GraphIO.close(this.TGOut);
            return string;
        }
        finally {
            GraphIO.close(this.BAOut);
        }
    }

    public static Graph loadGraphFromFile(String filename, ProgressFunction pf) throws GraphIOException {
        return GraphIO.loadGraphFromFile(filename, ImplementationType.STANDARD, pf);
    }

    /*
     * Loose catch block
     */
    public static Graph loadGraphFromFile(String filename, ImplementationType implementationType, ProgressFunction pf) throws GraphIOException {
        if (implementationType == null) {
            throw new IllegalArgumentException("ImplementationType must be != null");
        }
        FileInputStream fileStream = null;
        fileStream = new FileInputStream(filename);
        FilterInputStream inputStream = null;
        inputStream = filename.toLowerCase().endsWith(".gz") ? new GZIPInputStream((InputStream)fileStream, 65536) : new BufferedInputStream(fileStream, 65536);
        Object g = GraphIO.loadGraphFromStream(inputStream, null, null, implementationType, pf);
        GraphIO.close(inputStream);
        GraphIO.close(fileStream);
        return g;
        {
            catch (IOException ex) {
                try {
                    try {
                        try {
                            throw new GraphIOException("Exception while loading graph from file " + filename, ex);
                        }
                        catch (Throwable throwable) {
                            GraphIO.close(inputStream);
                            throw throwable;
                        }
                    }
                    catch (IOException ex2) {
                        throw new GraphIOException("Exception while loading graph from file " + filename, ex2);
                    }
                }
                catch (Throwable throwable) {
                    GraphIO.close(fileStream);
                    throw throwable;
                }
            }
        }
    }

    public static <G extends Graph> G loadGraphFromFile(String filename, Schema schema, ImplementationType implementationType, ProgressFunction pf) throws GraphIOException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must be != null");
        }
        if (implementationType == null) {
            throw new IllegalArgumentException("ImplementationType must be != null");
        }
        GraphFactory factory = schema.createDefaultGraphFactory(implementationType);
        return GraphIO.loadGraphFromFile(filename, factory, pf);
    }

    /*
     * Loose catch block
     */
    public static <G extends Graph> G loadGraphFromFile(String filename, GraphFactory factory, ProgressFunction pf) throws GraphIOException {
        if (factory == null) {
            throw new IllegalArgumentException("GraphFactory must be != null");
        }
        FileInputStream fileStream = null;
        fileStream = new FileInputStream(filename);
        FilterInputStream inputStream = null;
        inputStream = filename.toLowerCase().endsWith(".gz") ? new GZIPInputStream((InputStream)fileStream, 65536) : new BufferedInputStream(fileStream, 65536);
        G g = GraphIO.loadGraphFromStream(inputStream, factory.getSchema(), factory, factory.getImplementationType(), pf);
        GraphIO.close(inputStream);
        GraphIO.close(fileStream);
        return g;
        {
            catch (IOException ex) {
                try {
                    try {
                        try {
                            throw new GraphIOException("Exception while loading graph from file " + filename, ex);
                        }
                        catch (Throwable throwable) {
                            GraphIO.close(inputStream);
                            throw throwable;
                        }
                    }
                    catch (IOException ex2) {
                        throw new GraphIOException("Exception while loading graph from file " + filename, ex2);
                    }
                }
                catch (Throwable throwable) {
                    GraphIO.close(fileStream);
                    throw throwable;
                }
            }
        }
    }

    private static void close(Closeable stream) throws GraphIOException {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            throw new GraphIOException("Exception while closing stream.", ex);
        }
    }

    public static <G extends Graph> G loadGraphFromStream(InputStream in, Schema schema, GraphFactory graphFactory, ImplementationType implementationType, ProgressFunction pf) throws GraphIOException {
        try {
            GraphIO io = new GraphIO();
            io.TGIn = in;
            io.schema = schema;
            io.tgfile();
            if (implementationType != ImplementationType.GENERIC) {
                String schemaQName = io.schema.getQualifiedName();
                Class<?> schemaClass = null;
                try {
                    schemaClass = Class.forName(schemaQName, true, SchemaClassManager.instance(schemaQName));
                }
                catch (ClassNotFoundException e) {
                    io.schema.finish();
                    io.schema.compile(CodeGeneratorConfiguration.MINIMAL);
                    try {
                        schemaClass = Class.forName(schemaQName, true, SchemaClassManager.instance(schemaQName));
                    }
                    catch (ClassNotFoundException e1) {
                        throw new GraphIOException("Unable to load a graph which belongs to the schema because the Java-classes for this schema can not be created.", e1);
                    }
                }
                Method instanceMethod = schemaClass.getMethod("instance", null);
                io.schema = (Schema)instanceMethod.invoke(null, new Object[0]);
            }
            io.schema.finish();
            if (graphFactory == null) {
                graphFactory = io.schema.createDefaultGraphFactory(implementationType);
            }
            if (graphFactory.getSchema() != io.schema) {
                throw new GraphIOException("Incompatible in graph factory: Expected '" + io.schema.getQualifiedName() + "', found '" + graphFactory.getSchema().getQualifiedName() + "'.");
            }
            if (implementationType != null && graphFactory.getImplementationType() != implementationType) {
                throw new GraphIOException("Graph factory has wrong implementation type: Expected '" + (Object)((Object)implementationType) + "', found '" + (Object)((Object)graphFactory.getImplementationType()) + "'.");
            }
            io.graphFactory = graphFactory;
            GraphBaseImpl loadedGraph = io.graph(pf);
            return (G)loadedGraph;
        }
        catch (GraphIOException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new GraphIOException("Exception while loading graph.", e2);
        }
    }

    private void tgfile() throws GraphIOException, SchemaException, IOException {
        this.line = 1;
        this.la = this.read();
        this.match();
        this.header();
        this.schema();
        if (this.lookAhead.equals("") || this.lookAhead.equals("Graph")) {
            return;
        }
        throw new GraphIOException("Symbol '" + this.lookAhead + "' not recognized in line " + this.line, null);
    }

    private void header() throws GraphIOException {
        this.match("TGraph");
        int version = this.matchInteger();
        if (version != 2) {
            throw new GraphIOException("Can't read TGFile version " + version + ". Expected version " + 2);
        }
        this.match(";");
    }

    private void schema() throws GraphIOException, SchemaException {
        this.currentPackageName = "";
        this.match("Schema");
        String[] qn = this.matchQualifiedName(true);
        if (qn[0].equals("")) {
            throw new GraphIOException("Invalid schema name '" + this.lookAhead + "', package prefix must not be empty in line " + this.line);
        }
        this.match(";");
        if (this.schema != null) {
            if (this.schema.getQualifiedName().equals(qn[0] + "." + qn[1])) {
                String prev = "";
                while (!(this.lookAhead.length() <= 0 || prev.equals(";") && this.lookAhead.equals("Graph"))) {
                    prev = this.lookAhead;
                    this.match();
                }
                return;
            }
            throw new GraphIOException("Trying to load a graph with wrong schema. Expected: " + this.schema.getQualifiedName() + ", but found " + qn[0] + "." + qn[1]);
        }
        this.schema = new SchemaImpl(qn[1], qn[0]);
        this.parseSchema();
        if (!this.lookAhead.equals("") && !this.lookAhead.equals("Graph")) {
            throw new GraphIOException("Symbol '" + this.lookAhead + "' not recognized in line " + this.line, null);
        }
        this.checkFromToVertexClasses();
        this.sortRecordDomains();
        this.sortVertexClasses();
        this.sortEdgeClasses();
        this.domDef();
        this.completeGraphClass();
        this.buildHierarchy();
        this.processComments();
    }

    private void processComments() throws GraphIOException {
        for (Map.Entry<String, List<String>> e : this.commentData.entrySet()) {
            if (!this.schema.knows(e.getKey())) {
                throw new GraphIOException("Annotated element '" + e.getKey() + "' not found in schema " + this.schema.getQualifiedName());
            }
            NamedElement el = this.schema.getNamedElement(e.getKey());
            if (el instanceof Domain && !(el instanceof EnumDomain) && !(el instanceof RecordDomain)) {
                throw new GraphIOException("Default domains can not have comments. Offending domain is '" + e.getKey() + "'");
            }
            for (String comment : e.getValue()) {
                el.addComment(comment);
            }
        }
    }

    private Map<String, Domain> domDef() throws GraphIOException, SchemaException {
        this.enumDomains();
        this.recordDomains();
        return this.domains;
    }

    private void parseEnumDomain() throws GraphIOException {
        this.match("EnumDomain");
        String[] qn = this.matchQualifiedName(true);
        this.enumDomainBuffer.add(new EnumDomainData(qn[0], qn[1], this.parseEnumConstants()));
        this.match(";");
    }

    private void enumDomains() {
        for (EnumDomainData enumDomainData : this.enumDomainBuffer) {
            String qName = this.toQNameString(enumDomainData.packageName, enumDomainData.simpleName);
            EnumDomain domain = this.schema.createEnumDomain(qName, enumDomainData.enumConstants);
            this.domains.put(qName, domain);
        }
    }

    private void parseRecordDomain() throws GraphIOException {
        this.match("RecordDomain");
        String[] qn = this.matchQualifiedName(true);
        this.recordDomainBuffer.add(new RecordDomainData(qn[0], qn[1], this.parseRecordComponents()));
        this.match(";");
    }

    private void recordDomains() throws GraphIOException, SchemaException {
        for (RecordDomainData recordDomainData : this.recordDomainBuffer) {
            String qName = this.toQNameString(recordDomainData.packageName, recordDomainData.simpleName);
            RecordDomain domain = this.schema.createRecordDomain(qName, this.getComponents(recordDomainData.components));
            this.domains.put(qName, domain);
        }
    }

    private List<RecordDomain.RecordComponent> getComponents(List<ComponentData> componentsData) throws GraphIOException {
        ArrayList<RecordDomain.RecordComponent> result = new ArrayList<RecordDomain.RecordComponent>(componentsData.size());
        for (ComponentData ad : componentsData) {
            RecordDomain.RecordComponent c = new RecordDomain.RecordComponent(ad.name, this.attrDomain(ad.domainDescription));
            result.add(c);
        }
        return result;
    }

    private void parseSchema() throws GraphIOException, SchemaException {
        while (this.lookAhead.equals("Comment")) {
            this.parseComment();
        }
        String currentGraphClassName = this.parseGraphClass();
        while (this.lookAhead.equals("Package") || this.lookAhead.equals("RecordDomain") || this.lookAhead.equals("EnumDomain") || this.lookAhead.equals("abstract") || this.lookAhead.equals("VertexClass") || this.lookAhead.equals("EdgeClass") || this.lookAhead.equals("Comment")) {
            if (this.lookAhead.equals("Package")) {
                this.parsePackage();
                continue;
            }
            if (this.lookAhead.equals("RecordDomain")) {
                this.parseRecordDomain();
                continue;
            }
            if (this.lookAhead.equals("EnumDomain")) {
                this.parseEnumDomain();
                continue;
            }
            if (this.lookAhead.equals("Comment")) {
                this.parseComment();
                continue;
            }
            this.parseGraphElementClass(currentGraphClassName);
        }
    }

    private void parseComment() throws GraphIOException {
        this.match("Comment");
        String qName = this.toQNameString(this.matchQualifiedName());
        ArrayList<String> comments = new ArrayList<String>();
        comments.add(this.matchUtfString());
        while (!this.lookAhead.equals(";")) {
            comments.add(this.matchUtfString());
        }
        this.match(";");
        if (this.commentData.containsKey(qName)) {
            this.commentData.get(qName).addAll(comments);
        } else {
            this.commentData.put(qName, comments);
        }
    }

    private void parsePackage() throws GraphIOException {
        this.match("Package");
        this.currentPackageName = "";
        if (this.lookAhead.equals(";")) {
            this.currentPackageName = "";
        } else {
            String[] qn = this.matchQualifiedName(false);
            String qualifiedName = this.toQNameString(qn);
            if (!GraphIO.isValidPackageName(qn[1])) {
                throw new GraphIOException("Invalid package name '" + qualifiedName + "' in line " + this.line);
            }
            this.currentPackageName = qualifiedName;
        }
        this.match(";");
    }

    private void completeGraphClass() throws GraphIOException, SchemaException {
        GraphClass currentGraphClass = this.createGraphClass(this.graphClass);
        for (GraphElementClassData currentGraphElementClassData : this.vertexClassBuffer.get(this.graphClass.name)) {
            this.createVertexClass(currentGraphElementClassData, currentGraphClass);
        }
        for (GraphElementClassData currentGraphElementClassData : this.edgeClassBuffer.get(this.graphClass.name)) {
            this.createEdgeClass(currentGraphElementClassData, currentGraphClass);
        }
    }

    private String parseGraphClass() throws GraphIOException, SchemaException {
        this.match("GraphClass");
        this.graphClass = new GraphClassData();
        this.graphClass.name = this.matchSimpleName(true);
        if (this.lookAhead.equals("{")) {
            this.graphClass.attributes = this.parseAttributes();
        }
        if (this.lookAhead.equals("[")) {
            this.graphClass.constraints = this.parseConstraints();
        }
        this.match(";");
        this.vertexClassBuffer.put(this.graphClass.name, new ArrayList());
        this.edgeClassBuffer.put(this.graphClass.name, new ArrayList());
        return this.graphClass.name;
    }

    private GraphClass createGraphClass(GraphClassData gcData) throws GraphIOException, SchemaException {
        GraphClass gc = this.schema.createGraphClass(gcData.name);
        gc.setAbstract(gcData.isAbstract);
        this.addAttributes(gcData.attributes, gc);
        for (Constraint constraint : gcData.constraints) {
            gc.addConstraint(constraint);
        }
        return gc;
    }

    private List<String> parseHierarchy() throws GraphIOException {
        LinkedList<String> hierarchy = new LinkedList<String>();
        this.match(":");
        String[] qn = this.matchQualifiedName(true);
        hierarchy.add(this.toQNameString(qn));
        while (this.lookAhead.equals(",")) {
            this.match();
            qn = this.matchQualifiedName(true);
            hierarchy.add(this.toQNameString(qn));
        }
        return hierarchy;
    }

    private List<AttributeData> parseAttributes() throws GraphIOException {
        ArrayList<AttributeData> attributesData = new ArrayList<AttributeData>();
        TreeSet<String> names = new TreeSet<String>();
        this.match("{");
        AttributeData ad = new AttributeData();
        ad.name = this.matchSimpleName(false);
        this.match(":");
        ad.domainDescription = this.parseAttrDomain();
        if (this.lookAhead.equals("=")) {
            this.match();
            ad.defaultValue = this.matchUtfString();
        }
        attributesData.add(ad);
        names.add(ad.name);
        while (this.lookAhead.equals(",")) {
            this.match(",");
            ad = new AttributeData();
            ad.name = this.matchSimpleName(false);
            this.match(":");
            ad.domainDescription = this.parseAttrDomain();
            if (this.lookAhead.equals("=")) {
                this.match();
                ad.defaultValue = this.matchUtfString();
            }
            if (names.contains(ad.name)) {
                throw new GraphIOException("Duplicate attribute name '" + ad.name + "' in line " + this.line);
            }
            attributesData.add(ad);
            names.add(ad.name);
        }
        this.match("}");
        return attributesData;
    }

    private void addAttributes(List<AttributeData> attributesData, AttributedElementClass<?, ?> aec) throws GraphIOException {
        for (AttributeData ad : attributesData) {
            aec.createAttribute(ad.name, this.attrDomain(ad.domainDescription), ad.defaultValue);
        }
    }

    private List<String> parseAttrDomain() throws GraphIOException {
        ArrayList<String> result = new ArrayList<String>();
        this.parseAttrDomain(result);
        return result;
    }

    private void parseAttrDomain(List<String> attrDomain) throws GraphIOException {
        if (this.lookAhead.matches("[.]?List")) {
            this.match();
            this.match("<");
            attrDomain.add("List<");
            this.parseAttrDomain(attrDomain);
            this.match(">");
        } else if (this.lookAhead.matches("[.]?Set")) {
            this.match();
            this.match("<");
            attrDomain.add("Set<");
            this.parseAttrDomain(attrDomain);
            this.match(">");
        } else if (this.lookAhead.matches("[.]?Map")) {
            this.match();
            this.match("<");
            attrDomain.add("Map<");
            this.parseAttrDomain(attrDomain);
            this.match(",");
            this.parseAttrDomain(attrDomain);
            this.match(">");
        } else if (this.isBasicDomainName(this.lookAhead)) {
            attrDomain.add(this.lookAhead);
            this.match();
        } else {
            String[] qn = this.matchQualifiedName(true);
            attrDomain.add(this.toQNameString(qn));
        }
    }

    private boolean isBasicDomainName(String s) {
        return BasicDomainImpl.isBasicDomain(s.startsWith(".") ? s.substring(1) : s);
    }

    private Domain attrDomain(List<String> domainNames) throws GraphIOException {
        Iterator<String> it = domainNames.iterator();
        if (it.hasNext()) {
            String domainName = it.next();
            it.remove();
            if (domainName.equals("List<")) {
                try {
                    return this.schema.createListDomain(this.attrDomain(domainNames));
                }
                catch (SchemaException e) {
                    throw new GraphIOException("Can't create list domain in line " + this.line, e);
                }
            }
            if (domainName.equals("Set<")) {
                try {
                    return this.schema.createSetDomain(this.attrDomain(domainNames));
                }
                catch (SchemaException e) {
                    throw new GraphIOException("Can't create set domain in line " + this.line, e);
                }
            }
            if (domainName.equals("Map<")) {
                try {
                    Domain keyDomain = this.attrDomain(domainNames);
                    Domain valueDomain = this.attrDomain(domainNames);
                    if (keyDomain == null) {
                        throw new GraphIOException("Can't create map domain, because no key domain was given in line " + this.line);
                    }
                    MapDomain result = this.schema.createMapDomain(keyDomain, valueDomain);
                    return result;
                }
                catch (SchemaException e) {
                    throw new GraphIOException("Can't create map domain in line " + this.line, e);
                }
            }
            Domain result = this.schema.getDomain(domainName);
            if (result == null) {
                throw new GraphIOException("Undefined domain '" + domainName + "' in line " + this.line);
            }
            return result;
        }
        throw new GraphIOException("Couldn't create domain for '" + domainNames + "' in line " + this.line);
    }

    public final String matchEnumConstant() throws GraphIOException {
        if (this.schema.isValidEnumConstant(this.lookAhead) || this.lookAhead.equals(NULL_LITERAL)) {
            return this.matchAndNext();
        }
        throw new GraphIOException("Invalid enumeration constant '" + this.lookAhead + "' in line " + this.line);
    }

    private void parseGraphElementClass(String gcName) throws GraphIOException, SchemaException {
        GraphElementClassData graphElementClassData = new GraphElementClassData();
        if (this.lookAhead.equals("abstract")) {
            this.match();
            graphElementClassData.isAbstract = true;
        }
        if (this.lookAhead.equals("VertexClass")) {
            this.match("VertexClass");
            String[] qn = this.matchQualifiedName(true);
            graphElementClassData.packageName = qn[0];
            graphElementClassData.simpleName = qn[1];
            if (this.lookAhead.equals(":")) {
                graphElementClassData.directSuperClasses = this.parseHierarchy();
            }
            this.vertexClassBuffer.get(gcName).add(graphElementClassData);
        } else if (this.lookAhead.equals("EdgeClass")) {
            this.match();
            String[] qn = this.matchQualifiedName(true);
            graphElementClassData.packageName = qn[0];
            graphElementClassData.simpleName = qn[1];
            if (this.lookAhead.equals(":")) {
                graphElementClassData.directSuperClasses = this.parseHierarchy();
            }
            this.match("from");
            String[] fqn = this.matchQualifiedName(true);
            graphElementClassData.fromVertexClassName = this.toQNameString(fqn);
            graphElementClassData.fromMultiplicity = this.parseMultiplicity();
            graphElementClassData.fromRoleName = this.parseRoleName();
            graphElementClassData.fromAggregation = this.parseAggregation();
            this.match("to");
            String[] tqn = this.matchQualifiedName(true);
            graphElementClassData.toVertexClassName = this.toQNameString(tqn);
            graphElementClassData.toMultiplicity = this.parseMultiplicity();
            graphElementClassData.toRoleName = this.parseRoleName();
            graphElementClassData.toAggregation = this.parseAggregation();
            this.edgeClassBuffer.get(gcName).add(graphElementClassData);
        } else {
            throw new SchemaException("Undefined keyword: " + this.lookAhead + " at position ");
        }
        if (this.lookAhead.equals("{")) {
            graphElementClassData.attributes = this.parseAttributes();
        }
        if (this.lookAhead.equals("[")) {
            graphElementClassData.constraints = this.parseConstraints();
        }
        this.match(";");
    }

    private Set<Constraint> parseConstraints() throws GraphIOException {
        TreeSet<Constraint> constraints = new TreeSet<Constraint>();
        do {
            this.match("[");
            String msg = this.matchUtfString();
            String pred = this.matchUtfString();
            String greql = null;
            if (!this.lookAhead.equals("]")) {
                greql = this.matchUtfString();
            }
            constraints.add(new ConstraintImpl(msg, pred, greql));
            this.match("]");
        } while (this.lookAhead.equals("["));
        return constraints;
    }

    private VertexClass createVertexClass(GraphElementClassData vcd, GraphClass gc) throws GraphIOException, SchemaException {
        VertexClass vc = gc.createVertexClass(vcd.getQualifiedName());
        vc.setAbstract(vcd.isAbstract);
        this.addAttributes(vcd.attributes, vc);
        for (Constraint constraint : vcd.constraints) {
            vc.addConstraint(constraint);
        }
        this.GECsearch.put(vc, gc);
        return vc;
    }

    private EdgeClass createEdgeClass(GraphElementClassData ecd, GraphClass gc) throws GraphIOException, SchemaException {
        EdgeClass ec = gc.createEdgeClass(ecd.getQualifiedName(), gc.getVertexClass(ecd.fromVertexClassName), ecd.fromMultiplicity[0], ecd.fromMultiplicity[1], ecd.fromRoleName, ecd.fromAggregation, gc.getVertexClass(ecd.toVertexClassName), ecd.toMultiplicity[0], ecd.toMultiplicity[1], ecd.toRoleName, ecd.toAggregation);
        this.addAttributes(ecd.attributes, ec);
        for (Constraint constraint : ecd.constraints) {
            ec.addConstraint(constraint);
        }
        ec.setAbstract(ecd.isAbstract);
        this.GECsearch.put(ec, gc);
        return ec;
    }

    private int[] parseMultiplicity() throws GraphIOException {
        int max;
        int[] multis = new int[2];
        this.match("(");
        int min = this.matchInteger();
        if (min < 0) {
            throw new GraphIOException("Minimum multiplicity '" + min + "' must be >=0 in line " + this.line);
        }
        this.match(",");
        if (this.lookAhead.equals("*")) {
            max = Integer.MAX_VALUE;
            this.match();
        } else {
            max = this.matchInteger();
            if (max < min) {
                throw new GraphIOException("Maximum multiplicity '" + max + "' must be * or >=" + min + " in line " + this.line);
            }
        }
        this.match(")");
        multis[0] = min;
        multis[1] = max;
        return multis;
    }

    private String parseRoleName() throws GraphIOException {
        if (this.lookAhead.equals("role")) {
            this.match();
            String result = this.matchSimpleName(false);
            return result;
        }
        return "";
    }

    private AggregationKind parseAggregation() throws GraphIOException {
        if (!this.lookAhead.equals("aggregation")) {
            return AggregationKind.NONE;
        }
        this.match();
        if (this.lookAhead.equals("none")) {
            this.match();
            return AggregationKind.NONE;
        }
        if (this.lookAhead.equals("shared")) {
            this.match();
            return AggregationKind.SHARED;
        }
        if (this.lookAhead.equals("composite")) {
            this.match();
            return AggregationKind.COMPOSITE;
        }
        throw new GraphIOException("Invalid aggregation: expected 'none', 'shared', or 'composite', but found '" + this.lookAhead + "' in line " + this.line);
    }

    private static boolean isValidPackageName(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] chars = s.toCharArray();
        if (!Character.isLetter(chars[0]) || !Character.isLowerCase(chars[0]) || chars[0] > '\u007f') {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if ((Character.isLowerCase(chars[i]) || Character.isDigit(chars[i]) || chars[i] == '_') && chars[i] <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private List<ComponentData> parseRecordComponents() throws GraphIOException {
        ArrayList<ComponentData> componentsData = new ArrayList<ComponentData>();
        TreeSet<String> names = new TreeSet<String>();
        this.match("(");
        ComponentData cd = new ComponentData();
        cd.name = this.matchSimpleName(false);
        this.match(":");
        cd.domainDescription = this.parseAttrDomain();
        componentsData.add(cd);
        names.add(cd.name);
        while (this.lookAhead.equals(",")) {
            this.match(",");
            cd = new ComponentData();
            cd.name = this.matchSimpleName(false);
            this.match(":");
            cd.domainDescription = this.parseAttrDomain();
            if (names.contains(cd.name)) {
                throw new GraphIOException("Duplicate record component name '" + cd.name + "' in line " + this.line);
            }
            componentsData.add(cd);
            names.add(cd.name);
        }
        this.match(")");
        return componentsData;
    }

    private List<String> parseEnumConstants() throws GraphIOException {
        this.match("(");
        ArrayList<String> enums = new ArrayList<String>();
        enums.add(this.matchEnumConstant());
        while (this.lookAhead.equals(",")) {
            this.match();
            String s = this.matchEnumConstant();
            if (enums.contains(s)) {
                throw new GraphIOException("Duplicate enumeration constant name '" + this.lookAhead + "' in line " + this.line);
            }
            enums.add(s);
        }
        this.match(")");
        return enums;
    }

    private void buildVertexClassHierarchy() throws GraphIOException, SchemaException {
        for (Map.Entry<String, List<GraphElementClassData>> gcElements : this.vertexClassBuffer.entrySet()) {
            for (GraphElementClassData vData : gcElements.getValue()) {
                Object aec = this.schema.getAttributedElementClass(vData.getQualifiedName());
                if (aec == null) {
                    throw new GraphIOException("Undefined AttributedElementClass '" + vData.getQualifiedName() + "'");
                }
                if (!(aec instanceof VertexClass)) continue;
                for (String superClassName : vData.directSuperClasses) {
                    VertexClass superClass = this.GECsearch.get(aec).getVertexClass(superClassName);
                    if (superClass == null) {
                        throw new GraphIOException("Undefined VertexClass '" + superClassName + "'");
                    }
                    ((VertexClass)aec).addSuperClass(superClass);
                }
            }
        }
    }

    private void buildEdgeClassHierarchy() throws GraphIOException, SchemaException {
        for (Map.Entry<String, List<GraphElementClassData>> gcElements : this.edgeClassBuffer.entrySet()) {
            for (GraphElementClassData eData : gcElements.getValue()) {
                Object aec = this.schema.getAttributedElementClass(eData.getQualifiedName());
                if (aec == null) {
                    throw new GraphIOException("Undefined AttributedElementClass '" + eData.getQualifiedName() + "'");
                }
                if (!(aec instanceof EdgeClass)) {
                    throw new GraphIOException("Expected EdgeClass '" + eData.getQualifiedName() + "', but it's a " + aec.getSchemaClass().getSimpleName());
                }
                EdgeClass ec = (EdgeClass)aec;
                for (String superClassName : eData.directSuperClasses) {
                    EdgeClass superClass = this.GECsearch.get(aec).getEdgeClass(superClassName);
                    if (superClass == null) {
                        throw new GraphIOException("Undefined EdgeClass '" + superClassName + "'");
                    }
                    ec.addSuperClass(superClass);
                }
            }
        }
    }

    private void buildHierarchy() throws GraphIOException, SchemaException {
        this.buildVertexClassHierarchy();
        this.buildEdgeClassHierarchy();
    }

    private final String nextToken() throws GraphIOException {
        StringBuilder out = new StringBuilder();
        this.isUtfString = false;
        this.skipWs();
        if (this.la == 34) {
            this.readUtfString(out);
            this.isUtfString = true;
        } else if (GraphIO.isSeparator(this.la)) {
            out.append((char)this.la);
            this.la = this.read();
        } else if (this.la != -1) {
            do {
                out.append((char)this.la);
                this.la = this.read();
            } while (!GraphIO.isWs(this.la) && !GraphIO.isSeparator(this.la) && this.la != -1);
        }
        return out.toString();
    }

    private final int read() throws GraphIOException {
        try {
            if (this.putBackChar >= 0) {
                int result = this.putBackChar;
                this.putBackChar = -1;
                return result;
            }
            if (this.bufferPos < this.bufferSize) {
                return this.buffer[this.bufferPos++];
            }
            this.bufferSize = this.TGIn.read(this.buffer);
            if (this.bufferSize != -1) {
                this.bufferPos = 0;
                return this.buffer[this.bufferPos++];
            }
            return -1;
        }
        catch (IOException e) {
            throw new GraphIOException("Error on reading bytes from file, line " + this.line + ", last char read was " + (this.la >= 0 ? "'" + (char)this.la + "'" : "end of file"), e);
        }
    }

    private final void readUtfString(StringBuilder out) throws GraphIOException {
        int startLine = this.line;
        this.la = this.read();
        block10: while (this.la != -1 && this.la != 34) {
            if (this.la < 32 || this.la > 127) {
                throw new GraphIOException("Invalid character '" + (char)this.la + "' in string in line " + this.line);
            }
            if (this.la == 92) {
                this.la = this.read();
                if (this.la == -1) break;
                switch (this.la) {
                    case 92: {
                        this.la = 92;
                        break;
                    }
                    case 34: {
                        this.la = 34;
                        break;
                    }
                    case 110: {
                        this.la = 10;
                        break;
                    }
                    case 114: {
                        this.la = 13;
                        break;
                    }
                    case 116: {
                        this.la = 9;
                        break;
                    }
                    case 117: {
                        this.la = this.read();
                        if (this.la == -1) break block10;
                        String unicode = "" + (char)this.la;
                        this.la = this.read();
                        if (this.la == -1) break block10;
                        unicode = unicode + (char)this.la;
                        this.la = this.read();
                        if (this.la == -1) break block10;
                        unicode = unicode + (char)this.la;
                        this.la = this.read();
                        if (this.la == -1) break block10;
                        unicode = unicode + (char)this.la;
                        try {
                            this.la = Integer.parseInt(unicode, 16);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new GraphIOException("Invalid unicode escape sequence '\\u" + unicode + "' in line " + this.line);
                        }
                    }
                    default: {
                        throw new GraphIOException("Invalid escape sequence in string in line " + this.line);
                    }
                }
            }
            out.append((char)this.la);
            this.la = this.read();
        }
        if (this.la == -1) {
            throw new GraphIOException("Unterminated string starting in line " + startLine + ".  lookAhead = '" + this.lookAhead + "'");
        }
        this.la = this.read();
    }

    private static final boolean isWs(int c) {
        return c == 32 || c == 10 || c == 9 || c == 13;
    }

    private static final boolean isSeparator(int c) {
        return c == 59 || c == 60 || c == 62 || c == 40 || c == 41 || c == 123 || c == 125 || c == 58 || c == 91 || c == 93 || c == 44 || c == 61;
    }

    private final void skipWs() throws GraphIOException {
        while (true) {
            if (GraphIO.isWs(this.la)) {
                if (this.la == 10) {
                    ++this.line;
                }
                this.la = this.read();
                continue;
            }
            if (this.la == 47) {
                this.la = this.read();
                if (this.la >= 0 && this.la == 47) {
                    while (this.la >= 0 && this.la != 10) {
                        this.la = this.read();
                    }
                } else {
                    this.putback(this.la);
                }
            }
            if (!GraphIO.isWs(this.la)) break;
        }
    }

    private final void putback(int ch) {
        this.putBackChar = ch;
    }

    private final String matchAndNext() throws GraphIOException {
        String result = this.lookAhead;
        this.match();
        return result;
    }

    public final boolean isNextToken(String token) {
        return this.lookAhead.equals(token);
    }

    public final void match() throws GraphIOException {
        this.lookAhead = this.nextToken();
    }

    public final void match(String s) throws GraphIOException {
        if (!this.lookAhead.equals(s)) {
            throw new GraphIOException("Expected '" + s + "' but found " + (this.lookAhead.equals("") ? "end of file" : "'" + this.lookAhead + "'") + " in line " + this.line, null);
        }
        this.lookAhead = this.nextToken();
    }

    public final int matchInteger() throws GraphIOException {
        try {
            int result = Integer.parseInt(this.lookAhead);
            this.match();
            return result;
        }
        catch (NumberFormatException e) {
            throw new GraphIOException("Expected int number but found " + (this.lookAhead.equals("") ? "end of file" : "'" + this.lookAhead + "'") + " in line " + this.line, e);
        }
    }

    public final long matchLong() throws GraphIOException {
        try {
            long result = Long.parseLong(this.lookAhead);
            this.match();
            return result;
        }
        catch (NumberFormatException e) {
            throw new GraphIOException("Expected long number but found " + (this.lookAhead.equals("") ? "end of file" : "'" + this.lookAhead + "'") + " in line " + this.line, e);
        }
    }

    public final String matchSimpleName(boolean isUpperCase) throws GraphIOException {
        boolean ok;
        String s = this.lookAhead;
        boolean bl = ok = GraphIO.isValidIdentifier(s) && (isUpperCase && Character.isUpperCase(s.charAt(0)) || !isUpperCase && Character.isLowerCase(s.charAt(0)));
        if (!ok) {
            throw new GraphIOException("Invalid simple name '" + this.lookAhead + "' in line " + this.line);
        }
        this.match();
        return s;
    }

    public final String[] matchQualifiedName(boolean isUpperCase) throws GraphIOException {
        String c = this.lookAhead.indexOf(46) >= 0 ? this.lookAhead : this.toQNameString(this.currentPackageName, this.lookAhead);
        String[] result = SchemaImpl.splitQualifiedName(c);
        boolean ok = true;
        if (result[0].length() > 0) {
            String[] parts = result[0].split("\\.");
            ok = parts.length == 1 && parts[0].length() == 0 || GraphIO.isValidPackageName(parts[0]);
            for (int i = 1; i < parts.length && ok; ++i) {
                ok = ok && GraphIO.isValidPackageName(parts[i]);
            }
        }
        boolean bl = ok = ok && GraphIO.isValidIdentifier(result[1]) && (isUpperCase && Character.isUpperCase(result[1].charAt(0)) || !isUpperCase && Character.isLowerCase(result[1].charAt(0)));
        if (!ok) {
            throw new GraphIOException("Invalid qualified name '" + this.lookAhead + "' in line " + this.line);
        }
        this.match();
        return result;
    }

    public final String[] matchQualifiedName() throws GraphIOException {
        String c = this.lookAhead.indexOf(46) >= 0 ? this.lookAhead : this.toQNameString(this.currentPackageName, this.lookAhead);
        String[] result = SchemaImpl.splitQualifiedName(c);
        boolean ok = true;
        if (result[0].length() > 0) {
            String[] parts = result[0].split("\\.");
            ok = parts.length == 1 && parts[0].length() == 0 || GraphIO.isValidPackageName(parts[0]);
            for (int i = 1; i < parts.length && ok; ++i) {
                ok = ok && GraphIO.isValidPackageName(parts[i]);
            }
        }
        boolean bl = ok = ok && GraphIO.isValidIdentifier(result[1]);
        if (!ok) {
            throw new GraphIOException("Invalid qualified name '" + this.lookAhead + "' in line " + this.line);
        }
        this.match();
        return result;
    }

    private final String toQNameString(String[] qn) {
        return this.toQNameString(qn[0], qn[1]);
    }

    private final String toQNameString(String pn, String sn) {
        if (pn == null || pn.isEmpty()) {
            return sn;
        }
        return pn + "." + sn;
    }

    public final String matchUtfString() throws GraphIOException {
        if (!this.isUtfString && this.lookAhead.equals(NULL_LITERAL)) {
            this.match();
            return null;
        }
        if (this.isUtfString) {
            String result = this.lookAhead;
            this.match();
            String s = this.stringPool.get(result);
            if (s == null) {
                this.stringPool.put(result, result);
            } else {
                result = s;
            }
            return result;
        }
        throw new GraphIOException("Expected a string constant but found " + (this.lookAhead.equals("") ? "end of file" : "'" + this.lookAhead + "'") + " in line " + this.line);
    }

    public final boolean matchBoolean() throws GraphIOException {
        if (!this.lookAhead.equals(TRUE_LITERAL) && !this.lookAhead.equals(FALSE_LITERAL)) {
            throw new GraphIOException("Expected a boolean constant ('f' or 't') but found " + (this.lookAhead.equals("") ? "end of file" : "'" + this.lookAhead + "'") + " in line " + this.line);
        }
        boolean result = this.lookAhead.equals(TRUE_LITERAL);
        this.match();
        return result;
    }

    private GraphBaseImpl graph(ProgressFunction pf) throws GraphIOException {
        this.currentPackageName = "";
        this.match("Graph");
        String graphId = this.matchUtfString();
        long graphVersion = this.matchLong();
        this.gcName = this.matchAndNext();
        assert (!this.gcName.contains(".") && GraphIO.isValidIdentifier(this.gcName)) : "illegal characters in graph class '" + this.gcName + "'";
        if (!this.schema.getGraphClass().getQualifiedName().equals(this.gcName)) {
            throw new GraphIOException("Graph Class " + this.gcName + "does not exist in " + this.schema.getQualifiedName());
        }
        this.match("(");
        int maxV = this.matchInteger();
        int maxE = this.matchInteger();
        int vCount = this.matchInteger();
        int eCount = this.matchInteger();
        this.match(")");
        if (vCount > maxV) {
            throw new GraphIOException("Number of vertices in graph (" + vCount + ") exceeds maximum number of vertices (" + maxV + ")");
        }
        if (eCount > maxE) {
            throw new GraphIOException("Number of edges in graph (" + eCount + ") exceeds maximum number of edges (" + maxE + ")");
        }
        this.edgeIn = new Vertex[maxE + 1];
        this.edgeOut = new Vertex[maxE + 1];
        this.firstIncidence = new int[maxV + 1];
        this.nextIncidence = new int[2 * maxE + 1];
        this.edgeOffset = maxE;
        long graphElements = 0L;
        long currentCount = 0L;
        long interval = 1L;
        if (pf != null) {
            pf.init(vCount + eCount);
            interval = pf.getUpdateInterval();
        }
        GraphBaseImpl graph = (GraphBaseImpl)this.graphFactory.createGraph(this.schema.getGraphClass(), graphId, maxV, maxE);
        graph.setLoading(true);
        graph.readAttributeValues(this);
        this.match(";");
        int vNo = 1;
        while (vNo <= vCount) {
            if (this.lookAhead.equals("Package")) {
                this.parsePackage();
                continue;
            }
            this.vertexDesc(graph);
            if (pf != null) {
                ++graphElements;
                if (++currentCount == interval) {
                    pf.progress(graphElements);
                    currentCount = 0L;
                }
            }
            ++vNo;
        }
        int eNo = 1;
        while (eNo <= eCount) {
            if (this.lookAhead.equals("Package")) {
                this.parsePackage();
                continue;
            }
            this.edgeDesc(graph);
            if (pf != null) {
                ++graphElements;
                if (++currentCount == interval) {
                    pf.progress(graphElements);
                    currentCount = 0L;
                }
            }
            ++eNo;
        }
        graph.setGraphVersion(graphVersion);
        if (pf != null) {
            pf.finished();
        }
        graph.internalLoadingCompleted(this.firstIncidence, this.nextIncidence);
        this.firstIncidence = null;
        this.nextIncidence = null;
        graph.setLoading(false);
        graph.loadingCompleted();
        return graph;
    }

    public final double matchDouble() throws GraphIOException {
        try {
            double result = Double.parseDouble(this.lookAhead);
            this.match();
            return result;
        }
        catch (NumberFormatException e) {
            throw new GraphIOException("expected a double value but found '" + this.lookAhead + "' in line " + this.line, e);
        }
    }

    private void vertexDesc(Graph graph) throws GraphIOException {
        int vId = this.vId();
        String vcName = this.className();
        VertexClass vc = (VertexClass)this.schema.getAttributedElementClass(vcName);
        Object vertex = this.graphFactory.createVertex(vc, vId, graph);
        this.parseIncidentEdges((Vertex)vertex);
        vertex.readAttributeValues(this);
        this.match(";");
    }

    private void edgeDesc(Graph graph) throws GraphIOException {
        int eId = this.eId();
        String ecName = this.className();
        EdgeClass ec = (EdgeClass)this.schema.getAttributedElementClass(ecName);
        Object edge = this.graphFactory.createEdge(ec, eId, graph, this.edgeOut[eId], this.edgeIn[eId]);
        edge.readAttributeValues(this);
        this.match(";");
    }

    private int eId() throws GraphIOException {
        int eId = this.matchInteger();
        if (eId == 0) {
            throw new GraphIOException("Invalid edge id " + eId + ".");
        }
        return eId;
    }

    private String className() throws GraphIOException {
        String[] qn = this.matchQualifiedName(true);
        return this.toQNameString(qn);
    }

    private int vId() throws GraphIOException {
        int vId = this.matchInteger();
        if (vId <= 0) {
            throw new GraphIOException("Invalid vertex id " + vId + ".");
        }
        return vId;
    }

    private void parseIncidentEdges(Vertex v) throws GraphIOException {
        int eId = 0;
        int prevId = 0;
        int vId = v.getId();
        this.match("<");
        if (!this.lookAhead.equals(">")) {
            this.firstIncidence[vId] = eId = this.eId();
            if (eId < 0) {
                this.edgeIn[-eId] = v;
            } else {
                this.edgeOut[eId] = v;
            }
        }
        while (!this.lookAhead.equals(">")) {
            prevId = eId;
            this.nextIncidence[this.edgeOffset + prevId] = eId = this.eId();
            if (eId < 0) {
                this.edgeIn[-eId] = v;
                continue;
            }
            this.edgeOut[eId] = v;
        }
        this.match();
    }

    public static String toUtfString(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder out = new StringBuilder("\"");
        CharBuffer cb = CharBuffer.wrap(value);
        block12: while (cb.hasRemaining()) {
            char c = cb.get();
            switch (c) {
                case '\"': {
                    out.append("\\\"");
                    continue block12;
                }
                case '\n': {
                    out.append("\\n");
                    continue block12;
                }
                case '\r': {
                    out.append("\\r");
                    continue block12;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block12;
                }
                case '\t': {
                    out.append("\\t");
                    continue block12;
                }
            }
            if (c >= ' ' && c <= '\u007f') {
                out.append(c);
                continue;
            }
            out.append("\\u");
            String s = Integer.toHexString(c);
            switch (s.length()) {
                case 1: {
                    out.append("000");
                    break;
                }
                case 2: {
                    out.append("00");
                    break;
                }
                case 3: {
                    out.append("0");
                }
            }
            out.append(s);
        }
        out.append("\"");
        return out.toString();
    }

    private static boolean isValidIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] chars = s.toCharArray();
        if (!Character.isLetter(chars[0]) || chars[0] > '\u007f') {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if ((Character.isLetter(chars[i]) || Character.isDigit(chars[i]) || chars[i] == '_') && chars[i] <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private void sortRecordDomains() throws GraphIOException {
        ArrayList<RecordDomainData> orderedRdList = new ArrayList<RecordDomainData>();
        boolean componentDomsInOrderedList = true;
        while (!this.recordDomainBuffer.isEmpty()) {
            Iterator<RecordDomainData> rdit = this.recordDomainBuffer.iterator();
            while (rdit.hasNext()) {
                RecordDomainData rd = rdit.next();
                componentDomsInOrderedList = true;
                for (ComponentData comp : rd.components) {
                    for (String componentDomain : comp.domainDescription) {
                        String qName;
                        if (componentDomain.equals("String") || componentDomain.equals("Integer") || componentDomain.equals("Boolean") || componentDomain.equals("Long") || componentDomain.equals("Double") || componentDomain.equals("Set<") || componentDomain.equals("List<") || componentDomain.equals("Map<")) continue;
                        componentDomsInOrderedList = false;
                        for (RecordDomainData orderedRd : orderedRdList) {
                            qName = this.toQNameString(orderedRd.packageName, orderedRd.simpleName);
                            if (!componentDomain.equals(qName)) continue;
                            componentDomsInOrderedList = true;
                            break;
                        }
                        for (EnumDomainData ed : this.enumDomainBuffer) {
                            qName = this.toQNameString(ed.packageName, ed.simpleName);
                            if (!componentDomain.equals(qName)) continue;
                            componentDomsInOrderedList = true;
                            break;
                        }
                        if (componentDomsInOrderedList) continue;
                        boolean definedRdName = false;
                        for (RecordDomainData rd2 : this.recordDomainBuffer) {
                            qName = this.toQNameString(rd2.packageName, rd2.simpleName);
                            if (!qName.equals(componentDomain)) continue;
                            definedRdName = true;
                            break;
                        }
                        if (definedRdName) break;
                        throw new GraphIOException("Domain " + componentDomain + " does not exist");
                    }
                    if (componentDomsInOrderedList) continue;
                    break;
                }
                if (!componentDomsInOrderedList) continue;
                orderedRdList.add(rd);
                rdit.remove();
            }
        }
        this.recordDomainBuffer = orderedRdList;
    }

    private void sortVertexClasses() throws GraphIOException {
        TreeSet<String> orderedVcNames = new TreeSet<String>();
        List<GraphElementClassData> unorderedVcList = this.vertexClassBuffer.get(this.graphClass.name);
        ArrayList<GraphElementClassData> orderedVcList = new ArrayList<GraphElementClassData>();
        while (!unorderedVcList.isEmpty()) {
            Iterator<GraphElementClassData> vcit = unorderedVcList.iterator();
            while (vcit.hasNext()) {
                GraphElementClassData vc = vcit.next();
                if (orderedVcNames.containsAll(vc.directSuperClasses)) {
                    orderedVcNames.add(vc.getQualifiedName());
                    orderedVcList.add(vc);
                    vcit.remove();
                    continue;
                }
                for (String superClass : vc.directSuperClasses) {
                    if (orderedVcNames.contains(superClass)) continue;
                    boolean definedVcName = false;
                    for (GraphElementClassData vc2 : unorderedVcList) {
                        if (!vc2.getQualifiedName().equals(superClass)) continue;
                        definedVcName = true;
                        break;
                    }
                    if (definedVcName) continue;
                    throw new GraphIOException("VertexClass " + superClass + " does not exist");
                }
            }
        }
        this.vertexClassBuffer.put(this.graphClass.name, orderedVcList);
    }

    private void sortEdgeClasses() throws GraphIOException {
        TreeSet<String> orderedEcNames = new TreeSet<String>();
        List<GraphElementClassData> unorderedEcList = this.edgeClassBuffer.get(this.graphClass.name);
        ArrayList<GraphElementClassData> orderedEcList = new ArrayList<GraphElementClassData>();
        while (!unorderedEcList.isEmpty()) {
            Iterator<GraphElementClassData> ecit = unorderedEcList.iterator();
            while (ecit.hasNext()) {
                GraphElementClassData ec = ecit.next();
                if (orderedEcNames.containsAll(ec.directSuperClasses)) {
                    orderedEcNames.add(ec.getQualifiedName());
                    orderedEcList.add(ec);
                    ecit.remove();
                    continue;
                }
                for (String superClass : ec.directSuperClasses) {
                    if (orderedEcNames.contains(superClass)) continue;
                    boolean definedEcName = false;
                    for (GraphElementClassData ec2 : unorderedEcList) {
                        if (!ec2.getQualifiedName().equals(superClass)) continue;
                        definedEcName = true;
                        break;
                    }
                    if (definedEcName) continue;
                    throw new GraphIOException("EdgeClass " + superClass + " does not exist");
                }
            }
        }
        this.edgeClassBuffer.put(this.graphClass.name, orderedEcList);
    }

    private void checkFromToVertexClasses() throws GraphIOException {
        for (Map.Entry<String, List<GraphElementClassData>> graphClassEdge : this.edgeClassBuffer.entrySet()) {
            for (GraphElementClassData ec : graphClassEdge.getValue()) {
                boolean existingFromVertexClass = false;
                boolean existingToVertexClass = false;
                for (Map.Entry<String, List<GraphElementClassData>> graphClassVertex : this.vertexClassBuffer.entrySet()) {
                    for (GraphElementClassData vc : graphClassVertex.getValue()) {
                        if (ec.fromVertexClassName.equals(vc.getQualifiedName())) {
                            existingFromVertexClass = true;
                        }
                        if (ec.toVertexClassName.equals(vc.getQualifiedName())) {
                            existingToVertexClass = true;
                        }
                        if (!existingFromVertexClass || !existingToVertexClass) continue;
                        break;
                    }
                    if (!existingFromVertexClass || !existingToVertexClass) continue;
                    break;
                }
                if (!existingFromVertexClass) {
                    throw new GraphIOException("From-VertexClass " + ec.fromVertexClassName + " at EdgeClass " + ec.getQualifiedName() + " does not exist.");
                }
                if (existingToVertexClass) continue;
                throw new GraphIOException("To-VertexClass " + ec.toVertexClassName + " at EdgeClass " + ec.getQualifiedName() + " does not exist.");
            }
        }
    }

    private class GraphElementClassData {
        String simpleName;
        String packageName;
        boolean isAbstract = false;
        List<String> directSuperClasses = new LinkedList<String>();
        String fromVertexClassName;
        int[] fromMultiplicity = new int[]{1, Integer.MAX_VALUE};
        String fromRoleName = "";
        AggregationKind fromAggregation;
        String toVertexClassName;
        int[] toMultiplicity = new int[]{1, Integer.MAX_VALUE};
        String toRoleName = "";
        AggregationKind toAggregation;
        List<AttributeData> attributes = new ArrayList<AttributeData>();
        Set<Constraint> constraints = new HashSet<Constraint>(1);

        private GraphElementClassData() {
        }

        String getQualifiedName() {
            return GraphIO.this.toQNameString(this.packageName, this.simpleName);
        }
    }

    private static class GraphClassData {
        Set<Constraint> constraints = new HashSet<Constraint>(1);
        String name;
        boolean isAbstract = false;
        List<AttributeData> attributes = new ArrayList<AttributeData>();

        private GraphClassData() {
        }
    }

    private static class AttributeData {
        String name;
        List<String> domainDescription;
        String defaultValue;

        private AttributeData() {
        }
    }

    private static class ComponentData {
        String name;
        List<String> domainDescription;

        private ComponentData() {
        }
    }

    private static class RecordDomainData {
        String simpleName;
        String packageName;
        List<ComponentData> components;

        RecordDomainData(String packageName, String simpleName, List<ComponentData> components) {
            this.packageName = packageName;
            this.simpleName = simpleName;
            this.components = components;
        }
    }

    private static class EnumDomainData {
        String simpleName;
        String packageName;
        List<String> enumConstants;

        EnumDomainData(String packageName, String simpleName, List<String> enumConstants) {
            this.packageName = packageName;
            this.simpleName = simpleName;
            this.enumConstants = enumConstants;
        }
    }

    public static class TGFilenameFilter
    extends FileFilter
    implements FilenameFilter {
        private static TGFilenameFilter instance;

        private TGFilenameFilter() {
        }

        public static TGFilenameFilter instance() {
            if (instance == null) {
                instance = new TGFilenameFilter();
            }
            return instance;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(".+\\.[Tt][Gg](\\.[Gg][Zz])?$");
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || this.accept(f, f.getName());
        }

        @Override
        public String getDescription() {
            return "TG Files";
        }
    }
}

