/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.DepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import java.util.Iterator;
import java.util.Stack;

public class IterativeDepthFirstSearch
extends DepthFirstSearch {
    private ArrayVertexMarker<Iterator<Edge>> remainingIncidences;
    private Stack<Vertex> incompleteVertices;

    public IterativeDepthFirstSearch(Graph graph, BooleanFunction<Edge> navigable) {
        super(graph, navigable);
    }

    public IterativeDepthFirstSearch(Graph graph) {
        this(graph, null);
    }

    @Override
    public void reset() {
        super.reset();
        this.parent = new ArrayVertexMarker(this.graph);
        this.remainingIncidences = new ArrayVertexMarker(this.graph);
        this.incompleteVertices = new Stack();
    }

    @Override
    public void disableOptionalResults() {
        this.checkStateForSettingParameters();
        this.level = null;
        this.rorder = null;
    }

    @Override
    public DepthFirstSearch withoutParent() {
        this.checkStateForSettingParameters();
        throw new UnsupportedOperationException("The result \"parent\" is mandatory for iterative DFS and cannot be deactivated.");
    }

    @Override
    public IterativeDepthFirstSearch execute(Vertex root) throws AlgorithmTerminatedException {
        TraversalContext subgraph = this.graph.getTraversalContext();
        if (subgraph != null && !subgraph.containsVertex(root) || this.visitedVertices.get(root)) {
            return this;
        }
        this.startRunning();
        if (this.level != null) {
            this.level.set(root, 0);
        }
        this.number.set(root, this.num);
        this.visitors.visitRoot(root);
        this.incompleteVertices.push(root);
        while (!this.incompleteVertices.isEmpty()) {
            Iterator currentIncidences;
            Vertex currentVertex = this.incompleteVertices.peek();
            if (!this.visitedVertices.get(currentVertex)) {
                this.vertexOrder[this.num] = currentVertex;
                this.number.set(currentVertex, this.num);
                this.remainingIncidences.mark(currentVertex, currentVertex.incidences(this.traversalDirection).iterator());
                this.visitors.visitVertex(currentVertex);
                this.visitedVertices.set(currentVertex, true);
                ++this.num;
            }
            if ((currentIncidences = (Iterator)this.remainingIncidences.getMark(currentVertex)).hasNext()) {
                this.cancelIfInterrupted();
                Edge currentEdge = (Edge)currentIncidences.next();
                if (this.visitedEdges.get(currentEdge) || this.navigable != null && !this.navigable.get(currentEdge)) continue;
                Vertex nextVertex = currentEdge.getThat();
                this.edgeOrder[this.eNum] = currentEdge;
                if (this.enumber != null) {
                    this.enumber.set(currentEdge, this.eNum);
                }
                this.visitors.visitEdge(currentEdge);
                this.visitedEdges.set(currentEdge, true);
                ++this.eNum;
                if (this.visitedVertices.get(nextVertex)) {
                    this.visitors.visitFrond(currentEdge);
                    if (!this.rnumber.isDefined(nextVertex)) {
                        this.visitors.visitBackwardArc(currentEdge);
                        continue;
                    }
                    if (this.number.get(nextVertex) > this.number.get(currentVertex)) {
                        this.visitors.visitForwardArc(currentEdge);
                        continue;
                    }
                    this.visitors.visitCrosslink(currentEdge);
                    continue;
                }
                if (this.level != null) {
                    this.level.set(nextVertex, this.level.get(currentVertex) + 1);
                }
                this.parent.set(currentEdge.getThat(), currentEdge);
                this.visitors.visitTreeEdge(currentEdge);
                this.incompleteVertices.push(nextVertex);
                continue;
            }
            this.incompleteVertices.pop();
            this.rnumber.set(currentVertex, this.rNum);
            if (this.rorder != null) {
                this.rorder[this.rNum] = currentVertex;
            }
            this.visitors.leaveVertex(currentVertex);
            ++this.rNum;
            this.remainingIncidences.removeMark(currentVertex);
            if (currentVertex == root) continue;
            this.visitors.leaveTreeEdge((Edge)this.parent.get(currentVertex));
        }
        this.done();
        return this;
    }

    @Override
    public IterativeDepthFirstSearch execute() throws AlgorithmTerminatedException {
        super.execute();
        return this;
    }
}

