/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.shortest_paths;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.BreadthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.SearchAlgorithm;
import de.uni_koblenz.jgralab.algolib.functions.ArrayBinaryDoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.ArrayBinaryFunction;
import de.uni_koblenz.jgralab.algolib.functions.BinaryDoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.BinaryFunction;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.DoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.problems.DistancesSolver;
import de.uni_koblenz.jgralab.algolib.problems.NegativeCyclesSolver;
import de.uni_koblenz.jgralab.algolib.problems.ShortestPathsSolver;
import de.uni_koblenz.jgralab.algolib.problems.WeightedProblemSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class FloydAlgorithm
extends StructureOrientedAlgorithm
implements WeightedProblemSolver,
DistancesSolver,
ShortestPathsSolver,
NegativeCyclesSolver {
    private IntFunction<Vertex> indexMapping;
    private Permutation<Vertex> vertexOrder;
    private int vertexCount;
    private double[][] weightedDistance;
    private Edge[][] successor;
    private DoubleFunction<Edge> edgeWeight;
    private boolean negativeCycles;

    public FloydAlgorithm(Graph graph) {
        this(graph, null, null);
    }

    public FloydAlgorithm(Graph graph, BooleanFunction<Edge> navigable, DoubleFunction<Edge> edgeWeight) {
        super(graph, navigable);
        this.edgeWeight = edgeWeight;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm does not support any visitors.");
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public FloydAlgorithm normal() {
        super.normal();
        return this;
    }

    @Override
    public FloydAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public FloydAlgorithm undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm does not support any visitors.");
    }

    @Override
    public void setEdgeWeight(DoubleFunction<Edge> edgeWeight) {
        this.checkStateForSettingParameters();
        this.edgeWeight = edgeWeight;
    }

    public DoubleFunction<Edge> getEdgeWeight() {
        return this.edgeWeight;
    }

    @Override
    public void reset() {
        super.reset();
        this.negativeCycles = false;
        BreadthFirstSearch search = new BreadthFirstSearch(this.graph).withNumber();
        try {
            ((SearchAlgorithm)search).execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            // empty catch block
        }
        assert (search.getState() == AlgorithmStates.FINISHED);
        this.indexMapping = search.getNumber();
        this.vertexOrder = search.getVertexOrder();
        this.vertexCount = this.graph.getVCount();
        this.weightedDistance = new double[this.vertexCount + 1][this.vertexCount + 1];
        this.successor = new Edge[this.vertexCount + 1][this.vertexCount + 1];
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.traversalDirection = EdgeDirection.OUT;
    }

    @Override
    public FloydAlgorithm execute() throws AlgorithmTerminatedException {
        this.startRunning();
        int length = this.vertexCount + 1;
        for (int vId = 1; vId < length; ++vId) {
            for (int wId = 1; wId < length; ++wId) {
                this.weightedDistance[vId][wId] = Double.POSITIVE_INFINITY;
                this.successor[vId][wId] = null;
            }
            this.weightedDistance[vId][vId] = 0.0;
        }
        for (Edge e : this.graph.edges()) {
            if (this.navigable != null && !this.navigable.get(e)) continue;
            int vId = this.indexMapping.get(e.getAlpha());
            int wId = this.indexMapping.get(e.getOmega());
            double newDistance = this.edgeWeight.get(e);
            switch (this.traversalDirection) {
                case OUT: {
                    if (!(this.weightedDistance[vId][wId] > newDistance)) break;
                    this.weightedDistance[vId][wId] = newDistance;
                    this.successor[vId][wId] = e;
                    break;
                }
                case INOUT: {
                    if (!(this.weightedDistance[vId][wId] > newDistance)) break;
                    this.weightedDistance[vId][wId] = newDistance;
                    this.weightedDistance[wId][vId] = newDistance;
                    this.successor[vId][wId] = e;
                    this.successor[wId][vId] = e.getReversedEdge();
                    break;
                }
                case IN: {
                    if (!(this.weightedDistance[wId][wId] > newDistance)) break;
                    this.weightedDistance[wId][vId] = newDistance;
                    this.successor[wId][vId] = e.getReversedEdge();
                }
            }
        }
        for (int vId = 1; vId <= this.vertexCount; ++vId) {
            for (int uId = 1; uId <= this.vertexCount; ++uId) {
                for (int wId = 1; wId <= this.vertexCount; ++wId) {
                    double newDistance = this.weightedDistance[uId][vId] + this.weightedDistance[vId][wId];
                    if (this.weightedDistance[uId][wId] > newDistance) {
                        this.cancelIfInterrupted();
                        this.weightedDistance[uId][wId] = newDistance;
                        this.successor[uId][wId] = this.successor[uId][vId];
                    }
                    if (uId != wId || !(this.weightedDistance[uId][wId] < 0.0)) continue;
                    this.negativeCycles = true;
                    this.terminate();
                }
            }
        }
        this.done();
        return this;
    }

    @Override
    public BinaryDoubleFunction<Vertex, Vertex> getDistances() {
        this.checkStateForResult();
        return new ArrayBinaryDoubleFunction<Vertex>(this.weightedDistance, this.indexMapping);
    }

    @Override
    public BinaryFunction<Vertex, Vertex, Edge> getSuccessor() {
        this.checkStateForResult();
        return new ArrayBinaryFunction<Vertex, Edge>(this.successor, this.indexMapping);
    }

    public Permutation<Vertex> getVertexOrder() {
        return this.vertexOrder;
    }

    public IntFunction<Vertex> getIndexMapping() {
        return this.indexMapping;
    }

    public double[][] getInternalWeightedDistance() {
        return this.weightedDistance;
    }

    public Edge[][] getInternalSuccessor() {
        return this.successor;
    }

    @Override
    public boolean hasNegativeCycles() {
        this.checkStateForResult();
        return this.negativeCycles;
    }

    public boolean getInternalNegativeCycles() {
        return this.negativeCycles;
    }
}

