/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.topological_order;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.topological_order.visitors.TopologicalOrderVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.ArrayPermutation;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.problems.AcyclicitySolver;
import de.uni_koblenz.jgralab.algolib.problems.TopologicalOrderSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;

public class KahnKnuthAlgorithm
extends StructureOrientedAlgorithm
implements AcyclicitySolver,
TopologicalOrderSolver {
    private TopologicalOrderVisitorList visitors;
    private int tnum;
    private int firstV;
    private Vertex[] torder;
    private IntFunction<Vertex> tnumber;
    private IntFunction<Vertex> inDegree;
    private boolean acyclic;
    private EdgeDirection degreeDirection;

    public KahnKnuthAlgorithm(Graph graph, BooleanFunction<Edge> navigable) {
        super(graph, navigable);
    }

    public KahnKnuthAlgorithm(Graph graph) {
        this(graph, null);
    }

    public KahnKnuthAlgorithm withTNumber() {
        this.checkStateForSettingParameters();
        this.tnumber = new IntegerVertexMarker(this.graph);
        return this;
    }

    @Override
    public KahnKnuthAlgorithm normal() {
        super.normal();
        this.degreeDirection = EdgeDirection.IN;
        return this;
    }

    @Override
    public KahnKnuthAlgorithm reversed() {
        super.reversed();
        this.degreeDirection = EdgeDirection.OUT;
        return this;
    }

    public KahnKnuthAlgorithm withTnumber() {
        this.checkStateForSettingParameters();
        this.tnumber = new IntegerVertexMarker(this.graph);
        return this;
    }

    public KahnKnuthAlgorithm withoutTnumber() {
        this.checkStateForSettingParameters();
        this.tnumber = null;
        return this;
    }

    @Override
    public void disableOptionalResults() {
        this.checkStateForSettingParameters();
        this.tnumber = null;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        visitor.setAlgorithm(this);
        this.visitors.addVisitor(visitor);
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.visitors.removeVisitor(visitor);
    }

    @Override
    public void reset() {
        super.reset();
        this.tnum = 1;
        this.firstV = 1;
        this.torder = new Vertex[this.graph.getVCount() + 1];
        this.inDegree = new IntegerVertexMarker(this.graph);
        this.acyclic = true;
        this.visitors.reset();
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.visitors = new TopologicalOrderVisitorList();
        this.normal();
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public boolean isHybrid() {
        return false;
    }

    @Override
    public boolean isAcyclic() {
        this.checkStateForResult();
        return this.acyclic;
    }

    @Override
    public Permutation<Vertex> getTopologicalOrder() {
        this.checkStateForResult();
        return new ArrayPermutation<Vertex>(this.torder);
    }

    public IntFunction<Vertex> getTNumber() {
        this.checkStateForResult();
        return this.tnumber;
    }

    public Vertex[] getInternalTopologicalOrder() {
        return this.torder;
    }

    public IntFunction<Vertex> getInternalTNumber() {
        return this.tnumber;
    }

    public boolean getInternalAcyclic() {
        return this.acyclic;
    }

    public int getFirstV() {
        return this.firstV;
    }

    public int getTNum() {
        return this.tnum;
    }

    public IntFunction<Vertex> getInDegree() {
        return this.inDegree;
    }

    @Override
    public KahnKnuthAlgorithm execute() throws AlgorithmTerminatedException {
        this.startRunning();
        for (Vertex currentVertex : this.graph.vertices()) {
            int degree = currentVertex.getDegree(this.degreeDirection);
            this.inDegree.set(currentVertex, degree);
            if (degree != 0) continue;
            this.torder[this.tnum] = currentVertex;
            if (this.tnumber != null) {
                this.tnumber.set(currentVertex, this.tnum);
            }
            ++this.tnum;
        }
        while (this.firstV < this.tnum) {
            Vertex currentVertex = this.torder[this.firstV++];
            this.visitors.visitVertexInTopologicalOrder(currentVertex);
            for (Edge currentEdge : currentVertex.incidences(this.traversalDirection)) {
                this.cancelIfInterrupted();
                if (this.navigable != null && !this.navigable.get(currentEdge)) continue;
                Vertex nextVertex = currentEdge.getThat();
                this.inDegree.set(nextVertex, this.inDegree.get(nextVertex) - 1);
                if (this.inDegree.get(nextVertex) != 0) continue;
                this.torder[this.tnum] = nextVertex;
                if (this.tnumber != null) {
                    this.tnumber.set(nextVertex, this.tnum);
                }
                ++this.tnum;
            }
        }
        if (this.tnum < this.graph.getVCount()) {
            this.acyclic = false;
        }
        this.done();
        return this;
    }
}

