/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.weak_components;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.BreadthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitorAdapter;
import de.uni_koblenz.jgralab.algolib.algorithms.weak_components.WeakComponentsWithBFS;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.problems.IsTreeSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class IsTree
extends StructureOrientedAlgorithm
implements IsTreeSolver {
    private WeakComponentsWithBFS wcbfs;
    private SearchVisitor isTreeVisitor;
    private boolean isTree;

    public IsTree(Graph graph, BooleanFunction<Edge> navigable) {
        super(graph, navigable);
    }

    public IsTree(Graph graph) {
        this(graph, null);
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.traversalDirection = EdgeDirection.INOUT;
        this.wcbfs = new WeakComponentsWithBFS(this.graph, new BreadthFirstSearch(this.graph));
        this.isTreeVisitor = new SearchVisitorAdapter(){

            @Override
            public void visitFrond(Edge e) throws AlgorithmTerminatedException {
                IsTree.this.terminate();
            }
        };
    }

    @Override
    public void reset() {
        super.reset();
        this.isTree = false;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.wcbfs.addVisitor(visitor);
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public boolean isHybrid() {
        return false;
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.wcbfs.removeVisitor(visitor);
    }

    @Override
    public IsTreeSolver execute() throws AlgorithmTerminatedException {
        this.wcbfs.reset();
        this.wcbfs.setGraph(this.graph);
        this.wcbfs.setNavigable(this.navigable);
        this.wcbfs.addVisitor(this.isTreeVisitor);
        try {
            this.startRunning();
            this.wcbfs.execute();
            this.isTree = this.wcbfs.getKappa() <= 1;
        }
        catch (AlgorithmTerminatedException e) {
            this.isTree = false;
        }
        this.wcbfs.removeVisitor(this.isTreeVisitor);
        this.done();
        return this;
    }

    @Override
    public boolean isTree() throws IllegalStateException {
        this.checkStateForResult();
        return this.isTree;
    }

    public boolean getInternalIsTree() {
        return this.isTree;
    }
}

