/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.visitors;

import de.uni_koblenz.jgralab.algolib.algorithms.GraphAlgorithm;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import java.util.ArrayList;
import java.util.List;

public abstract class VisitorList
implements Visitor {
    private List<Visitor> visitors = new ArrayList<Visitor>();

    public void addVisitor(Visitor visitor) {
        if (!this.visitors.contains(visitor)) {
            this.visitors.add(visitor);
        }
    }

    public void removeVisitor(Visitor visitor) {
        this.visitors.remove(visitor);
    }

    public void clearVisitors() {
        this.visitors.clear();
    }

    @Override
    public void reset() {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).reset();
        }
    }

    @Override
    public void setAlgorithm(GraphAlgorithm alg) {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).setAlgorithm(alg);
        }
    }
}

