/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.eca.Condition;
import de.uni_koblenz.jgralab.eca.ECARuleManager;
import de.uni_koblenz.jgralab.eca.events.Event;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;

public class GreqlCondition<AEC extends AttributedElementClass<AEC, ?>>
implements Condition<AEC> {
    private final String conditionExpression;

    public GreqlCondition(String conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    @Override
    public boolean evaluate(Event<AEC> event) {
        AttributedElement<AEC, ?> element = event.getElement();
        Graph datagraph = ((ECARuleManager)event.getGraph().getECARuleManager()).getGraph();
        GreqlQuery query = null;
        GreqlEnvironmentAdapter environment = new GreqlEnvironmentAdapter();
        if (this.conditionExpression.contains("context")) {
            query = GreqlQuery.createQuery("using context: " + this.conditionExpression);
            environment.setVariable("context", element);
        } else {
            query = GreqlQuery.createQuery(this.conditionExpression);
        }
        return (Boolean)query.evaluate(datagraph, environment);
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public String toString() {
        return "Condition: " + this.conditionExpression;
    }
}

