/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca.events;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.eca.ECAException;
import de.uni_koblenz.jgralab.eca.ECARule;
import de.uni_koblenz.jgralab.eca.events.CreateEdgeEvent;
import de.uni_koblenz.jgralab.eca.events.EventDescription;
import de.uni_koblenz.jgralab.schema.EdgeClass;

public class CreateEdgeEventDescription
extends EventDescription<EdgeClass> {
    public CreateEdgeEventDescription(EventDescription.EventTime time, EdgeClass type) {
        super(time, type);
    }

    public CreateEdgeEventDescription(EventDescription.EventTime time, String contextExpr) {
        super(time, contextExpr);
        if (time.equals((Object)EventDescription.EventTime.BEFORE)) {
            throw new ECAException("Event \"before create Edge\" can not match a context expression because there is no element.");
        }
    }

    public void fire(Edge element) {
        if (super.checkContext(element)) {
            int nested = this.getActiveECARules().get(0).getECARuleManager().getNestedTriggerCalls();
            Graph graph = this.getActiveECARules().get(0).getECARuleManager().getGraph();
            for (ECARule rule : this.activeRules) {
                rule.trigger(new CreateEdgeEvent(nested, graph, element));
            }
        }
    }

    public void fire(EdgeClass type) {
        if (super.checkContext(type)) {
            int nested = this.getActiveECARules().get(0).getECARuleManager().getNestedTriggerCalls();
            Graph graph = this.getActiveECARules().get(0).getECARuleManager().getGraph();
            for (ECARule rule : this.activeRules) {
                rule.trigger(new CreateEdgeEvent(nested, graph, (EdgeClass)this.getType()));
            }
        }
    }
}

