/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.ArrayGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.ArrayGraphMarkerIterator;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayVertexMarker<O>
extends ArrayGraphMarker<Vertex, O> {
    public ArrayVertexMarker(Graph graph) {
        super(graph, ((InternalGraph)graph).getMaxVCount() + 1);
    }

    @Override
    public void edgeDeleted(Edge e) {
    }

    @Override
    public void maxEdgeCountIncreased(int newValue) {
    }

    @Override
    public void maxVertexCountIncreased(int newValue) {
        if (++newValue > this.temporaryAttributes.length) {
            this.expand(newValue);
        }
    }

    @Override
    public void vertexDeleted(Vertex v) {
        this.removeMark(v);
    }

    @Override
    public Iterable<Vertex> getMarkedElements() {
        return new Iterable<Vertex>(){

            @Override
            public Iterator<Vertex> iterator() {
                return new ArrayGraphMarkerIterator<Vertex>(ArrayVertexMarker.this.version){

                    @Override
                    public boolean hasNext() {
                        return this.index < ArrayVertexMarker.this.temporaryAttributes.length;
                    }

                    @Override
                    protected void moveIndex() {
                        int length = ArrayVertexMarker.this.temporaryAttributes.length;
                        while (this.index < length && ArrayVertexMarker.this.temporaryAttributes[this.index] == null) {
                            ++this.index;
                        }
                    }

                    @Override
                    public Vertex next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException(NO_MORE_ELEMENTS_ERROR_MESSAGE);
                        }
                        if (this.version != ArrayVertexMarker.this.version) {
                            throw new ConcurrentModificationException(MODIFIED_ERROR_MESSAGE);
                        }
                        Vertex next = ArrayVertexMarker.this.graph.getVertex(this.index++);
                        this.moveIndex();
                        return next;
                    }
                };
            }
        };
    }
}

