/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.ArrayGraphMarkerIterator;
import de.uni_koblenz.jgralab.graphmarker.BitSetGraphMarker;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BitSetEdgeMarker
extends BitSetGraphMarker<Edge> {
    public BitSetEdgeMarker(Graph graph) {
        super(graph);
    }

    @Override
    public void edgeDeleted(Edge e) {
        this.removeMark(e.getNormalEdge());
    }

    @Override
    public void vertexDeleted(Vertex v) {
    }

    @Override
    public boolean mark(Edge edge) {
        return super.mark(edge.getNormalEdge());
    }

    @Override
    public boolean removeMark(Edge edge) {
        return super.removeMark(edge.getNormalEdge());
    }

    @Override
    public boolean isMarked(Edge edge) {
        return super.isMarked(edge.getNormalEdge());
    }

    @Override
    public Iterable<Edge> getMarkedElements() {
        return new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return new ArrayGraphMarkerIterator<Edge>(BitSetEdgeMarker.this.version){

                    @Override
                    public boolean hasNext() {
                        return this.index != -1;
                    }

                    @Override
                    protected void moveIndex() {
                        this.index = BitSetEdgeMarker.this.marks.nextSetBit(++this.index);
                    }

                    @Override
                    public Edge next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException(NO_MORE_ELEMENTS_ERROR_MESSAGE);
                        }
                        if (this.version != BitSetEdgeMarker.this.version) {
                            throw new ConcurrentModificationException(MODIFIED_ERROR_MESSAGE);
                        }
                        Edge next = BitSetEdgeMarker.this.graph.getEdge(this.index);
                        this.moveIndex();
                        return next;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<Edge> getDomainElements() {
        return this.graph.edges();
    }
}

