/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import java.util.HashSet;

public class BooleanGraphMarker
extends AbstractBooleanGraphMarker {
    private final HashSet<GraphElement<?, ?>> markedElements = new HashSet();

    public BooleanGraphMarker(Graph g) {
        super(g);
    }

    @Override
    public final boolean isMarked(GraphElement<?, ?> elem) {
        assert (elem.getGraph() == this.graph);
        if (elem instanceof ReversedEdgeBaseImpl) {
            elem = ((ReversedEdgeBaseImpl)elem).getNormalEdge();
        }
        return this.markedElements.contains(elem);
    }

    @Override
    public final boolean mark(GraphElement<?, ?> elem) {
        assert (elem.getGraph() == this.graph);
        if (elem instanceof ReversedEdgeBaseImpl) {
            elem = ((ReversedEdgeBaseImpl)elem).getNormalEdge();
        }
        return this.markedElements.add(elem);
    }

    @Override
    public final boolean removeMark(GraphElement<?, ?> elem) {
        assert (elem.getGraph() == this.graph);
        if (elem instanceof ReversedEdgeBaseImpl) {
            elem = ((ReversedEdgeBaseImpl)elem).getNormalEdge();
        }
        return this.markedElements.remove(elem);
    }

    @Override
    public Iterable<GraphElement<?, ?>> getMarkedElements() {
        return this.markedElements;
    }

    @Override
    public int size() {
        return this.markedElements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.markedElements.isEmpty();
    }

    @Override
    public void clear() {
        this.markedElements.clear();
    }

    @Override
    public void edgeDeleted(Edge e) {
        this.markedElements.remove(e);
    }

    @Override
    public void vertexDeleted(Vertex v) {
        this.markedElements.remove(v);
    }
}

