/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.entries.IntFunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.Iterator;

public abstract class IntegerGraphMarker<T extends GraphElement<?, ?>>
extends AbstractGraphMarker<T>
implements IntFunction<T> {
    private static final int DEFAULT_UNMARKED_VALUE = Integer.MIN_VALUE;
    protected int[] temporaryAttributes;
    protected int marked;
    protected int unmarkedValue = Integer.MIN_VALUE;
    protected long version;

    protected IntegerGraphMarker(Graph graph, int size) {
        super(graph);
        this.temporaryAttributes = this.createNewArray(size);
        this.marked = 0;
    }

    private int[] createNewArray(int size) {
        int[] newArray = new int[size];
        for (int i = 0; i < size; ++i) {
            newArray[i] = this.unmarkedValue;
        }
        return newArray;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.temporaryAttributes.length; ++i) {
            this.temporaryAttributes[i] = this.unmarkedValue;
        }
        this.marked = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.marked == 0;
    }

    @Override
    public boolean isMarked(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return this.temporaryAttributes[graphElement.getId()] != this.unmarkedValue;
    }

    public int mark(T graphElement, int value) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        int out = this.temporaryAttributes[graphElement.getId()];
        this.temporaryAttributes[graphElement.getId()] = value;
        ++this.marked;
        ++this.version;
        return out;
    }

    public int getMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        int out = this.temporaryAttributes[graphElement.getId()];
        return out;
    }

    @Override
    public boolean removeMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        if (this.temporaryAttributes[graphElement.getId()] == this.unmarkedValue) {
            return false;
        }
        this.temporaryAttributes[graphElement.getId()] = this.unmarkedValue;
        --this.marked;
        ++this.version;
        return true;
    }

    @Override
    public int size() {
        return this.marked;
    }

    public int maxSize() {
        return this.temporaryAttributes.length - 1;
    }

    protected void expand(int newSize) {
        assert (newSize > this.temporaryAttributes.length);
        int[] newTemporaryAttributes = this.createNewArray(newSize);
        System.arraycopy(this.temporaryAttributes, 0, newTemporaryAttributes, 0, this.temporaryAttributes.length);
        this.temporaryAttributes = newTemporaryAttributes;
    }

    public int getUnmarkedValue() {
        return this.unmarkedValue;
    }

    public void setUnmarkedValue(int newUnmarkedValue) {
        if (newUnmarkedValue != this.unmarkedValue) {
            for (int i = 0; i < this.temporaryAttributes.length; ++i) {
                if (this.temporaryAttributes[i] == newUnmarkedValue) {
                    --this.marked;
                }
                if (this.temporaryAttributes[i] != this.unmarkedValue) continue;
                this.temporaryAttributes[i] = newUnmarkedValue;
            }
            this.unmarkedValue = newUnmarkedValue;
        }
    }

    @Override
    public int get(T parameter) {
        return this.getMark(parameter);
    }

    @Override
    public boolean isDefined(T parameter) {
        return this.isMarked(parameter);
    }

    @Override
    public void set(T parameter, int value) {
        this.mark(parameter, value);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        Iterator iter = this.getMarkedElements().iterator();
        if (iter.hasNext()) {
            GraphElement next = (GraphElement)iter.next();
            out.append(next);
            out.append(" -> ");
            out.append(this.get((T)next));
            while (iter.hasNext()) {
                out.append(",\n");
                next = (GraphElement)iter.next();
                out.append(next);
                out.append(" -> ");
                out.append(this.get((T)next));
            }
        }
        out.append("]");
        return out.toString();
    }

    @Override
    public Iterator<IntFunctionEntry<T>> iterator() {
        final Iterator markedElements = this.getMarkedElements().iterator();
        return new Iterator<IntFunctionEntry<T>>(){

            @Override
            public boolean hasNext() {
                return markedElements.hasNext();
            }

            @Override
            public IntFunctionEntry<T> next() {
                GraphElement currentElement = (GraphElement)markedElements.next();
                return new IntFunctionEntry<GraphElement>(currentElement, IntegerGraphMarker.this.get(currentElement));
            }

            @Override
            public void remove() {
                markedElements.remove();
            }
        };
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }
}

