/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphvalidator;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.graphvalidator.ConstraintViolation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.Map;
import java.util.Set;

public class MultiplicityConstraintViolation
extends ConstraintViolation {
    private String message;
    Map<AttributedElement<?, ?>, Integer> degreeMap;

    public MultiplicityConstraintViolation(EdgeClass ec, String message, Map<AttributedElement<?, ?>, Integer> degreeMap) {
        super(ec);
        this.message = message;
        this.degreeMap = degreeMap;
        this.offendingElements = degreeMap.keySet();
    }

    public int hashCode() {
        return this.message.hashCode() + this.offendingElements.hashCode() + this.degreeMap.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MultiplicityConstraintViolation) {
            MultiplicityConstraintViolation other = (MultiplicityConstraintViolation)o;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Set<AttributedElement<?, ?>> getOffendingElements() {
        return this.offendingElements;
    }

    public int getDegree(AttributedElement<?, ?> el) {
        return this.degreeMap.get(el);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Broken multiplicity constraint at EdgeClass ");
        sb.append(this.attributedElementClass.getQualifiedName());
        sb.append("! ");
        sb.append(this.message);
        sb.append(" Offending vertices: ");
        boolean first = true;
        for (AttributedElement v : this.offendingElements) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(v).append(": ").append(this.degreeMap.get(v));
        }
        return sb.toString();
    }
}

