/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.pcollections.PSet;

public class GraphIndex {
    private int indexSize;
    private Graph graph;
    private int graphSize;
    private long graphVersion;
    private HashMap<String, VertexIndexEntry> vertexIndex;

    public GraphIndex(Graph graph) {
        this.graph = graph;
        this.graphVersion = graph.getGraphVersion();
        this.graphSize = graph.getECount() + graph.getVCount();
        this.vertexIndex = new HashMap();
    }

    public boolean isValid(Graph g) {
        return g == this.graph && !g.isGraphModified(this.graphVersion);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void addVertexSet(String query, PSet<Vertex> vertexSet) {
        this.vertexIndex.put(query, new VertexIndexEntry(vertexSet));
        this.indexSize += vertexSet.size();
        this.reduceIndexSize(this.graphSize);
    }

    public PSet<Vertex> getVertexSet(String query) {
        VertexIndexEntry entry = this.vertexIndex.get(query);
        if (entry != null) {
            entry.modified();
            return entry.vertexSet;
        }
        return null;
    }

    public void reduceIndexSize(long maxIndexSize) {
        if ((long)this.indexSize <= maxIndexSize) {
            return;
        }
        TreeSet<Map.Entry<String, VertexIndexEntry>> entrySet = new TreeSet<Map.Entry<String, VertexIndexEntry>>(new Comparator<Map.Entry<String, VertexIndexEntry>>(){

            @Override
            public int compare(Map.Entry<String, VertexIndexEntry> o1, Map.Entry<String, VertexIndexEntry> o2) {
                return (int)(o1.getValue().modificationTime - o2.getValue().modificationTime);
            }
        });
        entrySet.addAll(this.vertexIndex.entrySet());
        Iterator<Map.Entry<String, VertexIndexEntry>> iter = entrySet.iterator();
        while (iter.hasNext() && (long)this.indexSize > maxIndexSize) {
            Map.Entry<String, VertexIndexEntry> currentEntry = iter.next();
            this.indexSize -= currentEntry.getValue().vertexSet.size();
            this.vertexIndex.remove(currentEntry.getKey());
        }
    }

    private static class VertexIndexEntry {
        public long modificationTime = 0L;
        public PSet<Vertex> vertexSet = null;

        public VertexIndexEntry(PSet<Vertex> v) {
            this.vertexSet = v;
            this.modificationTime = System.currentTimeMillis();
        }

        public void modified() {
            this.modificationTime = System.currentTimeMillis();
        }
    }
}

