/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlSchema;
import java.io.File;
import java.util.logging.Logger;

public class SyntaxGraphEntry {
    private final GreqlGraph syntaxGraph;
    private static Logger logger = Logger.getLogger(SyntaxGraphEntry.class.getName());
    private Optimizer optimizer;
    private String queryText;

    public GreqlGraph getSyntaxGraph() {
        return this.syntaxGraph;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public SyntaxGraphEntry(String queryText, GreqlGraph graph, Optimizer optimizer) {
        this.queryText = queryText;
        this.syntaxGraph = graph;
        this.optimizer = optimizer;
    }

    public SyntaxGraphEntry(File fileName) throws GraphIOException {
        this.syntaxGraph = GreqlSchema.instance().loadGreqlGraph(fileName.getPath());
        GreqlExpression g2e = this.syntaxGraph.getFirstGreqlExpression();
        try {
            this.queryText = (String)g2e.getAttribute("_queryText");
            String optimizerClass = (String)g2e.getAttribute("_optimizer");
            if (!optimizerClass.isEmpty()) {
                this.optimizer = (Optimizer)Class.forName(optimizerClass).newInstance();
            }
            g2e.setAttribute("_queryText", null);
            g2e.setAttribute("_optimizer", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GraphIOException(e.getMessage());
        }
    }

    public void saveToDirectory(File directory) throws GraphIOException {
        String optimizerClass = "";
        String optimizerClassSimple = "";
        GreqlExpression g2e = this.syntaxGraph.getFirstGreqlExpression();
        g2e.set_queryText(this.queryText);
        if (this.optimizer != null) {
            optimizerClass = this.optimizer.getClass().getName();
            optimizerClassSimple = this.optimizer.getClass().getSimpleName();
        }
        g2e.set_optimizer(optimizerClass);
        String fileName = directory.getPath() + File.separator + this.queryText.hashCode() + "-" + optimizerClassSimple + ".tg";
        this.syntaxGraph.save(fileName);
        logger.info("Saved SyntaxGraphEntry to \"" + fileName + "\".");
    }

    public boolean equals(Object o) {
        if (o instanceof SyntaxGraphEntry) {
            SyntaxGraphEntry e = (SyntaxGraphEntry)o;
            return this.queryText.equals(e.queryText) && this.optimizer.getClass().equals(e.optimizer.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.queryText.hashCode() + this.optimizer.getClass().hashCode();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public String toString() {
        return "{SyntaxGraphEntry@" + this.syntaxGraph.hashCode() + ":" + this.optimizer.getClass().getSimpleName() + "}";
    }
}

