/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import java.util.Iterator;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class VariableDeclaration {
    private PSet<Object> definitionSet;
    private final VariableEvaluator<Variable> variableEval;
    private final VertexEvaluator<? extends Expression> definitionSetEvaluator;
    private Iterator<Object> iter = null;
    private int iterationNumber = 0;

    VariableEvaluator<Variable> getVariableEval() {
        return this.variableEval;
    }

    public VariableDeclaration(Variable var, VertexEvaluator<? extends Expression> definitionSetEvaluator, VariableEvaluator<Variable> variableEvaluator) {
        this.variableEval = variableEvaluator;
        this.definitionSet = JGraLab.set();
        this.definitionSetEvaluator = definitionSetEvaluator;
    }

    public String toString() {
        System.out.println("Warning: Use the toString(GreqlEvaluatorImpl) method for VariableDeclarations.");
        return super.toString();
    }

    public String toString(InternalGreqlEvaluator evaluator) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Variable)this.variableEval.getVertex()).get_name());
        sb.append(" = ");
        sb.append(this.getVariableValue(evaluator));
        sb.append(" [");
        sb.append(this.iterationNumber);
        sb.append('/');
        sb.append(this.definitionSet.size());
        sb.append("]");
        return sb.toString();
    }

    public boolean iterate(InternalGreqlEvaluator evaluator) {
        ++this.iterationNumber;
        if (this.iter != null && this.iter.hasNext()) {
            this.variableEval.setValue(this.iter.next(), evaluator);
            return true;
        }
        return false;
    }

    public Object getVariableValue(InternalGreqlEvaluator evaluator) {
        return this.variableEval.getValue(evaluator);
    }

    protected void reset(InternalGreqlEvaluator evaluator) {
        this.iterationNumber = 0;
        this.variableEval.setValue((Object)Undefined.UNDEFINED, evaluator);
        Object tempAttribute = this.definitionSetEvaluator.getResult(evaluator);
        if (tempAttribute instanceof PVector) {
            PVector col = (PVector)tempAttribute;
            this.definitionSet = JGraLab.set().plusAll(col);
            if (col.size() > this.definitionSet.size()) {
                throw new GreqlException("A collection that doesn't fulfill the set property is used as variable range definition");
            }
        } else {
            PSet<Object> s;
            this.definitionSet = tempAttribute instanceof PSet ? (s = (PSet<Object>)tempAttribute) : JGraLab.set().plus(tempAttribute);
        }
        this.iter = this.definitionSet.iterator();
    }

    public int getDefinitionCardinality() {
        return 40;
    }
}

