/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.greql.evaluator.fa.DFAState;
import de.uni_koblenz.jgralab.greql.evaluator.fa.FiniteAutomaton;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class DFA
extends FiniteAutomaton {
    @Override
    public DFA getDFA() {
        return this;
    }

    public DFA(NFA nfa) {
        this.finalStates = new ArrayList();
        this.transitionList = new ArrayList();
        this.stateList = new ArrayList();
        this.eleminateEpsilonTransitions(nfa);
        this.myhillConstruction(nfa);
        this.removeDuplicateTransitions();
        this.updateStateAttributes();
    }

    private void removeDuplicateTransitions() {
        HashSet<Transition> duplicateTransitions = new HashSet<Transition>();
        for (State s : this.stateList) {
            for (int i = 0; i < s.outTransitions.size() - 1; ++i) {
                Transition t1 = s.outTransitions.get(i);
                for (int j = i + 1; j < s.outTransitions.size(); ++j) {
                    Transition t2 = s.outTransitions.get(j);
                    if (t1.endState != t2.endState || t1.startState != t2.startState || !t1.equalSymbol(t2)) continue;
                    duplicateTransitions.add(t2);
                }
            }
        }
        for (Transition t : duplicateTransitions) {
            this.transitionList.remove(t);
            t.delete();
        }
    }

    private void removeEpsilonTransition(NFA nfa, Transition epsilonTransition) {
        State X = epsilonTransition.startState;
        State Y = epsilonTransition.endState;
        if (X != Y) {
            if (Y.inTransitions.size() == 1 && nfa.initialState != Y) {
                Iterator<Transition> iter = Y.outTransitions.iterator();
                while (iter.hasNext()) {
                    Transition t = iter.next();
                    t.startState = X;
                    X.outTransitions.add(t);
                    iter.remove();
                }
                nfa.stateList.remove(Y);
                nfa.finalStates.remove(Y);
            } else {
                for (Transition currentTransition : Y.outTransitions) {
                    if (currentTransition.isEpsilon() && currentTransition.endState == X) continue;
                    Transition newTransition = currentTransition.copy(false);
                    nfa.transitionList.add(newTransition);
                    newTransition.setStartState(X);
                    newTransition.setEndState(newTransition.endState);
                }
            }
        }
        nfa.transitionList.remove(epsilonTransition);
        epsilonTransition.delete();
        if (Y.isFinal && !X.isFinal) {
            X.isFinal = true;
            nfa.finalStates.add(X);
        }
    }

    private void eleminateEpsilonTransitions(NFA nfa) {
        boolean containsEpsilonTransitions = true;
        while (containsEpsilonTransitions) {
            containsEpsilonTransitions = false;
            int curTransNr = 0;
            while (curTransNr < nfa.transitionList.size()) {
                Transition currentTransition = (Transition)nfa.transitionList.get(curTransNr);
                if (currentTransition.isEpsilon()) {
                    this.removeEpsilonTransition(nfa, currentTransition);
                    containsEpsilonTransitions = true;
                    continue;
                }
                ++curTransNr;
            }
        }
    }

    private void myhillConstruction(NFA nfa) {
        this.initialState = new DFAState(nfa.initialState);
        if (nfa.initialState.isFinal) {
            this.initialState.isFinal = true;
            this.finalStates.add(this.initialState);
        }
        this.stateList.add(this.initialState);
        for (int i = 0; i < this.stateList.size(); ++i) {
            State currentState = (State)this.stateList.get(i);
            for (int j = 0; j < currentState.outTransitions.size(); ++j) {
                Transition firstTransition = currentState.outTransitions.get(j);
                DFAState newDFAState = new DFAState(firstTransition.endState);
                this.transitionList.addAll(newDFAState.addRepresentedState(firstTransition.endState));
                for (int k = j + 1; k < currentState.outTransitions.size(); ++k) {
                    Transition secondTransition = currentState.outTransitions.get(k);
                    if (!firstTransition.equalSymbol(secondTransition)) continue;
                    if (firstTransition.endState != secondTransition.endState) {
                        this.transitionList.addAll(newDFAState.addRepresentedState(secondTransition.endState));
                    }
                    secondTransition.delete();
                    --k;
                }
                firstTransition.setEndState(newDFAState);
                boolean foundSameState = false;
                for (int k = 0; k < this.stateList.size(); ++k) {
                    DFAState stateToCheck = (DFAState)this.stateList.get(k);
                    if (!stateToCheck.representSameNFAStates(newDFAState)) continue;
                    foundSameState = true;
                    ArrayList inTransList = new ArrayList(newDFAState.inTransitions);
                    Iterator iter = inTransList.iterator();
                    while (iter.hasNext()) {
                        ((Transition)iter.next()).setEndState(stateToCheck);
                    }
                }
                if (foundSameState) continue;
                this.stateList.add(newDFAState);
                if (!newDFAState.containsFinalStateOfNFA(nfa)) continue;
                newDFAState.isFinal = true;
                this.finalStates.add(newDFAState);
            }
        }
    }
}

