/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathSearchEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.funlib.graph.ReachableVertices;
import de.uni_koblenz.jgralab.greql.schema.BackwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import org.pcollections.PSet;

public class BackwardVertexSetEvaluator
extends PathSearchEvaluator<BackwardVertexSet> {
    private boolean initialized = false;
    private VertexEvaluator<? extends Expression> targetEval = null;

    public BackwardVertexSetEvaluator(BackwardVertexSet vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    private final void initialize(InternalGreqlEvaluator evaluator) {
        Expression targetExpression = ((BackwardVertexSet)this.vertex).getFirstIsTargetExprOfIncidence(EdgeDirection.IN).getAlpha();
        this.targetEval = this.query.getVertexEvaluator(targetExpression);
        this.initialized = true;
    }

    @Override
    public PSet<Vertex> evaluate(InternalGreqlEvaluator evaluator) {
        DFA searchAutomaton;
        if (!this.initialized) {
            this.initialize(evaluator);
        }
        if ((searchAutomaton = (DFA)evaluator.getLocalAutomaton(this.vertex)) == null) {
            PathDescription p = (PathDescription)((BackwardVertexSet)this.vertex).getFirstIsPathOfIncidence(EdgeDirection.IN).getAlpha();
            PathDescriptionEvaluator pathDescEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
            NFA revertedNFA = NFA.revertNFA(pathDescEval.getNFA(evaluator));
            searchAutomaton = new DFA(revertedNFA);
            evaluator.setLocalAutomaton(this.vertex, searchAutomaton);
        }
        evaluator.progress(this.getOwnEvaluationCosts());
        Vertex targetVertex = null;
        targetVertex = (Vertex)this.targetEval.getResult(evaluator);
        return ReachableVertices.search(evaluator, targetVertex, searchAutomaton);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        long searchCosts;
        BackwardVertexSet bwvertex = (BackwardVertexSet)this.getVertex();
        Expression targetExpression = bwvertex.getFirstIsTargetExprOfIncidence().getAlpha();
        VertexEvaluator<Expression> vertexEval = this.query.getVertexEvaluator(targetExpression);
        long targetCosts = vertexEval.getCurrentSubtreeEvaluationCosts();
        PathDescription p = (PathDescription)bwvertex.getFirstIsPathOfIncidence().getAlpha();
        PathDescriptionEvaluator pathDescEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
        long pathDescCosts = pathDescEval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = searchCosts = Math.round((double)(pathDescCosts * 20L) * Math.sqrt(this.query.getOptimizer().getOptimizerInfo().getAverageEdgeCount()));
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = targetCosts + pathDescCosts + iteratedCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        return 5L;
    }
}

