/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.ConditionalExpression;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsFalseExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsTrueExprOf;

public class ConditionalExpressionEvaluator
extends VertexEvaluator<ConditionalExpression> {
    public ConditionalExpressionEvaluator(ConditionalExpression vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        Expression condition = ((ConditionalExpression)this.vertex).getFirstIsConditionOfIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> conditionEvaluator = this.query.getVertexEvaluator(condition);
        Object conditionResult = conditionEvaluator.getResult(evaluator);
        Expression expressionToEvaluate = null;
        Boolean value = (Boolean)conditionResult;
        expressionToEvaluate = value != false ? ((ConditionalExpression)this.vertex).getFirstIsTrueExprOfIncidence(EdgeDirection.IN).getAlpha() : ((ConditionalExpression)this.vertex).getFirstIsFalseExprOfIncidence(EdgeDirection.IN).getAlpha();
        Object result = null;
        if (expressionToEvaluate != null) {
            VertexEvaluator<Expression> exprEvaluator = this.query.getVertexEvaluator(expressionToEvaluate);
            result = exprEvaluator.getResult(evaluator);
            evaluator.setLocalEvaluationResult(this.vertex, result);
        } else {
            evaluator.removeLocalEvaluationResult(this.vertex);
            result = null;
        }
        return result;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        ConditionalExpression vertex = (ConditionalExpression)this.getVertex();
        Expression condition = vertex.getFirstIsConditionOfIncidence().getAlpha();
        VertexEvaluator<Expression> conditionEvaluator = this.query.getVertexEvaluator(condition);
        long conditionCosts = conditionEvaluator.getCurrentSubtreeEvaluationCosts();
        Expression expressionToEvaluate = vertex.getFirstIsTrueExprOfIncidence().getAlpha();
        VertexEvaluator<Expression> vertexEval = this.query.getVertexEvaluator(expressionToEvaluate);
        long trueCosts = vertexEval.getCurrentSubtreeEvaluationCosts();
        expressionToEvaluate = vertex.getFirstIsFalseExprOfIncidence().getAlpha();
        vertexEval = this.query.getVertexEvaluator(expressionToEvaluate);
        long falseCosts = vertexEval.getCurrentSubtreeEvaluationCosts();
        long maxCosts = trueCosts;
        if (falseCosts > trueCosts) {
            maxCosts = falseCosts;
        }
        long ownCosts = 4L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + maxCosts + conditionCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        long maxCard;
        ConditionalExpression condExp = (ConditionalExpression)this.getVertex();
        IsTrueExprOf trueInc = condExp.getFirstIsTrueExprOfIncidence();
        long trueCard = 0L;
        if (trueInc != null) {
            VertexEvaluator<Expression> trueEval = this.query.getVertexEvaluator(trueInc.getAlpha());
            trueCard = trueEval.getEstimatedCardinality();
        }
        IsFalseExprOf falseInc = condExp.getFirstIsFalseExprOfIncidence();
        long falseCard = 0L;
        if (falseInc != null) {
            VertexEvaluator<Expression> falseEval = this.query.getVertexEvaluator(falseInc.getAlpha());
            falseCard = falseEval.getEstimatedCardinality();
        }
        if (falseCard > (maxCard = trueCard)) {
            maxCard = falseCard;
        }
        return maxCard;
    }
}

