/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclaration;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclarationLayer;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.SimpleDeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.ArrayList;
import java.util.Iterator;
import org.pcollections.PVector;

public class DeclarationEvaluator
extends VertexEvaluator<Declaration> {
    protected static final int declarationCostsFactor = 5;

    public DeclarationEvaluator(Declaration vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public VariableDeclarationLayer evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        ArrayList<VertexEvaluator<? extends Expression>> constraintList = new ArrayList<VertexEvaluator<? extends Expression>>();
        for (IsConstraintOf consInc : ((Declaration)this.vertex).getIsConstraintOfIncidences(EdgeDirection.IN)) {
            VertexEvaluator<Expression> curEval = this.query.getVertexEvaluator(consInc.getAlpha());
            if (curEval == null) continue;
            constraintList.add(curEval);
        }
        ArrayList<VariableDeclaration> varDeclList = new ArrayList<VariableDeclaration>();
        for (IsSimpleDeclOf inc : ((Declaration)this.vertex).getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            SimpleDeclaration simpleDecl = inc.getAlpha();
            SimpleDeclarationEvaluator simpleDeclEval = (SimpleDeclarationEvaluator)this.query.getVertexEvaluator(simpleDecl);
            PVector resultCollection = (PVector)simpleDeclEval.getResult(evaluator);
            for (VariableDeclaration v : resultCollection) {
                varDeclList.add(v);
            }
        }
        VariableDeclarationLayer declarationLayer = new VariableDeclarationLayer((Declaration)this.vertex, varDeclList, constraintList);
        return declarationLayer;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        Declaration decl = (Declaration)this.getVertex();
        long simpleDeclCosts = 0L;
        for (IsSimpleDeclOf inc = decl.getFirstIsSimpleDeclOfIncidence(); inc != null; inc = inc.getNextIsSimpleDeclOfIncidence()) {
            SimpleDeclaration simpleDecl = inc.getAlpha();
            SimpleDeclarationEvaluator simpleEval = (SimpleDeclarationEvaluator)this.query.getVertexEvaluator(simpleDecl);
            simpleDeclCosts += simpleEval.getCurrentSubtreeEvaluationCosts();
        }
        int constraintsCosts = 0;
        for (IsConstraintOf consInc = decl.getFirstIsConstraintOfIncidence(); consInc != null; consInc = consInc.getNextIsConstraintOfIncidence()) {
            VertexEvaluator<Expression> constraint = this.query.getVertexEvaluator(consInc.getAlpha());
            constraintsCosts = (int)((long)constraintsCosts + constraint.getCurrentSubtreeEvaluationCosts());
        }
        long iterationCosts = this.getDefinedVariableCombinations() * 5L;
        long ownCosts = iterationCosts + 2L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + (long)constraintsCosts + simpleDeclCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    public long getDefinedVariableCombinations() {
        long combinations = 1L;
        Iterator<Variable> iter = this.getDefinedVariables().iterator();
        while (iter.hasNext()) {
            VariableEvaluator veval = (VariableEvaluator)this.query.getVertexEvaluator((GreqlVertex)iter.next());
            combinations *= veval.getVariableCombinations();
        }
        return combinations;
    }

    @Override
    public long calculateEstimatedCardinality() {
        Declaration decl = (Declaration)this.getVertex();
        double selectivity = 1.0;
        for (IsConstraintOf inc = decl.getFirstIsConstraintOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsConstraintOfIncidence(EdgeDirection.IN)) {
            VertexEvaluator<Expression> constEval = this.query.getVertexEvaluator(inc.getAlpha());
            selectivity *= constEval.getEstimatedSelectivity();
        }
        return Math.round((double)this.getDefinedVariableCombinations() * selectivity);
    }
}

