/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.EdgeRestrictionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PrimaryPathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.schema.EdgePathDescription;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsEdgeExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsEdgeRestrOf;
import de.uni_koblenz.jgralab.greql.schema.PrimaryPathDescription;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public class EdgePathDescriptionEvaluator
extends PrimaryPathDescriptionEvaluator<EdgePathDescription> {
    public EdgePathDescriptionEvaluator(EdgePathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        IsEdgeExprOf evalEdge = ((EdgePathDescription)this.vertex).getFirstIsEdgeExprOfIncidence();
        VertexEvaluator<Expression> edgeEval = null;
        if (evalEdge != null) {
            edgeEval = this.query.getVertexEvaluator((Expression)evalEdge.getAlpha());
        }
        TypeCollection typeCollection = TypeCollection.empty();
        IsEdgeRestrOf inc = ((EdgePathDescription)this.vertex).getFirstIsEdgeRestrOfIncidence(EdgeDirection.IN);
        EdgeRestrictionEvaluator edgeRestEval = null;
        VertexEvaluator<? extends Expression> predicateEvaluator = null;
        if (inc != null) {
            edgeRestEval = (EdgeRestrictionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            typeCollection = typeCollection.combine(edgeRestEval.getTypeCollection(evaluator));
            predicateEvaluator = edgeRestEval.getPredicateEvaluator();
        }
        try {
            typeCollection = typeCollection.bindToSchema(evaluator);
        }
        catch (UnknownTypeException e) {
            throw new UnknownTypeException(e.getTypeName(), this.createPossibleSourcePositions());
        }
        NFA createdNFA = NFA.createEdgePathDescriptionNFA(this.getEdgeDirection((PrimaryPathDescription)this.vertex), typeCollection, this.getEdgeRoles(edgeRestEval), edgeEval, predicateEvaluator, this.query);
        evaluator.setLocalEvaluationResult(this.vertex, createdNFA);
        return createdNFA;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        EdgePathDescription edgePathDesc = (EdgePathDescription)this.getVertex();
        VertexEvaluator<Expression> edgeEval = this.query.getVertexEvaluator(edgePathDesc.getFirstIsEdgeExprOfIncidence().getAlpha());
        long edgeCosts = edgeEval.getCurrentSubtreeEvaluationCosts();
        return new VertexCosts(10L, 10L, 10L + edgeCosts);
    }
}

