/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathSearchEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.funlib.graph.ReachableVertices;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ForwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;

public class ForwardVertexSetEvaluator
extends PathSearchEvaluator<ForwardVertexSet> {
    private boolean initialized = false;
    private VertexEvaluator<? extends Expression> startEval = null;

    public ForwardVertexSetEvaluator(ForwardVertexSet vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    private final void initialize(InternalGreqlEvaluator evaluator) {
        Expression startExpression = ((ForwardVertexSet)this.vertex).getFirstIsStartExprOfIncidence(EdgeDirection.IN).getAlpha();
        this.startEval = this.query.getVertexEvaluator(startExpression);
        this.initialized = true;
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        DFA searchAutomaton;
        if (!this.initialized) {
            this.initialize(evaluator);
        }
        if ((searchAutomaton = (DFA)evaluator.getLocalAutomaton(this.vertex)) == null) {
            PathDescription p = (PathDescription)((ForwardVertexSet)this.vertex).getFirstIsPathOfIncidence(EdgeDirection.IN).getAlpha();
            PathDescriptionEvaluator pathDescEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
            searchAutomaton = new DFA(pathDescEval.getNFA(evaluator));
            evaluator.setLocalAutomaton(this.vertex, searchAutomaton);
        }
        evaluator.progress(this.getOwnEvaluationCosts());
        Vertex startVertex = null;
        startVertex = (Vertex)this.startEval.getResult(evaluator);
        return ReachableVertices.search(evaluator, startVertex, searchAutomaton);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        long searchCosts;
        ForwardVertexSet bwvertex = (ForwardVertexSet)this.getVertex();
        Expression targetExpression = bwvertex.getFirstIsStartExprOfIncidence().getAlpha();
        VertexEvaluator<Expression> vertexEval = this.query.getVertexEvaluator(targetExpression);
        long targetCosts = vertexEval.getCurrentSubtreeEvaluationCosts();
        PathDescription p = (PathDescription)bwvertex.getFirstIsPathOfIncidence().getAlpha();
        PathDescriptionEvaluator pathDescEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
        long pathDescCosts = pathDescEval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = searchCosts = Math.round((double)(pathDescCosts * 20L) * Math.sqrt(this.query.getOptimizer().getOptimizerInfo().getAverageEdgeCount()));
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = targetCosts + pathDescCosts + iteratedCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        return 5L;
    }
}

