/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOf;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import java.util.ArrayList;

public class FunctionApplicationEvaluator
extends VertexEvaluator<FunctionApplication> {
    protected ArrayList<VertexEvaluator<? extends Expression>> parameterEvaluators = null;
    protected int paramEvalCount = 0;
    protected boolean listCreated = false;
    TypeCollection typeArgument = null;
    private String functionName = null;
    private FunLib.FunctionInfo fi = null;

    public String getFunctionName() {
        if (this.functionName == null) {
            FunctionId id = ((FunctionApplication)this.vertex).getFirstIsFunctionIdOfIncidence(EdgeDirection.IN).getAlpha();
            this.functionName = id.get_name();
        }
        return this.functionName;
    }

    public FunLib.FunctionInfo getFunctionInfo() {
        if (this.fi == null) {
            this.fi = FunLib.getFunctionInfo(this.getFunctionName());
            if (this.fi == null) {
                throw new GreqlException("Call to unknown function '" + this.getFunctionName() + "'");
            }
        }
        return this.fi;
    }

    public Function getFunction() {
        return this.getFunctionInfo().getFunction();
    }

    @Override
    public String getLoggingName() {
        return this.getFunctionName();
    }

    public FunctionApplicationEvaluator(FunctionApplication vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    protected ArrayList<VertexEvaluator<? extends Expression>> createVertexEvaluatorList() {
        ArrayList<VertexEvaluator<? extends Expression>> vertexEvalList = new ArrayList<VertexEvaluator<? extends Expression>>();
        for (IsArgumentOf inc = ((FunctionApplication)this.vertex).getFirstIsArgumentOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsArgumentOfIncidence(EdgeDirection.IN)) {
            Expression currentParameterExpr = inc.getAlpha();
            VertexEvaluator<Expression> paramEval = this.query.getVertexEvaluator(currentParameterExpr);
            vertexEvalList.add(paramEval);
        }
        return vertexEvalList;
    }

    public TypeCollection createTypeArgument(InternalGreqlEvaluator evaluator) {
        IsTypeExprOf typeEdge = ((FunctionApplication)this.vertex).getFirstIsTypeExprOfIncidence(EdgeDirection.IN);
        if (typeEdge == null) {
            return null;
        }
        TypeCollection typeCollection = TypeCollection.empty();
        while (typeEdge != null) {
            TypeId typeId = (TypeId)typeEdge.getAlpha();
            TypeIdEvaluator typeEval = (TypeIdEvaluator)this.query.getVertexEvaluator(typeId);
            typeCollection = typeCollection.combine((TypeCollection)typeEval.getResult(evaluator));
            typeEdge = typeEdge.getNextIsTypeExprOfIncidence(EdgeDirection.IN);
        }
        try {
            typeCollection = typeCollection.bindToSchema(evaluator);
        }
        catch (UnknownTypeException e) {
            throw new UnknownTypeException(e.getTypeName(), this.createPossibleSourcePositions());
        }
        return typeCollection;
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        FunLib.FunctionInfo fi = this.getFunctionInfo();
        if (!this.listCreated) {
            this.typeArgument = this.createTypeArgument(evaluator);
            this.parameterEvaluators = this.createVertexEvaluatorList();
            this.paramEvalCount = this.parameterEvaluators.size();
            this.listCreated = true;
        }
        if (this.typeArgument != null) {
            this.typeArgument = this.typeArgument.bindToSchema(evaluator);
        }
        int parameterCount = this.parameterEvaluators.size();
        if (fi.needsGraphArgument()) {
            ++parameterCount;
        }
        if (this.typeArgument != null) {
            ++parameterCount;
        }
        if (fi.needsEvaluatorArgument()) {
            ++parameterCount;
        }
        Object[] parameters = new Object[parameterCount];
        int p = 0;
        if (fi.needsEvaluatorArgument()) {
            parameters[p++] = evaluator;
        }
        if (fi.needsGraphArgument()) {
            parameters[p++] = evaluator.getGraph();
        }
        for (int i = 0; i < this.paramEvalCount; ++i) {
            parameters[p] = this.parameterEvaluators.get(i).getResult(evaluator);
            if (parameters[p] instanceof NFA) {
                parameters[p] = ((NFA)parameters[p]).getDFA();
            }
            ++p;
        }
        if (this.typeArgument != null) {
            parameters[p] = this.typeArgument;
        }
        return FunLib.apply(fi, parameters);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        FunctionApplication funApp = (FunctionApplication)this.getVertex();
        long argCosts = 0L;
        ArrayList<Long> elements = new ArrayList<Long>();
        for (IsArgumentOf inc = funApp.getFirstIsArgumentOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsArgumentOfIncidence(EdgeDirection.IN)) {
            VertexEvaluator<Expression> argEval = this.query.getVertexEvaluator(inc.getAlpha());
            argCosts += argEval.getCurrentSubtreeEvaluationCosts();
            elements.add(argEval.getEstimatedCardinality());
        }
        Function func = this.getFunction();
        long ownCosts = func.getEstimatedCosts(elements);
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + argCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public double calculateEstimatedSelectivity() {
        Function func = this.getFunction();
        if (func != null) {
            return func.getSelectivity();
        }
        return 1.0;
    }

    @Override
    public long calculateEstimatedCardinality() {
        FunctionApplication funApp = (FunctionApplication)this.getVertex();
        int elements = 0;
        for (IsArgumentOf inc = funApp.getFirstIsArgumentOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsArgumentOfIncidence(EdgeDirection.IN)) {
            VertexEvaluator<Expression> argEval = this.query.getVertexEvaluator(inc.getAlpha());
            elements = (int)((long)elements + argEval.getEstimatedCardinality());
        }
        Function func = this.getFunction();
        if (func != null) {
            return func.getEstimatedCardinality(elements);
        }
        return 1L;
    }
}

