/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.IteratedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IterationType;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;

public class IteratedPathDescriptionEvaluator
extends PathDescriptionEvaluator<IteratedPathDescription> {
    public IteratedPathDescriptionEvaluator(IteratedPathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        PathDescription p = ((IteratedPathDescription)this.vertex).getFirstIsIteratedPathOfIncidence(EdgeDirection.IN).getAlpha();
        PathDescriptionEvaluator pathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
        NFA createdNFA = NFA.createIteratedPathDescriptionNFA(pathEval.getNFA(evaluator), ((IteratedPathDescription)this.vertex).get_times() == IterationType.STAR);
        return createdNFA;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        IteratedPathDescription iterPath = (IteratedPathDescription)this.getVertex();
        VertexEvaluator<PathDescription> pathEval = this.query.getVertexEvaluator(iterPath.getFirstIsIteratedPathOfIncidence(EdgeDirection.IN).getAlpha());
        long ownCosts = 5L;
        long iteratedCosts = 5L;
        long subtreeCosts = ownCosts + pathEval.getCurrentSubtreeEvaluationCosts();
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }
}

