/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ComprehensionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.DeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsTableHeaderOf;
import de.uni_koblenz.jgralab.greql.schema.ListComprehension;
import de.uni_koblenz.jgralab.greql.types.Table;
import java.util.ArrayList;
import java.util.List;
import org.pcollections.PCollection;
import org.pcollections.PVector;

public class ListComprehensionEvaluator
extends ComprehensionEvaluator<ListComprehension> {
    private Boolean createHeader = null;
    private List<VertexEvaluator<? extends Expression>> headerEvaluators = null;

    public ListComprehensionEvaluator(ListComprehension vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    protected PCollection<Object> getResultDatastructure(InternalGreqlEvaluator evaluator) {
        if (this.createHeader == null) {
            if (((ListComprehension)this.vertex).getFirstIsTableHeaderOfIncidence(EdgeDirection.IN) != null) {
                this.headerEvaluators = new ArrayList<VertexEvaluator<? extends Expression>>();
                this.createHeader = true;
                for (IsTableHeaderOf tableInc : ((ListComprehension)this.vertex).getIsTableHeaderOfIncidences(EdgeDirection.IN)) {
                    VertexEvaluator<Expression> headerEval = this.query.getVertexEvaluator(tableInc.getAlpha());
                    this.headerEvaluators.add(headerEval);
                }
            } else {
                this.createHeader = false;
            }
        }
        if (this.createHeader.booleanValue()) {
            PVector<String> headerTuple = JGraLab.vector();
            for (VertexEvaluator<? extends Expression> headerEvaluator : this.headerEvaluators) {
                headerTuple = headerTuple.plus((String)headerEvaluator.getResult(evaluator));
            }
            Table table = Table.empty();
            return table.withTitles(headerTuple);
        }
        return JGraLab.vector();
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        ListComprehension listComp = (ListComprehension)this.getVertex();
        Declaration decl = listComp.getFirstIsCompDeclOfIncidence().getAlpha();
        DeclarationEvaluator declEval = (DeclarationEvaluator)this.query.getVertexEvaluator(decl);
        long declCosts = declEval.getCurrentSubtreeEvaluationCosts();
        Expression resultDef = listComp.getFirstIsCompResultDefOfIncidence().getAlpha();
        VertexEvaluator<Expression> resultDefEval = this.query.getVertexEvaluator(resultDef);
        long resultCosts = resultDefEval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = declEval.getEstimatedCardinality() * 5L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + resultCosts + declCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        ListComprehension listComp = (ListComprehension)this.getVertex();
        Declaration decl = listComp.getFirstIsCompDeclOfIncidence().getAlpha();
        DeclarationEvaluator declEval = (DeclarationEvaluator)this.query.getVertexEvaluator(decl);
        return declEval.getEstimatedCardinality();
    }
}

