/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclarationLayer;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ComprehensionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.DeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.MapComprehension;
import org.pcollections.PCollection;
import org.pcollections.PMap;

public class MapComprehensionEvaluator
extends ComprehensionEvaluator<MapComprehension> {
    public MapComprehensionEvaluator(MapComprehension vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    protected VertexCosts calculateSubtreeEvaluationCosts() {
        MapComprehension mapComp = (MapComprehension)this.getVertex();
        Declaration decl = mapComp.getFirstIsCompDeclOfIncidence().getAlpha();
        DeclarationEvaluator declEval = (DeclarationEvaluator)this.query.getVertexEvaluator(decl);
        long declCosts = declEval.getCurrentSubtreeEvaluationCosts();
        Expression key = mapComp.getFirstIsKeyExprOfComprehensionIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> keyEval = this.query.getVertexEvaluator(key);
        Expression value = mapComp.getFirstIsValueExprOfComprehensionIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> valEval = this.query.getVertexEvaluator(value);
        long resultCosts = keyEval.getCurrentSubtreeEvaluationCosts() + valEval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = keyEval.getEstimatedCardinality() + valEval.getEstimatedCardinality() * 10L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + resultCosts + declCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        this.initializeMaxCount(evaluator);
        VariableDeclarationLayer declLayer = this.getVariableDeclationLayer(evaluator);
        PMap<Object, Object> resultMap = JGraLab.map();
        Expression key = ((MapComprehension)this.vertex).getFirstIsKeyExprOfComprehensionIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> keyEval = this.query.getVertexEvaluator(key);
        Expression val = ((MapComprehension)this.vertex).getFirstIsValueExprOfComprehensionIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> valEval = this.query.getVertexEvaluator(val);
        declLayer.reset();
        while (declLayer.iterate(evaluator) && (long)resultMap.size() < this.maxCount) {
            Object jkey = keyEval.getResult(evaluator);
            Object jval = valEval.getResult(evaluator);
            resultMap = resultMap.plus(jkey, jval);
        }
        return resultMap;
    }

    @Override
    public long calculateEstimatedCardinality() {
        MapComprehension setComp = (MapComprehension)this.getVertex();
        Declaration decl = setComp.getFirstIsCompDeclOfIncidence().getAlpha();
        DeclarationEvaluator declEval = (DeclarationEvaluator)this.query.getVertexEvaluator(decl);
        return declEval.getEstimatedCardinality();
    }

    @Override
    protected PCollection<Object> getResultDatastructure(InternalGreqlEvaluator evaluator) {
        return null;
    }
}

