/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsKeyExprOfConstruction;
import de.uni_koblenz.jgralab.greql.schema.IsValueExprOfConstruction;
import de.uni_koblenz.jgralab.greql.schema.MapConstruction;
import org.pcollections.PMap;
import org.pcollections.PVector;

public class MapConstructionEvaluator
extends VertexEvaluator<MapConstruction> {
    public MapConstructionEvaluator(MapConstruction vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    protected VertexCosts calculateSubtreeEvaluationCosts() {
        MapConstruction mapCons = (MapConstruction)this.getVertex();
        IsKeyExprOfConstruction keyInc = mapCons.getFirstIsKeyExprOfConstructionIncidence(EdgeDirection.IN);
        IsValueExprOfConstruction valInc = mapCons.getFirstIsValueExprOfConstructionIncidence(EdgeDirection.IN);
        long parts = 0L;
        long partCosts = 0L;
        while (keyInc != null) {
            VertexEvaluator<Expression> keyEval = this.query.getVertexEvaluator(keyInc.getAlpha());
            partCosts += keyEval.getCurrentSubtreeEvaluationCosts();
            VertexEvaluator<Expression> valueEval = this.query.getVertexEvaluator(valInc.getAlpha());
            partCosts += keyEval.getCurrentSubtreeEvaluationCosts() + valueEval.getCurrentSubtreeEvaluationCosts();
            ++parts;
            keyInc = keyInc.getNextIsKeyExprOfConstructionIncidence(EdgeDirection.IN);
            valInc = valInc.getNextIsValueExprOfConstructionIncidence(EdgeDirection.IN);
        }
        long ownCosts = parts * 10L + 2L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + partCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        PMap map = JGraLab.map();
        PVector<Object> keys = JGraLab.vector();
        for (IsKeyExprOfConstruction e : ((MapConstruction)this.vertex).getIsKeyExprOfConstructionIncidences(EdgeDirection.IN)) {
            Expression exp = e.getAlpha();
            VertexEvaluator<Expression> expEval = this.query.getVertexEvaluator(exp);
            keys = keys.plus(expEval.getResult(evaluator));
        }
        PVector<Object> values = JGraLab.vector();
        for (IsValueExprOfConstruction e : ((MapConstruction)this.vertex).getIsValueExprOfConstructionIncidences(EdgeDirection.IN)) {
            Expression exp = e.getAlpha();
            VertexEvaluator<Expression> expEval = this.query.getVertexEvaluator(exp);
            values = values.plus(expEval.getResult(evaluator));
        }
        if (keys.size() != values.size()) {
            throw new GreqlException("Map construction has " + keys.size() + " key(s) and " + values.size() + " value(s).");
        }
        for (int i = 0; i < keys.size(); ++i) {
            map = map.plus(keys.get(i), values.get(i));
        }
        return map;
    }

    @Override
    public long calculateEstimatedCardinality() {
        long mappings = 0L;
        MapConstruction mapCons = (MapConstruction)this.getVertex();
        for (IsKeyExprOfConstruction inc = mapCons.getFirstIsKeyExprOfConstructionIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsKeyExprOfConstructionIncidence(EdgeDirection.IN)) {
            ++mappings;
        }
        return mappings;
    }
}

