/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsRecordExprOf;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.greql.schema.RecordId;

public class RecordElementEvaluator
extends VertexEvaluator<RecordElement> {
    private String id = null;
    private VertexEvaluator<? extends Expression> expEval = null;

    public String getId() {
        if (this.id == null) {
            RecordId idVertex = ((RecordElement)this.vertex).getFirstIsRecordIdOfIncidence(EdgeDirection.IN).getAlpha();
            this.id = idVertex.get_name();
        }
        return this.id;
    }

    public RecordElementEvaluator(RecordElement vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        if (this.expEval == null) {
            Expression recordElementExp = ((RecordElement)this.vertex).getFirstIsRecordExprOfIncidence(EdgeDirection.IN).getAlpha();
            this.expEval = this.query.getVertexEvaluator(recordElementExp);
        }
        return this.expEval.getResult(evaluator);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        RecordElement recElem = (RecordElement)this.getVertex();
        IsRecordExprOf inc = recElem.getFirstIsRecordExprOfIncidence();
        VertexEvaluator<Expression> veval = this.query.getVertexEvaluator(inc.getAlpha());
        long recordExprCosts = veval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = 3L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = recordExprCosts + iteratedCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }
}

