/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.schema.IsSequenceElementOf;
import de.uni_koblenz.jgralab.greql.schema.SequentialPathDescription;
import java.util.ArrayList;

public class SequentialPathDescriptionEvaluator
extends PathDescriptionEvaluator<SequentialPathDescription> {
    public SequentialPathDescriptionEvaluator(SequentialPathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        ArrayList<NFA> nfaList = new ArrayList<NFA>();
        for (IsSequenceElementOf inc = ((SequentialPathDescription)this.vertex).getFirstIsSequenceElementOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsSequenceElementOfIncidence(EdgeDirection.IN)) {
            PathDescriptionEvaluator pathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            nfaList.add(pathEval.getNFA(evaluator));
        }
        return NFA.createSequentialPathDescriptionNFA(nfaList);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        SequentialPathDescription p = (SequentialPathDescription)this.getVertex();
        long aggregatedCosts = 0L;
        IsSequenceElementOf inc = p.getFirstIsSequenceElementOfIncidence(EdgeDirection.IN);
        long alternatives = 0L;
        while (inc != null) {
            PathDescriptionEvaluator pathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            aggregatedCosts += pathEval.getCurrentSubtreeEvaluationCosts();
            inc = inc.getNextIsSequenceElementOfIncidence(EdgeDirection.IN);
            ++alternatives;
        }
        return new VertexCosts(10L * alternatives, 10L * alternatives, aggregatedCosts += 10L * alternatives);
    }
}

